# $Id: src.trafos.fmt.Makefile.cpp,v 1.7 1992/10/14 13:18:31 cogito Exp $
# make COMAR to PGS-notation transformator
#

DESTDIR = ELISYS
DISTRIB = ELISYS

IDL = ../../idl

SRC = errandio.c format.c cmr2pgs.c
OBJ = errandio.o format.o
HDR = errandio.h format.h
EXEFILE = cola_cmr2pgs.exe
EXE = ../../$(EXEFILE)

CFLAGS =  -I$(IDL) -DSINGLE

TIDY    = core a.out  *% *.o ERRS lintmsg
CLEAN   = $(TIDY) *.exe *.a
CLOBBER = $(CLEAN)

############################################################################

all:	fmt.a $(EXE)

install: $(EXE)
	echo install -c -s -m 0775 cola_cmr2pgs.exe $(DESTDIR)
	@rm -f $(DESTDIR)/$(EXEFILE)
	@cp $(EXE) $(DESTDIR)/$(EXEFILE)
	@chmod 0755 $(DESTDIR)/$(EXEFILE)

distrib:        $(SRC) $(HDR)
	@if test ! -d $(DISTRIB)/trafos/fmt; \
		then umask 002; mkdir $(DISTRIB)/trafos/fmt; \
		else :; \
		fi
	cp $(SRC) $(HDR) Makefile.cpp $(DISTRIB)/trafos/fmt
	cd $(DISTRIB)/trafos/fmt; chmod 0644 $(SRC) $(HDR) Makefile.cpp

tidy:
	rm -f $(TIDY)

clean:
	rm -f $(CLEAN)

clobber:
	rm -f $(CLOBBER)

############################################################################

#if defined(NO_RANLIB)
fmt.a:	$(OBJ) 
	ar crus fmt.a $(OBJ)
#else
fmt.a:	$(OBJ) 
	ar cru fmt.a $(OBJ)
	ranlib fmt.a
#endif

$(EXE): cmr2pgs.o fmt.a $(IDL)/IDL.a
	$(CC) $(CFLAGS) cmr2pgs.o fmt.a $(IDL)/IDL.a -o $(EXE)

cmr2pgs.o: $(IDL)/comar.h errandio.h format.h

errandio.o:     errandio.h

format.o:       $(IDL)/comar.h errandio.h format.h   

############################################################################

lint:
		lint -I$(IDL) -DSINGLE $(SRC) >! lintmsg

