static char RCSid[] = "$Id: int.c,v 1.10 1992/04/12 02:28:22 waite Exp $";
/* Copyright 1989, The Regents of the University of Colorado
 * Permission is granted to use any portion of this file for any purpose,
 * commercial or otherwise, provided that this notice remains unchanged.
 */

#include <stdio.h>
#include "int.h"

#ifndef NOPRINT
/***/
#if defined(__cplusplus) || defined(__STDC__)
void
prtintv(FILE *d, char *i)
#else
void
prtintv(d, i)
FILE *d; char *i;
#endif
/* Print an internal integer
 *    On exit-
 *       Internal integer i has been added to the current line of d
 ***/
{
	fprintf(d, " %d", *(int *)i);
}
#endif

/***/
#if defined(__cplusplus) || defined(__STDC__)
void
mkint(char *c, int l, int *t, char *p)
#else
void
mkint(c, l, t, p)
char *c; int l, *t; char *p;
#endif
/* Make an internal integer value from a string of digits
 *    On entry-
 *       c points to a digit string of length l
 *    On exit-
 *       An internal integer value representing the digit string
 *          has been stored at the location pointed to by p
 ***/
{
	char save;

	save = c[l]; c[l] = '\0';
	*(int *)p = atoi(c);
	c[l] = save;
}


#include <ctype.h>
#define DIGIT(x)	(isdigit(x) ? (x) - '0' : \
			islower(x) ? (x) + 10 - 'a' : (x) + 10 - 'A')
#define MBASE	('z' - 'a' + 1 + 10)

#if defined(__cplusplus) || defined(__STDC__)
long
xstrtol(char *str, char **ptr, int base)
#else
long
xstrtol(str, ptr, base)
register char *str;
char **ptr;
register int base;
#endif
{
	register long val;
	register int c;
	int xx, neg = 0;

	if (ptr != (char **)0)
		*ptr = str; /* in case no number is formed */
	if (base < 0 || base > MBASE)
		return (0); /* base is invalid -- should be a fatal error */
	if (!isalnum(c = *str)) {
		while (isspace(c))
			c = *++str;
		switch (c) {
		case '-':
			neg++;
		case '+': /* fall-through */
			c = *++str;
		}
	}
	if (base == 0)
		if (c != '0')
			base = 10;
		else if (str[1] == 'x' || str[1] == 'X')
			base = 16;
		else
			base = 8;
	/*
	 * for any base > 10, the digits incrementally following
	 *	9 are assumed to be "abc...z" or "ABC...Z"
	 */
	if (!isalnum(c) || (xx = DIGIT(c)) >= base)
		return (0); /* no number formed */
	if (base == 16 && c == '0' && isxdigit(str[2]) &&
	    (str[1] == 'x' || str[1] == 'X'))
		c = *(str += 2); /* skip over leading "0x" or "0X" */
	for (val = -DIGIT(c); isalnum(c = *++str) && (xx = DIGIT(c)) < base; )
		/* accumulate neg avoids surprises near MAXLONG */
		val = base * val - xx;
	if (ptr != (char **)0)
		*ptr = str;
	return (neg ? val : -val);
}

#if defined(__cplusplus) || defined(__STDC__)
void
c_mkint(char *c, int l, int *t, char *p)
#else
c_mkint(c, l, t, p)
char *c; int l, *t; char *p;
#endif
{
	char save;

	save = c[l]; c[l] = '\0';
	/* maybe the following should be long!! bob gray */
	*(int *)p = (int) xstrtol(c, (char **)NULL, 0);
	c[l] = save;
}


/***/
#if defined(__cplusplus) || defined(__STDC__)
void
cvtint(int i, char *p)
#else
void
cvtint(i, p)
int i; char *p;
#endif
/* Make an internal integer from a machine integer
 *    On exit-
 *       An internal integer value representing the machine integer i
 *          has been stored at the location pointed to by p
 ***/
{
	*(int *)p = i;
}

/***/
#if defined(__cplusplus) || defined(__STDC__)
int
negint(char *r, char *p)
#else
int
negint(r, p)
char *r, *p;
#endif
/* Negate an internal integer value
 *    On exit-
 *       An internal integer value representing "-r"
 *          has been stored at the location pointed to by p
 *       If the mathematical value of the expression is too large to
 *          be represented then negint = 1; otherwise negint = 0
 ***/
{
	if (*r == 0xFFFFFFFF) {
		*p = *r; return(1);
	}
	*(int *)p = -*r; return(0);
}

/***/
#if defined(__cplusplus) || defined(__STDC__)
int
intop(int o, char *l, char *r, char *p)
#else
int
intop(o, l, r, p)
int o; char *l, *r, *p;
#endif
/* Evaluate an expression with internal integer operands
 *    On exit-
 *       An internal integer value representing "l o r"
 *          has been stored at the location pointed to by p
 *       If the mathematical value of the expression is too large to
 *          be represented then intop = 1; otherwise intop = 0
 ***/
{
	switch (o) {
	case IADD: *(int *)p = *(int *)l + *(int *)r; break;
	case ISUB: *(int *)p = *(int *)l - *(int *)r; break;
	case IMUL: *(int *)p = *(int *)l * *(int *)r; break;
	case IDIV: *(int *)p = *(int *)l / *(int *)r; break;
	case IMOD: *(int *)p = *(int *)l % *(int *)r; break;
	}
	return(0);
}

/***/
#if defined(__cplusplus) || defined(__STDC__)
int
intcmp(char *l, char *r)
#else
int
intcmp(l, r)
char *l, *r;
#endif
/* Compare two internal integer values for relative magnitude
 *    On exit-
 *       If the value of "l" is less than the value of "r" then
 *          intcmp < 0
 *       Else if the value of "l" is equal to the value of "r" then
 *          intcmp = 0
 *       Else
 *          intcmp > 0
 ***/
{
	if (*(int *)l < *(int *)r) return(-1);
	if (*(int *)l > *(int *)r) return(1);
	return(0);
}
