#include <stdio.h>
#include "clplib.h"
#include "pdl_gen.h"

DefTableKey CLP_InputFile = NoKey;
int GenerateDirect = 0;
static int GenerateDirect_count = 0;
int GenerateTable = 0;
static int GenerateTable_count = 0;
static int error_count = 0;

void
clp_init (argc, argv)
int argc;
char *argv[];
{
  int i, done = 0;
  DefTableKey k;

  for (i = 1; (!done) && (i < argc); i++)
    if (strcmp (argv[i], "-direct") == 0) {
      GenerateDirect = 1;
      if (++ GenerateDirect_count > 1) {
        fprintf (stderr, "Usage: \"-direct\" can only be given once.\n");
        error_count++;
      }
    } else
    if (strcmp (argv[i], "-table") == 0) {
      GenerateTable = 1;
      if (++ GenerateTable_count > 1) {
        fprintf (stderr, "Usage: \"-table\" can only be given once.\n");
        error_count++;
      }
    } else
      { done = 1; i--; }
  if (CLP_InputFile == NoKey)
    if (i >= argc) error_count++;
    else {
      CLP_InputFile = NewKey();
      SetValue (CLP_InputFile, clp_string(argv[i++]),0);
  }
  if (error_count > 0) {
    fprintf (stderr, "Usage: %s [options] parameters\n",
             argv[0]);
    fprintf (stderr, "  options:\n");
    fprintf (stderr, "    -direct: Allow options for direct executable parser generation. (at most once)\n");
    fprintf (stderr, "    -table: Allow options for table driven parser generation. (at most once)\n");
    exit (1);
  }
}
