/*
** $Id: privlib.h,v 1.2 90/10/23 14:43:34 cogito Exp $
*/

#include "old_to_newcmr.h"

/* cmrl_val_list_equal - examines the equality of value lists
 * on entry : value lists list1 and list2
 * on exit  : TRUE iff
 *              value subtrees of list-heads and
 *              value list of list-tails are equal
 *            FALSE otherwise
 * attention : perhaps you must sort the lists first in order 
 *             get a reasonable result
 */
extern boolean cmrl_val_list_equal( /* tCOMAR *list1, tCOMAR *list2 */ );

/* cmrl_val_subtr_equal - examines the equality of value subtrees
 * on entry  : value subtrees subtr1 and subtr2
 * on exit   : TRUE iff
 *               value subtrees are equal
 *             FALSE otherwise
 */
extern boolean cmrl_val_subtr_equal( /* tCOMAR *subtr1, tCOMAR *subtr2 */ );



/**************************************************************/
/* the next part of functions returns a pointer of the        */
/* searched element if it is found.                           */
/* if the element can't be found in this list or subtree      */
/* then (tCOMAR *)NULL is returned                            */
/*                                                            */
/* cmrl_get_XXX_in_val_list searches a specified element      */
/* in the given list.                                         */
/*                                                            */
/* cmrl_get_XXX_in_val_subtr searches a specified element     */
/* in the given subtree                                       */
/*                                                            */
/* valid entries for subtree are nodes which are tagged       */
/* with P_LVAL, P_DVAL, P_NVAL or P_SVAL                      */
/**************************************************************/

extern tCOMAR *cmrl_get_dval_in_val_list( /* tCOMAR *list,
					     DID did */ );

extern tCOMAR *cmrl_get_dval_in_val_subtr( /* tCOMAR *subtr,
					      DID did */ );

extern tCOMAR *cmrl_get_sval_in_val_list( /* tCOMAR *list,
					     SID sid */ );

extern tCOMAR *cmrl_get_sval_in_val_subtr( /* tCOMAR *subtr,
					      SID sid */ );

extern tCOMAR *cmrl_get_nval_in_val_list( /* tCOMAR *list,
					     int val */ );

extern tCOMAR *cmrl_get_nval_in_val_subtr( /* tCOMAR *subtr,
					      int val */ );


/* cmrl_get_elem_in_list - searches an ELUNIT with elem in a list
 * on entry :  a production-list list
 *             DID elem
 * on exit  :  if no elunit with elemdid elem is in the list
 *                ((tCOMAR *)NULL)
 *             else
 *               a pointer to the first elunit with elemdid elem
 */
extern tCOMAR *cmrl_get_elem_in_list( /* tCOMAR *list,
				     DID elem  */ );


/* cmrl_get_elem_in_subtr - searches an ELUNIT with elem in a subtree
 * on entry : a production subtree subtr
 *            DID elem
 * on exit  : if no elunit with elemdid elem is in this subtree
 *               ((tCOMAR *)NULL)
 *            else 
 *              a pointer to the first elunit with elemdid elem
 *              in this subtree traversing it from left to right
 */
extern tCOMAR *cmrl_get_elem_in_subtr( /* tCOMAR *subtr,
				      DID elem */ );


/* cmrl_item_in_list - returns TRUE iff item addressed by item
 *                     is direct member of list 
 * on emtry : list == an undelimited list
 *            item == a pointer to a subtree
 * on exit  : returns TRUE iff item is a direct member of list
 *            else FALSE
 */
extern boolean cmrl_item_in_list( /* tCOMAR *list, *item */ );


/* cmrl_item_in_subtr - returns TRUE iff item addressed by item 
 *                      is a direct member of subtree lists
 * on entry : subtr == a production subtree subtr
 *            item  == a pointer to a subtree
 * on exit  : returns TRUE iff item is a direct member of the
 *            subtree lists
 */
extern boolean cmrl_item_in_subtr( /* tCOMAR *subtr, *item */ );


/* cmrl_subst_item_by_ruletree - substitutes item in dlist by ruletree
 * on entry : list dlist,   ( "call-by-reference" ! )
 *            item pointed to by item in dlist
 *            delimited production tree ruletree
 * on exit  : CMR_SUCCESS if item can be substituted by ruletree
 *            CMR_UNKERR else
 */
extern int cmrl_subst_item_by_ruletree( /* tCOMAR **dlist, *item,
					   *ruletree */ );


/* cmrl_first_rule_item_in_dlist - returns the first item which represents not
 *                                 an other in the dlist
 * on entry : database c,
 *            delimited list dlist
 * on exit  : return (tCOMAR *)NULL if dlist is not a delimited list
 *            else pointer to first item which represents not an other
 */
extern tCOMAR *cmrl_first_rule_item_in_dlist( /* tCOMAR *c, tCOMAR *dlist */ );


/* cmrl_next_rule_item_in_dlist - returns the first item which represents not
 *                  an other after the item specified by item in dlist
 * on entry : database c,
 *            delimited list dlist,
 *            item specifies an item in dlist
 * on exit  : return (tCOMAR *)NULL if dlist is not a delimited list or
 *              if there is not such a searched item in dlist after specified item
 *            else pointer to first item which represents not an other
 *              after specified item 
 */
extern tCOMAR *cmrl_next_rule_item_in_dlist( /* tCOMAR *c, tCOMAR *dlist, tCOMAR *item */ );

/* cmrl_first_other_item_in_dlist - returns the first item in dlist which
 *                    represents an other node
 * on entry : database c,
 *            delimited list dlist,
 * on exit  : returns (tCOMAR *)NULL if no node representing an
 *              other is in dlist or if dlist is not delimited
 *            else pointer to first node repesenting an other in dlist
 */
extern tCOMAR *cmrl_first_other_item_in_dlist( /* tCOMAR *c, tCOMAR *dlist */ );

/* cmrl_next_other_item_in_dlist - returns next item in dlist after node
 *                addressed by item which represents an other node
 * on entry : database c,
 *            delimited list dlist,
 *            item in dlist addressed by item
 * on exit  : returns (tCOMAR *)NULL if no further node representing an
 *              other is in dlist 
 *            else pointer to next node representing an other in dlist
 */
extern tCOMAR *cmrl_next_other_item_in_dlist( /* tCOMAR *c, tCOMAR *dlist,
						 tCOMAR *item */ );


/* cmrl_first_item_in_dlist - returns the first item in a delimited list
 * on entry : delimited list dlist;
 * on exit  : pointer to first item in delimited list
 *            (tCOMAR *)NULL if list is not delimited
 */
extern tCOMAR *cmrl_first_item_in_dlist( /* tCOMAR *dlist */ );


/* cmrl_next_item_in_dlist - returns the next item after a specified item in dlist
 * on entry : delimited list dlist,
 *            item specifies an item in dlist
 * on exit  : return (tCOMAR *)NULL if dlist is not a delimited list or
 *              if there is no item after specified item in dlist
 *            else pointer to first item after specified item
 */
extern tCOMAR *cmrl_next_item_in_dlist( /* tCOMAR *dlist, tCOMAR *item */ );


/* cmrl_del_eps_in_dlist - returns dlist with epsilon deleted if present in dlist
 * on entry : database c,
 *            list dlist, ( "call-by-reference" ! )
 * on exit  : returns dlist with epsilon deleted if dlist_len > 1
 *            returns dlist if epsilon not in dlist
 *            (tCOMAR *)NULL if list is not delimited
 */
extern tCOMAR *cmrl_del_eps_in_dlist( /* tCOMAR *c, tCOMAR **dlist */ );

/* cmrl_del_val_in_val_subtr - searches recursively a specified item and deletes
 *                            it from the subtr 
 * on entry : subtr is a property subtree 
 *            p  specifies the item that shall be deleted
 * on exit  : if p cannot be found nothing happens
 *            if everything is ok subtr is returned
 *            else an errorcode 
 */
extern tCOMAR *cmrl_del_val_in_val_subtr( /* tCOMAR *subtr,
					     tCOMAR *p */ );

/* cmrl_del_val_in_val_list - returns a list in which the specified item p
 *                            was deleted recursively
 * on entry : list is a property list
 *            p specifies the item that shall be deleted
 * on exit  : pointer to a list where the specified item
 *            is deleted
 */
extern tCOMAR *cmrl_del_val_in_val_list( /* tCOMAR *list,
					    tCOMAR *p  */ );


#define CMRL_NOSTART  -10 
#define CMRL_AMBSTART -11 

/* cmrl_get_startsymbols - returns a list with all possible startsymbols
 * on entry : datastructure c
 * on exit  : a list with all possible startsymbols of this
 *            grammar
 *            the list consists of ELUNIT elements
 *            if no startsymbol can be found then
 *              return((tCOMAR *)NULL)
 */
extern tCOMAR *cmrl_get_startsymbols( /* tCOMAR *c */ );


/* cmrl_otherdid_in_list - returns TRUE if there is the specified OTHER-node
 *                         at the beginning of the list
 * on entry : datastructure c
 *            a production-list list
 *            DID otherdid
 * action   : overreads elunits which represent an OTHER-node which have 
 *            not the giver otherdid
 * on exit  : returns FALSE if list is empty or if a subtree node was found
 *              that does not represent an elunit and elunit-elem is not
 *              tagged with P_OTHER
 *            TRUE otherwise
 */
extern boolean cmrl_otherdid_in_list( /* tCOMAR *c, tCOMAR *list,
					 DID otherdid  */ );

/* cmrl_otherdid_in_dlist - returns TRUE if there is the specified OTHER-node
 *                          at the beginning of the dlist
 * on entry : datastructure c
 *            a delimited production-list dlist
 *            DID otherdid
 * action   : calls and returns the result of cmrl_otherdid_in_list
 */
extern boolean cmrl_otherdid_in_dlist( /* tCOMAR *c, tCOMAR *dlist,
					  DID otherdid  */ );
