/*
** $Id: ccomarl.c,v 1.2 90/10/23 11:36:59 cogito Exp $
*/
static char rcs_id[]= "$Id: ccomarl.c,v 1.2 90/10/23 11:36:59 cogito Exp $";

/* ccomarl.c - COMAR library routines */
/* Last Change: 16.02.90	From: Kalle */

#include <stdio.h>

#include "ccomar.h"
#include "ccomarl.h"


/* SECTION 1. Higher-level access routines than provided by ccomar module. */

/* return pointer to string for symbol identified by did  */
char *cmrl_didtosymb(c, did)
p_comar  c; 
DID did;
{
    SID sid;

    if ((sid = cmr_get_def_entry_sid(c, did)) == CMR_UNKERR)
	return((char *)NULL);
    return( cmr_get_symb_entry_sym(c,sid) );
}		/* cmrl_didtosymb */


/* Return sid from COMAR symbol part, corresponding to string str. */
SID cmrl_strtosid(c, str)
p_comar c; 
String str;
{
  SEQsymb_entry travel;  symb_entry     symb ;

  foreachinSEQsymb_entry(c->symbols,travel,symb)
  { 
   if ( typeof(symb) == P_STRING && ! strcmp(symb.IDLclassCommon->str, str) )
     return(symb.IDLclassCommon->sid);
  }
 
  return(CMR_UNKERR);
}		/* cmrl_strtosid */


/* Return sid from COMAR symbol part, corresponding to string nam. */
SID cmrl_namtosid(c, nam)
p_comar  c; 
String nam;
{
  SEQsymb_entry travel;  symb_entry     symb ;

  foreachinSEQsymb_entry(c->symbols,travel,symb)
  { 
   if ( typeof(symb) == P_NAME && ! strcmp(symb.IDLclassCommon->str, nam) )
     return(symb.IDLclassCommon->sid);
  }
 
  return(CMR_UNKERR);
}		/* cmrl_namtosid */


/******* SECTION 2 inserted by PA transformed to macros by Kalle***********/
/* add objects while implicitly performing symbol table insertion */



/*  SECTION 3. Access delimited lists (preceded by begin-list delimiter) */

/* return TRUE iff tag of first item in dlist matches ptag */
Boolean cmrl_dlist_firstis(dlist, ptag)
p_comar  dlist;
int ptag;
{
    return(cmr_get_tag(cmr_list_head(dlist)) == ptag);

}		/* cmrl_dlist_first */

/* The other routines are now under the IDL-implementation
 * implemented as macros.
 */

/* SECTION 4. Cycle through productions of a COMAR specification. */

/* return did of production after that identified by p in c. */
DID cmrl_next_prod(c, p)
p_comar c;
DID p;
{
    SEQdef_entry travel;     def_entry   def;

        foreachinSEQdef_entry(c->definitions,travel,def)
         {
           if ( def.IDLclassCommon->did > p  &&  typeof(def) == P_PROD )
                 return(def.IDLclassCommon->did);
         }

        return(CMR_UNKERR);

}		/* cmrl_next_prod */


/************ Routines added by PA and modified by Kalle ***********/

/* return did of nonterminal after that identified by p in c */
DID cmrl_next_nterm(c, p)
p_comar c;
DID p;
{
    SEQdef_entry travel;     def_entry   def;

        foreachinSEQdef_entry(c->definitions,travel,def)
         {
           if ( def.IDLclassCommon->did > p  &&  typeof(def) == P_NTERM )
                 return(def.IDLclassCommon->did);
         }
				 
        return(-1);
				     
}               /* cmrl_next_nterm */


/* return did of terminal after that identified by p in c */
DID cmrl_next_term(c, p) 
p_comar c; 
DID p; 
{ 
    SEQdef_entry travel;     def_entry   def;

        foreachinSEQdef_entry(c->definitions,travel,def)
         {
           if ( def.IDLclassCommon->did > p  &&  typeof(def) == P_TERM )
                 return(def.IDLclassCommon->did);
         }
						      
        return(-1); 
							      
}               /* cmrl_next_term */


/* return did of other after that identified by p in c */
DID cmrl_next_other(c, p)  
p_comar c;    
DID p;    
{  
    SEQdef_entry travel;     def_entry   def;

        foreachinSEQdef_entry(c->definitions,travel,def)
         {
           if ( def.IDLclassCommon->did > p  &&  typeof(def) == P_OTHER )
                 return(def.IDLclassCommon->did);
         }
 						   
        return(-1);
									
}               /* cmrl_next_term */


/* return did of production with lhs after that identified by p in c */
DID cmrl_next_prod_with_lhs(c,p,lhs)
p_comar c;
DID p;
DID lhs;
{
    SEQdef_entry travel;     def_entry   def;

        foreachinSEQdef_entry(c->definitions,travel,def)
         {
           if ( def.IDLclassCommon->did > p
                &&  typeof(def) == P_PROD
                &&  def.Vp_prod->lhsdid == lhs
              )
                 return(def.IDLclassCommon->did);
         }
        return(-1);
}



/************ Routine for generating a new variable ***************/
DID cmrl_gen_nterm(c)
p_comar c;
{
       static char buffer[CMRL_BUFSIZE];
       static int number = 0;
       int sym ;
       char *str;
       SEQsymb_entry travel;  symb_entry symb; 

       do
       {
         (void) sprintf(buffer, "%s%d", CMRL_NTPREFIX, ++number);
         foreachinSEQsymb_entry(c->symbols,travel,symb)
         {
           if ( (sym = strcmp(buffer,symb.IDLclassCommon->str)) == 0 )
               break;
         }
       }
       while ( sym == 0 );
    
       str = malloc( (strlen(buffer)+1) * sizeof(char) );
       return(cmr_new_def_entry(c, P_NTERM,
                 cmr_new_symb_entry(c, P_NAME, strcpy(str,buffer))
                               )
             );
}


/* SECTION 5. Subtree and structure copy, equality, pattern match. */


/* returns copy of undelimited list */
pGenList cmrl_copy_list(t)
pGenList t;
{
  if (cmr_isempty_list(t))
      return(cmr_new_list());

  switch ( cmr_get_tag(cmr_list_head(t)) )
  {
    case P_STRING  : ;
    case P_NAME    : return( (pGenList)CpSEQsymb_entry(t) );

    case P_TERM    : ;
    case P_NTERM   : ;
    case P_OTHER   : ;
    case P_PROD    : return( (pGenList)CpSEQdef_entry(t) );
    case P_ALT     : ;
    case P_OPT     : ;
    case P_PLUS    : ;
    case P_STAR    : ;
    case P_DELREP  : ;
    case P_ELUNIT  : return( (pGenList)CpSEQunit(t) );

    case P_PROP    : ;
    case P_PROP_VAL: return( (pGenList)CpSEQprop_entry(t) );

    case P_SVAL    : ;
    case P_NVAL    : ;
    case P_DVAL    : ;
    case P_LVAL    : return( (pGenList)CpSEQvalue(t) );

    default        : return( (pGenList)NULL );
  }
}



/* returns copy of subtree t. t must be a subtype of 'unit' or 'value' */
Gen_class cmrl_copy_subtr(t)
Gen_class t;
{
  if (t == (Gen_class)NULL) return ((Gen_class)NULL);
  switch (cmr_get_tag(t)) {
     case P_ALT : return( (Gen_class)Cpp_alt((p_alt)t) );
     case P_OPT : return( (Gen_class)Cpp_opt((p_opt)t) );
     case P_STAR: return( (Gen_class)Cpp_star((p_star)t) );
     case P_PLUS: return( (Gen_class)Cpp_plus((p_plus)t) );
     case P_DELREP : return( (Gen_class)Cpp_delrep((p_delrep)t) );
     case P_ELUNIT : return( (Gen_class)Cpp_elunit((p_elunit)t) );

     case P_SVAL   : return( (Gen_class)Cpp_sval((p_sval)t) );
     case P_NVAL   : return( (Gen_class)Cpp_nval((p_nval)t) );
     case P_DVAL   : return( (Gen_class)Cpp_dval((p_dval)t) );
     case P_LVAL   : return( (Gen_class)Cpp_lval((p_lval)t) );
     
     default       : return((Gen_class)NULL);

     }
		     /* end of switch */
}                    /* end of cmrl_copy_subtr */



/* returns a modified copy of an undelimited list */
pGenList cmrl_copy_list_with_subst(t, old, new)
pGenList  t, old, new;
{
  if (cmr_isempty_list(t))
	 return(cmr_new_list());

  if (t == old) return(new);

  return(cmr_add_to_list(
            cmrl_copy_list_with_subst(cmr_list_tail(t), old, new),
	    cmrl_copy_subtr_with_subst(cmr_list_head(t), old, new)));
}

/* returns a modified copy of subtree t */
Gen_class cmrl_copy_subtr_with_subst(t, old, new)
Gen_class  t;
Gen_class old;
Gen_class new;
{
  if (t == (Gen_class)NULL) return ((Gen_class)NULL);
  if (t == old) return(new);
  
  switch (cmr_get_tag(t)) {
     case P_ALT : return( (Gen_class)cmr_new_alt(
                             cmrl_copy_list_with_subst(cmr_get_alt_units1(t),old,new),
			     cmrl_copy_list_with_subst(cmr_get_alt_units2(t),old,new)
				                )
                        );
     case P_OPT : return( (Gen_class)cmr_new_opt(
                             cmrl_copy_list_with_subst(cmr_get_opt_units(t),old,new)
				                )
                        );
     case P_STAR: return( (Gen_class)cmr_new_star(
                            cmrl_copy_list_with_subst(cmr_get_star_units(t),old,new)
				                 )
                        );
     case P_PLUS: return( (Gen_class)cmr_new_plus(
                            cmrl_copy_list_with_subst(cmr_get_plus_units(t),old,new) 
				                 )
                        );
     case P_DELREP : return( (Gen_class)cmr_new_delrep(
                                cmrl_copy_list_with_subst(cmr_get_delrep_units1(t),old,new),
				cmrl_copy_list_with_subst(cmr_get_delrep_units2(t),old,new) 
					              )
                           );
     case P_ELUNIT : return( (Gen_class)cmr_new_elunit(cmr_get_elunit_elem(t)));
     case P_SVAL   : return( (Gen_class)cmr_new_sval(cmr_get_sval_sid(t)));
     case P_NVAL   : return( (Gen_class)cmr_new_nval(cmr_get_nval_val(t)));
     case P_DVAL   : return( (Gen_class)cmr_new_dval(cmr_get_dval_did(t)));
     case P_LVAL   : return( (Gen_class)cmr_new_lval(
                                cmrl_copy_list_with_subst(cmr_get_lval_list(t),old,new)
					            )
                           );

     default       : return((Gen_class)NULL);
     
     }
		     /* end of switch */
}                    /* end of copy_subtr_with_subst */



/* returns a production tree for rules with specified lhs */
pGenList cmrl_cmbine_rules_with_lhs(c, lhs)
p_comar c;
DID lhs;
{
DID d1, d2;
pGenList l1;
   d1 = cmrl_first_prod_with_lhs(c,lhs);
   if (d1 == -1) return((pGenList)NULL);
   d2 = cmrl_next_prod_with_lhs(c,d1,lhs);
   if (d2 == -1) return(cmrl_copy_list(cmr_get_prod_units(c, d1)));
   l1 = cmrl_copy_list(cmr_get_prod_units(c, d1));
   while ( d2 != -1) 
   {
     l1 = cmr_add_to_list(cmr_new_list(),
                          cmr_new_alt(l1,
			       cmrl_copy_list(cmr_get_prod_units(c, d2))
                                     )
                          );
     d2 = cmrl_next_prod_with_lhs(c,d2,lhs);
   }       /* of while */
  return(l1);
}


/* returns did of the empty word */
DID cmrl_get_eps_did(c)
p_comar c;
{
  SEQdef_entry travel;     def_entry   def;

  foreachinSEQdef_entry(c->definitions,travel,def)
  {
    if (def.IDLclassCommon->sid == S_EMPTY) return(def.IDLclassCommon->did);
  }
  return( cmr_new_def_entry(c, P_TERM, S_EMPTY) );

}


/* returns the number of nonterminals in the grammar */
int cmrl_get_number_of_nterms(c)
p_comar c;
{
  SEQdef_entry travel;     def_entry   def;
  int cnt = 0;

  foreachinSEQdef_entry(c->definitions,travel,def)
  {
    if ( typeof(def) == P_NTERM ) cnt++;
  }

  return(cnt);
}


/* returns the first did for given sid */
DID cmrl_sid_to_firstdid(c, sid)
p_comar c;
SID sid;
{
  SEQdef_entry travel;     def_entry   def;

  foreachinSEQdef_entry(c->definitions,travel,def)
  {
    if (def.IDLclassCommon->sid == sid) return(def.IDLclassCommon->did);
  }
  return(CMR_UNKERR);
}

DID cmrl_sid_to_nextdid(c, sid, did)
p_comar c;
SID sid;
DID did;
{
  SEQdef_entry travel;     def_entry   def;

  foreachinSEQdef_entry(c->definitions,travel,def)
  {
    if (def.IDLclassCommon->sid == sid && def.IDLclassCommon->did > did)
      return(def.IDLclassCommon->did);
  }
  return(CMR_UNKERR);
}

