/*
** $Id: cmrsasx.c,v 1.2 90/10/23 13:19:45 cogito Exp $
*/
static char rcs_id[]= "$Id: cmrsasx.c,v 1.2 90/10/23 13:19:45 cogito Exp $";

/******************************************************************************/
/* filename: cmrsasx.c                         first edit   :  4 . 7 . 90     */
/* author  : Christian Zeitel                  last Change  : 10 . 8 . 90     */
/******************************************************************************/

/******************************** CONTENTS *************************************
 *   									       *
 *  This tool adds the sxcodes of the terminals used by the scanner and the    *
 *  productioncodes used by the semantic analysis in property-nodes  to the    *
 *  property-lists of the definition-nodes in the COMAR-data-structure         *
 *  belonging to the corresponding  terminals or productions. 		       *
 *  									       *
 *  INPUT:  -name of the COMAR-file in argv[1].				       *
 *  ------                                                                     *
 *									       *
 *  OUTPUT: -COMAR-file "CMRSASX.out" with inserted sxcodes for terminals and  *
 *  -------  productioncodes for productions. Productions of the abstract      *
 *	     grammar are marked.     					       *
 *									       *
 ******************************* INCLUDE FILES ********************************/

#include  <stdio.h>

#include  <string.h>

#include  "comar.h"

#include  "error.h"

extern void cmrtool();

/******************************************************************************/

main( argc, argv )
      int   argc;
      char *argv[];
      
{ 
    FILE    *fp_comar;
    
    p_comar  Comar_root;
    
    char symbstr[80];   

    if( argc != 2 ) 
    	errmsg( CMRTOOL, CT1USERERR, ABORT, DUMMY );
    	
    if( ( fp_comar = fopen( argv[1], "r") ) == NULL )
        errmsg( CMRTOOL, FILEERR, ABORT, argv[1] );
        
    /* input old COMAR-datastructure */    
    Comar_root  = INPUT( fp_comar );
    fclose( fp_comar );
    
    /* check if filename isn't too long */
    if(strlen(argv[1]) > 76)
	errmsg( CMRTOOL, NAMETOOLONG, ABORT, argv[1] );
    
    strcpy(symbstr, argv[1]);

    if( ( fp_comar = fopen(strcat(symbstr, ".sem"), "w" ) ) == NULL )
    	errmsg( CMRTOOL, FILEERR, ABORT, symbstr );
    	
    /* insert syntaxcodes for terminals and productioncodes */
    cmrtool( Comar_root );
    
    /* output new COMAR-datastructure */ 
    OUTPUT( fp_comar, Comar_root );
    fclose( fp_comar );
    
}/* main */
