/*
** $Id: option.c,v 1.2 90/10/23 13:23:12 cogito Exp $
*/
static char rcs_id[]= "$Id: option.c,v 1.2 90/10/23 13:23:12 cogito Exp $";

/***************************************************************************/
/* File: option.c	First Edit: 24.03.89	  Last Edit: 30.03.89      */
/*									   */
/* Author: Karl-Josef Prott,	University at Paderborn, Germany	   */
/*									   */
/* Last Change: 02.05.89	From: Karl-Josef Prott			   */
/***************************************************************************/

#include <stdio.h>
#include <strings.h>

#include "comar.h"
#include "privatlib.h"

#include "option.h"

opttype	OPTIONS[TOOLNO];	/* exported global variable for options */


typedef enum interopt
  {
    NO, PC, PF, PT
  }	 interopttype;


/* Not exported global variables */
Boolean	all = TRUE,
	ispf = FALSE,
	ispc = FALSE,
	ispt = FALSE,
	isp  = FALSE;


short	lookforward(str)
char **str;
{
  if ( !strncmp(*str,"lr0",3) )
    {
      *str += 2;
      return(1);
    }
  else if ( !strncmp(*str,"lalr",4) )
    {
      *str += 3;
      return(2);
    }
  else if ( !strncmp(*str,"ltst",4) )
    {
      *str += 3;
      return(4);
    }
  else
    return(0);
}  /* end of lookforward() */

char	convert(toolno)
tooltype	toolno;
{
  switch ( toolno )
    {
      case A : return('A');
      case B : return('B');
      case C : return('C');
      case D : return('D');
      case E : return('E');
      case F : return('F');
      default: return('?');
    }
}  /* end of convert() */


interopttype	setopt(pre,post)
interopttype	pre;	/* pre is element of {NO, PF, PC, PT} */
tooltype	post;	/* post is element of {A, B, C, D, E, F} */
{

  switch ( pre )
    {
      case PT : ispt = TRUE;	/* no break is correct! */
      case NO : OPTIONS[(short)post].execute = TRUE;
		all = FALSE;	break;
      case PF : OPTIONS[(short)post].prt_fmt = TRUE;	break;
      case PC : OPTIONS[(short)post].prt_cmr = TRUE;	break;
#ifdef DEBUG_ABS
      default : INT_ERR("setopt()");
#endif
    }

  return(NO);
}  /* end of setopt() */


String	ScanOptions(argc,argv)
int	argc;
String	argv[];
{
  interopttype	actopt;
  char		*str, c;
  short		exeE = NULL,	/* option-variables special for tool "E" */
		prtE = NULL;
  short		val, i;

  while (--argc > 0 && (*++argv)[0] == '-')
  {
    actopt = NO;
    for (str = argv[0] + 1; *str != '\0'; str++)
      switch (*str)
      {
      case 'A' : actopt = setopt(actopt,A);	break;
      case 'B' : actopt = setopt(actopt,B);	break;
      case 'C' : actopt = setopt(actopt,C);	break;
      case 'D' : actopt = setopt(actopt,D);
		 if ( *(str+1) == 'f' )
		   {
		     str++;
		     OPTIONS[(short)D].toolopt = TRUE;
		   }
		 break;
      case 'E' : if ( actopt == NO )
		   {
		     str++;
		     exeE |= lookforward(&str);
		     if ( !exeE )
		       str--;
		   }  /* end of if */
		 actopt = setopt(actopt,E);	break;
      case 'F' : actopt = setopt(actopt,F);	break;

      case 'p' :		/* beginning of a new option */
	  switch ( actopt )
	    {
	      case PF : ispf = TRUE;	break;
	      case PC : ispc = TRUE;	break;
	      case PT : ispt = TRUE;	break;
	      default : break;
	    } /* end of switch */
	  actopt = NO;
	  switch ( *(str+1) )
	    {
	      case 'f' :  actopt = PF;	str++;	break;
	      case 'c' :  actopt = PC;	str++;	break;
	      case 't' :  actopt = PT;	str++;	break;
	      default  :  isp = TRUE;	break;
	    }  /* end of switch */
	  break;

      case 'l' :
	  switch ( actopt )
	    {
	      case PF : ispf = TRUE;	actopt = NO;	goto DefaultLabel;
	      case PC : ispc = TRUE;	actopt = NO;	goto DefaultLabel;
	      case PT : val = lookforward(&str);
			if ( val == NULL )
			  goto DefaultLabel;
			actopt = NO;
			prtE |= val;
			break;
	      default : goto DefaultLabel;
	    } /* end of switch */
	  break;
      default :
	  DefaultLabel :
	  (void)fprintf(stderr,
			"absprs: illegal option %c will be ignored.\n",
			*str);
          break;
      }  /* end of switch */
    /* end of for */

    switch ( actopt )
      {
	case PF : ispf = TRUE;	break;
	case PC : ispc = TRUE;	break;
	case PT : ispt = TRUE;	break;
	default : break;
      } /* end of switch */
  }  /* end of while */


  if (argc != 1)
    {
      (void)fprintf(stderr, "Usage:\tabsprs [ options ] Comarfile\n");
      exit(1);
    }


  if ( all )
    for (i=0; i<TOOLNO; i++)
      OPTIONS[i].execute = TRUE;
  else if ( OPTIONS[(short)F].execute  &&  !OPTIONS[(short)E].execute )
    {
      OPTIONS[(short)E].execute = TRUE;
      exeE = 4;
    }

  ispf |= isp;
  ispc |= isp;
  ispt |= OPTIONS[(short)E].execute && isp;

  for ( i=TOOLNO-1; i>=0; i-- )
    {
      if ( OPTIONS[i].execute )
	{
	  if ( ispf )
	    OPTIONS[i].prt_fmt = TRUE;
	  if ( ispc )
	    OPTIONS[i].prt_cmr = TRUE;
	  break;
	 }
    }  /* end of for */

  if ( ispt  &&  ! OPTIONS[(short)E].execute )
    {
      (void)fprintf(stderr, "Warning: option 'pt' will be ignored," );
      (void)fprintf(stderr," because option 'E' is not set.\n" );
    }
  else if ( ispt )
    if ( exeE == NULL )
      prtE |= 8;
    else if ( exeE >=4 )
      prtE |= 4;
    else if ( exeE >= 2 )
      prtE |= 2;
    else
      prtE |= 1;


  /* Checking the sense of all setted options */
  for (i=0; i<TOOLNO; i++)
    if ( (OPTIONS[i].prt_fmt || OPTIONS[i].prt_cmr) && !OPTIONS[i].execute )
      {
	c = convert((tooltype)i);
	(void)fprintf(stderr,"Warning: option 'pf%c' or 'pc%c' will be ",
		      c, c );
	(void)fprintf(stderr,"ignored, because option '%c' is not set.\n",c);
      } /* end of if */
  /* end of for */

#define	IGNORE(str)	{ \
    (void)fprintf(stderr,"Warning: option 'pt%s' will be ignored,", str); \
    (void)fprintf(stderr," because option 'E' or 'E%s' is not set.\n",str); \
    }

  if (  (! OPTIONS[(short)E].execute && prtE != NULL)  ||
	(exeE > NULL  &&  prtE > exeE)
     )
    if ( OPTIONS[(short)E].execute )
      {
	if ( prtE >= 4 && exeE < 4 )
	  {
	    prtE -= 4;
	    IGNORE("ltst");
	  }
	if ( prtE >= 2 && exeE < 2 )
	  IGNORE("lalr");
      }  /* end of if then */
    else
      {
	if ( prtE >= 4 )
	  {
	    prtE -= 4;
	    IGNORE("ltst");
	  }
	if ( prtE >= 2 )
	  {
	    prtE -= 2;
	    IGNORE("lalr");
	  }
	if ( prtE >= 1 )
	  {
	    prtE -= 1;
	    IGNORE("lr0");
	  }
      }  /* end of else */
  /* end of if */

  OPTIONS[(short)E].toolopt = exeE | (prtE << 3);
  return(argv[0]);

}  /* end of ScanOptions() */
