#include <stdio.h>

#include "bitset.h"
#include "global.h"	/* needed for privatlib.h: types String and Boolean */

#include "digraph.h"
#include "privatlib.h"

static	stacktype	*R=(stacktype *)NULL;	/* relation R: array of lists */

/* N[x]=0	: vertex x is unmarked
 * 0<N[x]<Infinity: vertex x is under active consideration
 * N[x]=Infinity: the SCC (strong connectly component) of x 
 *		  has already been found
 */
static	Cardinal	*N;	/* N[0...Max-1]: see DiGraph and Traverse */
#define	Infinity	((Cardinal) -1)

static	BitSet	*F;	/* F[0...Max-1]: array of equal sized bitsets */


void	InitRelation(card)
Cardinal	card;
{
  if ( (R = (stacktype *)calloc(card, sizeof(stacktype))) == (stacktype *)NULL )
    {
      INT_ALLOC_ERR("InitRelation()");
      exit(1);
    }
  return;
}  /* of InitRelation() */


void    AddToRelation(a,b)
Cardinal	a,b;
{
  R[a] = push(R[a], (eltype)b);
  return;
} /* of AddToRelation() */


void	FreeRelation()
{
  (void)free(R);
  R = (stacktype *)NULL;
} /* of FreeRelation() */


static	void	Traverse(x)
Cardinal	x;
{
  Cardinal	d, y;

static	Cardinal	depth = 0;
/* let S be an initially empty stack of elements of X */
static	stacktype S = (stacktype)NULL;

  S = push(S,(eltype)x);	/* Push x on S */
  N[x] = d = ++depth;		/* d: Depth of S; assign N[x] <- d */

  while ( !empty(R[x]) )	/* for all y of X such that xRy */
  {				/* do */
    y = (Cardinal)top(R[x]);
    R[x] = pop(R[x]);

    if ( N[y] == 0 )		/* if N[y]=0 then call Traverse y fi */
	Traverse(y);
    if ( N[x] > N[y] )		/* assign N[x] <- Min(N[x],N[y]) */
	N[x] = N[y];
    (void)AddSetToSet(F[y],F[x]); /* F[x] <- F[x] union F[y] */
  }				/* od */

  if ( N[x] == d )		/* if N[x]=d then */
    do
    {
	y = (Cardinal)top(S);
	S = pop(S);
	depth--;
	N[y] = Infinity;	/* repeat assign N(Top of S) <- Infinity */
	(void)AddSetToSet(F[x],F[y]);	/* F(Top of S) <- F[x] */
    }  while ( y != x );	/* until (Pop of S) = x */

  return;
   
}  /* of Traverse() */


void	DiGraph(Max, F0)
Cardinal	Max;
BitSet	*F0;	/* F0[0...Max-1] */
{
  Cardinal	x;

  /* let N be an array (of size Max) of zeros indexed by elements of X */
  if ( (N = (Cardinal *)calloc(Max, sizeof(Cardinal))) == (Cardinal *)NULL )
    {
      INT_ALLOC_ERR("DiGraph()");
      exit(1);
    }

  /* for all x of X assign F[x] <- F0[x] */
  F = F0;

  /* for all x of X such that N[x]=0 do call Traverse x od */ 
  for (x=0; x<Max; x++)
    if ( N[x] == 0 )
	Traverse(x);

  (void)free(N);
  return;
}  /* of DiGraph() */



