# $Id: src.lalr.front.lalr.Makefile.cpp,v 1.10 1992/11/26 12:36:10 cogito Exp $
# make library "lalr.a"
# 

DESTDIR = ELISYS

SRC = absparser.c parserlib.c ctx.c lr0.c lalr.c lalr1tst.c \
      mkiface.c printtbl.c purdom.c purdebug.c statistik.c \
      privatlib.c contrafo.c grammarcomp.c first1.c digraph.c
OBJ = absparser.o parserlib.o ctx.o lr0.o lalr.o lalr1tst.o \
      mkiface.o printtbl.o purdom.o statistik.o \
      privatlib.o contrafo.o grammarcomp.o first1.o digraph.o
HDR = absparser.h parserlib.h ctx.h lr0.h lalr.h lalr1tst.h \
      mkiface.h printtbl.h lr0forpurdom.h purdom.h statistik.h \
      privatlib.h contrafo.h grammarcomp.h first1.h digraph.h

IDL   = ../../../idl
LIB   = ../../../lib
OLDCMR= ../../../oldcmr
FMT   = ../../../trafos/fmt

IHDRS = -I$(IDL) -I$(LIB) -I$(OLDCMR) -I$(FMT)

# -DDEBUG_PRS, -DDEBUG_LR0, -DDEBUG_LALR,
# -DDEBUG_ABS, -DDEBUG_PUR: causes additional tests which can be helpful
#			    to search bugs
# -DDEBUG_FREEPOS: free positions are labeled with a connection
# -DSTATISTIK: to get more statistical informations
# ALLDEB =   -DDEBUG_PRS -DDEBUG_LR0 -DDEBUG_LALR -DDEBUG_ABS \
# 	     -DDEBUG_PUR -DDEBUG_FREEPOS -DSTATISTIK

CFLAGS  = $(ALLDEB) $(IHDRS)
CC	= cc

TIDY    = core a.out  *% *.o ERRS lintmsg
CLEAN   = $(TIDY) *.exe *.a 
CLOBBER = $(CLEAN) Makefile

###########################################################################

all: lalr.a

install: lalr.a

distrib:        $(SRC) $(HDR)
	@if test ! -d $(DISTRIB)/lalr/front/lalr; \
		then umask 002; mkdir $(DISTRIB)/lalr/front/lalr; \
		else :; \
		fi
	cp $(SRC) $(HDR) Makefile.cpp $(DISTRIB)/lalr/front/lalr
	cd $(DISTRIB)/lalr/front/lalr; chmod 0644 $(SRC) $(HDR) Makefile.cpp

tidy:
	rm -f $(TIDY)

clean:
	rm -f $(CLEAN)

clobber:
	rm -f $(CLOBBER)

###########################################################################

#if defined(NO_RANLIB)
lalr.a: $(OBJ)
	rm -f lalr.a
	ar rcus lalr.a $(OBJ)
#else
lalr.a: $(OBJ)
	rm -f lalr.a
	ar cru lalr.a $(OBJ)
	ranlib lalr.a
#endif

absparser.o:	$(IDL)/comar.h $(IDL)/name.h $(LIB)/cmrlib.h privatlib.h \
		grammarcomp.h absparser.h  \
		mkiface.h $(IDL)/prsiface.h lr0.h lalr.h lalr1tst.h printtbl.h


parserlib.o: 	privatlib.h $(LIB)/cmrlib.h $(LIB)/bitset.h \
		$(IDL)/comar.h \
	     	first1.h statistik.h parserlib.h


ctx.o:  privatlib.h $(LIB)/cmrlib.h $(LIB)/bitset.h \
	$(IDL)/comar.h statistik.h parserlib.h ctx.h


lr0.o:  $(IDL)/comar.h $(LIB)/cmrlib.h privatlib.h  \
	statistik.h parserlib.h lr0.h


lalr.o: $(IDL)/comar.h \
	$(LIB)/cmrlib.h privatlib.h $(LIB)/bitset.h \
	first1.h statistik.h parserlib.h ctx.h lalr.h


lalr1tst.o: $(IDL)/comar.h \
	    $(LIB)/cmrlib.h privatlib.h $(LIB)/bitset.h $(IDL)/name.h \
	    statistik.h parserlib.h lalr1tst.h


mkiface.o: $(IDL)/comar.h \
	   $(LIB)/cmrlib.h privatlib.h $(LIB)/bitset.h \
	   statistik.h parserlib.h $(IDL)/prsiface.h mkiface.h


printtbl.o:  $(IDL)/comar.h $(IDL)/name.h $(FMT)/format.h \
	     privatlib.h $(LIB)/cmrlib.h $(LIB)/bitset.h \
	     grammarcomp.h parserlib.h printtbl.h


purdom.o:  $(IDL)/comar.h $(IDL)/comar_func.h \
	   privatlib.h $(LIB)/cmrlib.h $(LIB)/bitset.h \
	   statistik.h parserlib.h ctx.h lr0forpurdom.h purdebug.c purdom.h


statistik.o:	$(IDL)/comar.h ctx.h parserlib.h statistik.h \
		privatlib.h $(LIB)/cmrlib.h

contrafo.o:	$(IDL)/comar.h $(IDL)/comar_func.h \
		$(LIB)/cmrlib.h privatlib.h $(IDL)/name.h contrafo.h

grammarcomp.o:	$(IDL)/comar.h $(IDL)/comar_func.h $(IDL)/name.h \
	$(LIB)/cmrlib.h privatlib.h first1.h grammarcomp.h

privatlib.o:  $(IDL)/comar.h $(LIB)/cmrlib.h privatlib.h

first1.o:	$(IDL)/comar.h $(IDL)/name.h \
		$(LIB)/cmrlib.h $(LIB)/cmrio.h $(LIB)/bitset.h \
		privatlib.h first1.h

digraph.o:	$(IDL)/global.h $(LIB)/bitset.h privatlib.h digraph.h

###########################################################################

lint:
	lint $(CFLAGS) $(SRC)  >! lintmsg

