# $Id: src.lalr.back.table.Makefile.cpp,v 1.10 1992/12/18 13:51:07 cogito Exp $
# $Revision: 1.10 $

DESTDIR = ELISYS
DISTRIB = ELISYS

# parameter for control-output of the read-module
HELP=

SRC =	opt_tabs.c optfunc.c wrt_tabs.c wrtfunc.c BUILDPRS.c \
	optresfunc.c opthelpfunc.c wrthelpfunc.c build_copa.c ptg_gen.c
OBJ =	opt_tabs.o optfunc.o wrt_tabs.o wrtfunc.o \
	optresfunc.o opthelpfunc.o wrthelpfunc.o ptg_gen.o
HDR =	build_tdcopa.h opthelpfunc.h tabsopttype.h wrthelpfunc.h \
	opt_tabs.h opthelptype.h wrt_tabs.h optfunc.h optresfunc.h \
        wrtfunc.h build_copa.h ptg_gen.h

BOTH  = ../both
AUSGABE = ../../..
IDL   = ../../../idl

LIBS = $(BOTH)/both.a $(IDL)/IDL.a
CFLAGS	= -I$(BOTH) -I$(IDL)
CC	= cc -O

TIDY    = core a.out  *% *.o ERRS lintmsg
CLEAN   = $(TIDY) *.exe *.a
CLOBBER = $(CLEAN)

###########################################################################

all:	$(AUSGABE)/cola_tbl.exe

$(AUSGABE)/cola_tbl.exe: table.a build_copa.o BUILDPRS.c
	$(CC) -DTABDRIV -DFILEOPT  $(CFLAGS) \
	BUILDPRS.c build_copa.o table.a $(LIBS) -o $(AUSGABE)/cola_tbl.exe 

#
# Installation
#

install:	$(AUSGABE)/cola_tbl.exe
	@echo "install -c -s -m 0755 $(AUSGABE)/cola_tbl.exe $(DESTDIR)
	@rm -f $(DESTDIR)/cola_tbl.exe
	@cp $(AUSGABE)/cola_tbl.exe $(DESTDIR)
	@chmod 0644 $(DESTDIR)/cola_tbl.exe

# 
# Distribution
#

distrib:	$(SRC) $(HDR)
	rm -rf $(DISTRIB)/lalr/back/table
	mkdir $(DISTRIB)/lalr/back/table
	cp $(SRC) $(HDR) Makefile.cpp $(DISTRIB)/lalr/back/table
	cd $(DISTRIB)/lalr/back/table; chmod 0644 $(SRC) $(HDR) Makefile.cpp

#
# Cleaning targets
#

tidy:
	rm -f $(TIDY)

clean:
	rm -f $(CLEAN)

clobber:
	rm -f $(CLOBBER)

###########################################################################

#if defined(hpux) || defined(sgi)
table.a: $(OBJ)
	rm -f table.a
	ar rcus table.a $(OBJ)
#else
table.a: $(OBJ)
	rm -f table.a
	ar cru table.a $(OBJ)
	ranlib table.a
#endif

build_copa.o: build_copa.c build_copa.h $(BOTH)/rd_absprs.h \
	$(IDL)/comar.h $(IDL)/prsiface.h \
	wrt_tabs.h tabsopttype.h opt_tabs.h
	$(CC) -c -DTABDRIV  $(CFLAGS) build_copa.c

opt_tabs.o: opt_tabs.c optfunc.h tabsopttype.h $(BOTH)/error.h

optfunc.o:   optfunc.c tabsopttype.h opthelptype.h opthelpfunc.h optresfunc.h

wrt_tabs.o:  wrt_tabs.c tabsopttype.h wrtfunc.h $(BOTH)/error.h

wrtfunc.o:   wrtfunc.c tabsopttype.h wrthelpfunc.h

optresfunc.o:   optresfunc.c  $(BOTH)/error.h tabsopttype.h opthelptype.h

opthelpfunc.o:   opthelpfunc.c  $(BOTH)/error.h tabsopttype.h opthelptype.h

wrthelpfunc.o:   wrthelpfunc.c  $(BOTH)/error.h tabsopttype.h




