/***************************************************************************/
/* filename : write_parser.c                       first edit  : 16.03.91  */
/* author   : Markus Adam                                                  */
/*            In der Aue 26                        last change : 29.08.91  */
/*            4780 Lippstadt                                               */
/*            Germany                                                      */
/***************************************************************************/

/* $Revision: 1.1 $ */
static char rcsid[] = "$Id: write_parser.c,v 1.1 1992/01/10 14:38:40 cogito Exp $";


/*************************** INCLUDE - FILES *******************************/

#include<stdio.h>

#include "over.h"

#include "over_types.h"

#include "out.h"

#include "write_help.h"

#include "errors.h"

/****************************** FUNCTIONS **********************************/


static void Write_Bit_Set( fp,optim_out_data,extra_info )

   FILE                          *fp;  /* file pointer to the external
					  output file, where the complete
					  parser should be written         */
   struct optim_out  *optim_out_data;  /* internal interface pointer to a
					  structure which consists of some
					  pointer to different code blocks */
   char                   extra_info;  /* if extra_info == 1, then extra
					  information about begin and end
					  of function is printed out      */


/* If Similar Action Code is built, then all states  which have a
   certain number of postions equal to Similar Action Code jump to the code.
   It is not necessary for a state to have all positions equal to the
   Similar Action Code so, if a token is read in a state, it will be
   compared with all terminals belonging to this state. If no
   comparison is true then (if possible) a jump to Similar Action Code
   will take place.  But, there can be comparisons with terminals,
   which do not exist in this state. So before a jump to Similar Action
   Code takes place, it must be tested to see if the terminal belongs
   to the state. To save storage space, this test will be lead through
   a bit set. These bit sets will be printed here.
*/


   {
     short       state,  /* loop index                                     */
		   pos;  /* loop index                                     */

     if( extra_info )
	printf("begin of function Write_Bit_Set( )\n");


     for( state=0;state<optim_out_data->nos;state++ )
	if( optim_out_data->similar_act_rows[state] == state )
	      {
		fprintf(fp,"static char bvector_%d[] =\n",
			optim_out_data->similar_act_rows[state] );
		fprintf(fp,"   { ");
		for( pos=0;pos<optim_out_data->length_of_bvector;pos++ )
		   if( !pos )
		      fprintf(fp,"%d",optim_out_data->bvector[
				      optim_out_data->similar_act_rows[
						      state]][pos]);
		   else
		      fprintf(fp,",%d",optim_out_data->bvector[
				       optim_out_data->similar_act_rows[
						       state]][pos]);
		fprintf(fp," };\n\n");
	      } /* end of if( !(print_... */

     if( extra_info )
	printf("end of function Write_Bit_Set( )\n");

   } /* end of function Write_Bit_Set( ) */






static void Write_Initialisation( fp,user_data,optim_out_data,extra_info )

   FILE                          *fp;  /* file pointer to the external
					  output file, where the complete
					  parser should be written         */
   struct user            *user_data;  /* internal interface vector, which
					  saves information fixed by the
					  user                             */
   struct optim_out  *optim_out_data;  /* internal interface pointer to a
					  structure which consists of some
					  pointer to different code blocks */
   char                   extra_info;  /* if extra_info == 1, then extra
					  information about begin and end
					  of function is printed out      */

/* In this function some global macros will be written.
*/

   {
     short  loop,
             szc;


     if( extra_info )
	printf("begin of function Write_Initialisation(  )\n");

     szc = sizeof( char ) * BYTE;

     fprintf(fp,"#define SEMANTIC( production )  ");
     fprintf(fp,"     Semantic_Prods( production ) \n");
     fprintf(fp,"#define BYTE                  %d\n",BYTE);
     if( user_data->semantic_symbols )
	{
	  fprintf(fp,"#define SEMANTIC_SYMBOLS\n");
	  if( optim_out_data->min_term )
	     {
	       fprintf(fp,"#define IS_SEM( token )       (sem_symb[(token ");
	       fprintf(fp,"- BASE) / %d] &  \\ \n",szc);
	       fprintf(fp,"                              (1 << ((token ");
	       fprintf(fp,"- BASE) %% %d)))\n",szc);
	     } /* end of if( optim_out_da... */
	  else
	     {
	       fprintf(fp,"#define IS_SEM( token )       (sem_symb[token ");
	       fprintf(fp," / %d] &  \\ \n",szc);
	       fprintf(fp,"                              (1 << (token ");
	       fprintf(fp," %% %d)))\n",szc);
	     } /* end of else ( if( optim_out_da... ) */
	} /* end of if( user_data->seman... */

     fprintf(fp,"#define STACK_SIZE            %d\n",user_data->stack_size);
     fprintf(fp,"#define STACK_CHECK           (sp_end <=  sp)\n");
     fprintf(fp,"#ifndef TRUE\n");
     fprintf(fp,"#define TRUE               1\n");
     fprintf(fp,"#endif\n");
     fprintf(fp,"#ifndef FALSE\n");
     fprintf(fp,"#define FALSE              0\n");
     fprintf(fp,"#endif\n");
     fprintf(fp,"#define _PARSING_ERROR( entry )        state = entry; goto ERR;\n");

     if( ((optim_out_data->similar_act_branches) ||
	  (user_data->semantic_symbols)           )  &&
	  (optim_out_data->min_term)                  )
	fprintf(fp,"#define BASE                  %d\n",
		optim_out_data->min_term);
     if( optim_out_data->similar_act_branches )
	{
	  if( optim_out_data->min_term )
	     {
	       fprintf(fp,"#define IS_ELEM( vector,pos)  ");
	       fprintf(fp,"(vector[(pos-BASE)/%d] & ",szc);
	       fprintf(fp,"(1 << ((pos-BASE)%%%d)))\n",szc);
	     } /* end of if( optim_out_... */
	  else
	     {
	       fprintf(fp,"#define IS_ELEM( vector,pos)  (vector[pos/%d]",szc);
	       fprintf(fp," & (1 << (pos%%%d)))\n",szc);
	     } /* end of else ( if( optim_out_... ) */
	} /* end of if( optim_out_data... */

     fprintf(fp,"\n\nstatic short                *sp,\n");
     fprintf(fp,"                      *sp_begin,\n");
     fprintf(fp,"                        *sp_end,\n");
     fprintf(fp,"                      error_pos;\n");


     if( (user_data->semantic_symbols)           &&
	 (optim_out_data->sem_symb_list != NULL)  )
	{
	  fprintf(fp,"static char  sem_symb[] =\n");
	  fprintf(fp,"   { ");
	  for( loop=0;loop<optim_out_data->length_of_bvector;loop++ )
	     if( !loop )
		fprintf(fp,"%d",optim_out_data->sem_symb_list[loop]);
	     else
		fprintf(fp,",%d",optim_out_data->sem_symb_list[loop]);
	  fprintf(fp," };\n");
	} /* end of if( (user_data->sem... */

     if( extra_info )
	printf("end of function Write_Initialisation(  )\n");

   } /* end of function Write_Initialisation(  ) */







static void Write_Head( fp,user_data,optim_out_data,extra_info )

   FILE                          *fp;  /* file pointer to the external 
                                          output file, where the complete 
                                          parser should be written         */
   struct user            *user_data;  /* internal interface vector, which 
                                          saves	information fixed by the 
                                          user                             */
   struct optim_out  *optim_out_data;  /* internal interface pointer to a
					  structure which consists of some
					  pointer to different code blocks */
   char                   extra_info;  /* if extra_info == 1, then extra 
                                          information about begin and end 
                                          of function is printed out      */

/* This function writes the definition part of the function Parser. All
   needed functions are included and the beginning frame of the function
   is printed.
*/

   {
     if( extra_info )
	printf("begin of function Write_Head(  )\n");

     fprintf(fp,"#include <stdio.h>\n\n");
     fprintf(fp,"#include \"waite_carter.h\"\n\n");
     fprintf(fp,"#include \"init.h\"\n\n");
     if( !user_data->direct_struct_connection  ||
         user_data->automatic_error_correction )
        fprintf(fp,"#include \"semantic_productions.h\"\n\n");
     if( user_data->automatic_error_correction )
	{
	  fprintf(fp,"#include \"error_recovery.h\"\n\n");
	  fprintf(fp,"#include \"help_func.h\"\n\n\n");
	} /* end of if( user_data->... */

     fprintf(fp,"void Parser()\n");
     fprintf(fp,"{\n\n\n");
     fprintf(fp,"   register TYPE_OF_SX_CODE   term;\n");
     fprintf(fp,"   register int              state;\n\n");
     if( user_data->automatic_error_correction )
	fprintf(fp,"#include \"error_var.h\"\n\n");

     fprintf(fp,"   if( (sp = (short*) calloc( STACK_SIZE,sizeof( short ) ))\n");
     fprintf(fp,"        == NULL )\n");
     fprintf(fp,"          ERR_MSG( DEADLY,NO_SPACE,0,0 );\n\n");
     fprintf(fp,"sp_begin = sp;\n");
     fprintf(fp,"sp_end   = sp_begin + STACK_SIZE - %d;\n",optim_out_data->
             longest_path);
     fprintf(fp,"   SCAN( term );\n");
     fprintf(fp,"   goto C_0;\n");


     if( extra_info )
	printf("end of function Write_Head(  )\n");

   } /* end of function Write_Head(  ) */






static void Print_Binary_If( fp,user_data,out_list,lower,upper,next,
			     first_elem,space,eq_string,shred_mark,
			     shift_mark,default_mark,no_error,sx_code_list,
                             seman_list,extra_info)


   FILE                       *fp;  /* file pointer to the external output
				       file, where the complete parser
				       should be written                   */
   struct equality      *out_list;  /* pointer to structure equality, which
				       represents a part of code, where
				       some comparisons lead through       */
   struct user         *user_data;  /* internal interface vector, which
				       saves information fixed by the
				       user                                */
   char_ptr           *seman_list;

   short               first_elem,  /* the first element to be
				       investigate                         */
                    *sx_code_list,
			    upper,  /* the upper bound of the current sub-
				       list, which has to be investigate
				       yet                                 */
			    lower,  /* the lower bound of the current sub-
				       list, which has to be investigate
				       yet                                 */
			     next,  /* the next element of the current sub-
				       list, which has to be investigate
				       yet                                 */
			    space;  /* the number of blanks which should
				       be printed out, before some code
				       will be printed                     */
   char                *eq_string,  /* the string which should be compared
				       with other data                     */
		      *shred_mark,  /* this string will be printed out if
				       a jump to a reduce - mark should be
				       passed through                      */
		      *shift_mark,  /* this string would be printed out, if
				       a jump to a shift - mark should be
				       passed through                      */
		    *default_mark,  /* this string would be printed out, if
				       a jump to a default - mark ( no
				       reduce - and no shift - mark )
				       should be passed through            */
			 no_error,  /* if no_error == TRUE no jumps to the
				       error mark are allowed              */
		       extra_info;  /* if extra_info == 1, then extra
				       information about begin and end
				       of function is printed out         */



/* Often long sequences of comparisons must be printed. One possible
   way is to print it out as binary if. That means, the structure of
   a binary tree are transformed to C - Code like :
		  +---+
		  | a |
		  +---+
		 /    \
	      < /      \  >
	       /        \
	       .         .
	       .         .
	       .         .

		   ||
		   ||  leads to
		   ||
		   VV

	     if( a < token ) ...
			     .
			     .
			     .
	     else
		if( a > token ) ...
				.
				.
				.
		else
		   if( a == token ) ..

   The advantage of this kind of comparison is, that only log( n )
   comparisons must be lead through and not n like in the normal if case.
*/




   {
     short  loop;  /* loop index                                           */

     if( extra_info )
	printf("begin of function Print_Binary_If( )\n");

     if( (lower+1 == next) && (upper-1 == next) )
	{
	  for( loop=0;loop<space;loop++ )
	     fprintf(fp,"   ");
	  fprintf(fp,"{\n");
	  Print_If( fp,user_data,out_list,next-1,space+1,eq_string,
		    shred_mark,shift_mark,default_mark,0,0,sx_code_list,
                    seman_list,extra_info);
	  for( loop=0;loop<space;loop++ )
	     fprintf(fp,"   ");
	  fprintf(fp,"}\n");
	} /* end of if( (lower+1 ==... */
     else
	{
          for( loop=0;loop<space;loop++ )
	     fprintf(fp,"   ");
	  fprintf(fp,"if (%s < %d)\n",
		  eq_string,((sx_code_list == NULL) ?
                 (OPERAND( out_list[next-1].eq_elem )) : 
                 (sx_code_list[OPERAND( out_list[next-1].eq_elem )])) );
	  Print_Binary_If( fp,user_data,out_list,lower,next,
			   ((lower+next)/2+(lower+next)%2),first_elem,
			   ++space,eq_string,shred_mark,shift_mark,
			   default_mark,no_error,sx_code_list,seman_list,
                           extra_info);
	  if( upper-1 != next )
	     {
	       for( loop=0;loop<space-1;loop++ )
		  fprintf(fp,"   ");
	       fprintf(fp,"else\n");
	       for( loop=0;loop<space;loop++ )
		  fprintf(fp,"   ");
	       fprintf(fp,"if (%s > %d) \n",
		       eq_string,((sx_code_list == NULL) ?
                 (OPERAND( out_list[next-1].eq_elem )) : 
                 (sx_code_list[OPERAND( out_list[next-1].eq_elem )])) );
	       Print_Binary_If( fp,user_data,out_list,next,upper,
				((upper+next)/2+(upper+next)%2),first_elem,
				++space,eq_string,shred_mark,shift_mark,
				default_mark,no_error,sx_code_list,seman_list,
                                extra_info);
	     } /* end of if( upper-1 != ... */
	  for( loop=0;loop<space-1;loop++ )
	     fprintf(fp,"   ");
	  fprintf(fp,"else\n");

	  for( loop=0;loop<space;loop++ )
	     fprintf(fp,"   ");
	  fprintf(fp,"{\n");
	  Print_If( fp,user_data,out_list,next-1,space+1,eq_string,
		    shred_mark,shift_mark,default_mark,0,0,sx_code_list,
                    seman_list,extra_info);
	  for( loop=0;loop<space;loop++ )
	     fprintf(fp,"   ");
	  fprintf(fp,"}\n");

	} /* end of else ( if( (lower+1 ==... ) */

     if( extra_info )
	printf("end of function Print_Binary_If( )\n");

   } /* end of function Print_Binary_If( ) */






static void Print_Switch( fp,user_data,out_list,upper_bound,eq_string,
			shred_mark,shift_mark,default_mark,wrt_pars,
                        sx_code_list,seman_list,extra_info)


   FILE                       *fp;  /* file pointer to the external output
				       file, where the complete parser
				       should be written                   */
   struct equality      *out_list;  /* pointer to structure equality, which
				       represents a part of code, where
				       some comparisons lead through       */
   struct user         *user_data;  /* internal interface vector, which
				       saves information fixed by the
				       user                                */
   short              upper_bound,  /* number of code elements which should
				       be printed out                      */
                    *sx_code_list;
   char_ptr           *seman_list;

   char                *eq_string,  /* the string which should compared
				       with other data                     */
		      *shred_mark,  /* this string would be printed out, if
				       a jump to a reduce - mark should be
				       passed through                      */

		      *shift_mark,  /* this string would be printed out, if
				       a jump to a shift - mark should be
				       passed through                      */

		    *default_mark,  /* this string would be printed out, if
				       a jump to a default - mark ( no
				       reduce - and no shift - mark )
				       should be passed through             */

			 wrt_pars,  /* used to decide if the default mark
				       of the switch case construct should
				       be printed in this function         */
		       extra_info;  /* if extra_info == 1, then extra
				       information about begin and end
				       of function is printed out         */



/* Another possibility to print such long sequences of comparisons is
   with help of the switch - case construct. Then it is the problem
   of the compiler to handle an efficient structure. But often you
   will get large object code for long sequences.
*/




   {
     short  loop,  /* loop index                                           */
	     len;  /* loop index                                           */

     if( extra_info )
	printf("begin of function Print_Switch( )\n");

     fprintf(fp,"   switch( %s )\n      {\n",eq_string );

     for( loop=0;loop<upper_bound;loop++ )
	{
	  if( !(IS_SHRED_NTACT( out_list[loop].eq_elem )) )
	     if( IS_ACCEPTACT( out_list[loop].eq_elem ) )
		{
		  fprintf(fp,"        case %d :\n",
			  ((sx_code_list == NULL) ? (OPERAND( out_list[loop].                          eq_elem )) : (sx_code_list[OPERAND( out_list[loop].                                        eq_elem )])) );
                  if( IS_REDUCEACT( out_list[loop].action.goto_action ) )
                     if( user_data->direct_struct_connection )
                        fprintf(fp,"   %s\n",
                                seman_list[OPERAND( out_list[loop].
                                                    action.goto_action )] );
                     else
                        fprintf(fp,"             SEMANTIC( %d );\n",
                                OPERAND( out_list[loop].action.goto_action ));
		  fprintf(fp,"             ACCEPT();\n");
		} /* end of if( IS_ACCEPTA... */
	     else
		if( (loop == upper_bound-1) && wrt_pars )
		   {
		     fprintf(fp,"        default :\n");
		     fprintf(fp,"             goto %s_%d;\n",
			     shift_mark,
			     out_list[loop].action.goto_action );
		   } /* end of if( (loop == u... */
		else
		   {
		     fprintf(fp,"        case %d :\n",
			     ((sx_code_list == NULL) ? (OPERAND( out_list[loop].                             eq_elem )) : (sx_code_list[OPERAND( out_list[loop].                                           eq_elem )])) );
		     fprintf(fp,"             goto %s_%d;\n",
			     shift_mark,
			     out_list[loop].action.goto_action );
		   } /* end of else ( if( (loop == u... ) */
	  else
	     {
	       if( (loop == upper_bound-1) && wrt_pars )
		  fprintf(fp,"        default : \n");
	       else
		  fprintf(fp,"        case %d : \n",
			 ((sx_code_list == NULL) ? (OPERAND( out_list[loop].                         eq_elem )) : (sx_code_list[OPERAND( out_list[loop].                                      eq_elem )])) );
	       if( (out_list[loop].action.new_red_sit->scan)                    &&
		   ((IS_REDUCEACT( out_list[loop].action.new_red_sit->sem )) || 
                    (IS_SEM( out_list[loop].action.new_red_sit->sem ))       ||
                    (IS_SEM( out_list[loop].action.new_red_sit->old_sem ))   )   )

		  {
		    if( user_data->semantic_symbols )
		       {
			 fprintf(fp,"             if( IS_SEM( term ) )\n");
			 fprintf(fp,"                SYMB_SEM( SYMBOL_CONNECTION_VALUE );\n");
		       } /* end of if( user_data->se... */
		    fprintf(fp,"             SCAN( %s );\n",
			    eq_string );
		  } /* end of if( (out_list[loo... */
	       if( out_list[loop].action.new_red_sit->pcc != NULL )
		  {
		    if( (out_list[loop].action.new_red_sit->pop > 0)     &&
			(out_list[loop].action.new_red_sit->pcc->pop > 0) )
		       fprintf(fp,"             sp -= %d;\n",
			       ((out_list[loop].action.new_red_sit->
				 pcc->pop) +
				(out_list[loop].action.new_red_sit->pop)) );
		    else
		       if( (out_list[loop].action.new_red_sit->pop > 0)     ||
			   (out_list[loop].action.new_red_sit->pcc->pop > 0) )
			  fprintf(fp,"  sp -= %d;\n",
				  ((out_list[loop].action.new_red_sit->
				    pcc->pop > 0) ?
				    (out_list[loop].action.new_red_sit->
				    pcc->pop) :
				    (out_list[loop].action.new_red_sit->
				    pop)) );
		    fprintf(fp,"             if(");
		    for( len=0;len<out_list[loop].action.new_red_sit->
			       pcc->number;len++ )
		       {
			 if( len )
			    fprintf(fp,"                ");
			 fprintf(fp," (*sp == %d) %s\n",
				 out_list[loop].action.new_red_sit->
				     pcc->pointer[len],
				 ((len == out_list[loop].action.new_red_sit->
				     pcc->number-1) ? ")" : "||") );
		       } /* end of for( len=0;len<... */
		    fprintf(fp,"                sp -= 1;\n");

		  } /* end of if( out_list[l... */
	       else
		  if( out_list[loop].action.new_red_sit->pop > 0 )
		     fprintf(fp,"             sp -= %d;\n",
			     out_list[loop].action.new_red_sit->pop );

	       if( IS_SEM( out_list[loop].action.new_red_sit->
				   old_sem ) )
                  if( user_data->direct_struct_connection )
                     fprintf(fp,"   %s\n",
                             seman_list[OPERAND( out_list[loop].
                                                 action.new_red_sit->
				                 old_sem )] );
                  else
		     fprintf(fp,"             SEMANTIC( %d );\n",
			     OPERAND( out_list[loop].action.new_red_sit->
				      old_sem ) );
	       if( IS_SEM( out_list[loop].action.new_red_sit->sem ) )
                  if( user_data->direct_struct_connection )
                     fprintf(fp,"   %s\n",
                             seman_list[OPERAND( out_list[loop].
                                        action.new_red_sit->sem )] );
                  else
		     fprintf(fp,"             SEMANTIC( %d );\n",
			     OPERAND( out_list[loop].action.new_red_sit->
					   sem ) );
	       if( IS_REDUCEACT( out_list[loop].action.new_red_sit->
				   sem ) )
		  {
		    if( user_data->individual_reduce_code )
		       fprintf(fp,"             goto %s_%d_%d_%d;\n",
			       shred_mark,
			       out_list[loop].action.new_red_sit->mark,
			       out_list[loop].action.new_red_sit->kind,
			       out_list[loop].action.new_red_sit->state );
		    else
		       fprintf(fp,"             goto %s_%d;\n",shred_mark,
			       out_list[loop].action.new_red_sit->mark );
		  } /* end of if( IS_REDUCEA... */
	       else
		  fprintf(fp,"             goto %s_%d;\n",
			  (out_list[loop].action.new_red_sit->scan &&
                          !(IS_SEM( out_list[loop].action.new_red_sit->
                            sem )) &&
                          !(IS_SEM( out_list[loop].action.new_red_sit->
                            old_sem ))) ?
			  shift_mark : default_mark,
			  out_list[loop].action.new_red_sit->mark );

	     } /* end of else ( if( !(IS_SHRED_... ) */
	} /* end of for( loop=0;loo... */
     if( wrt_pars )
	fprintf(fp,"      }\n");

     if( extra_info )
	printf("end of function Print_Switch( )\n");

   } /* end of function Print_Switch( ) */





static void Write_Red_Code( fp,optim_out_data,user_data,extra_info )


   FILE                          *fp;  /* file pointer to the external
					  output file, where the complete
					  parser should be written         */
   struct optim_out  *optim_out_data;  /* internal interface pointer to a
					  structure which consists of some
					  pointer to different code blocks */
   struct user            *user_data;  /* internal interface vector, which
					  saves information fixed by the
					  user                             */
   char                   extra_info;  /* if extra_info == 1, then extra
					  information about begin and end
					  of function is printed out      */


/* This function controls the printing of the reduction code. Here
   all reduction situation in which corresponding productions have the
   same left hand side symbol are put together or each reduction situation
   gets its own code block. Each code block, get a definite mark. So if,
   in a normal state, a reduction takes place, a jump to the corresponding
   reduction mark will take place.
*/


   {
     struct red_out_code  *red_help_ptr;  /* used to search a reduction
					     code element                  */


     if( extra_info )
	printf("begin of function Write_Red_Code( )\n");

     red_help_ptr = optim_out_data->red_code;

     while( red_help_ptr != NULL )
	{
	  if( user_data->individual_reduce_code )
	     fprintf(fp,"RED_%d_%d_%d :\n",
		     red_help_ptr->mark,
		     red_help_ptr->kind,
		     red_help_ptr->state);
	  else
	     fprintf(fp,"RED_%d :\n",red_help_ptr->mark );

	  if( (user_data->list_out == SWITCH) &&
	      (user_data->lower_bound <= red_help_ptr->number) )
	     Print_Switch( fp,user_data,red_help_ptr->eq_list,
			   red_help_ptr->number,"*sp","RED","C","C",
                           1,NULL,
                           optim_out_data->seman_list,extra_info );
	  else
	     if( (user_data->list_out == BIN_IF) &&
		 (user_data->lower_bound <= red_help_ptr->number) )
                {
		  Print_Binary_If( fp,user_data,red_help_ptr->eq_list,0,
				   (user_data->code_compression ? 
                                    red_help_ptr->number :
                                    red_help_ptr->number+1),
				   ((red_help_ptr->number+1)/2+
				    (red_help_ptr->number+1)%2),
                                   ((red_help_ptr->number+1)/2+
				    (red_help_ptr->number+1)%2),1,
				   "*sp","RED","C","C",1,NULL,
				   optim_out_data->seman_list,extra_info );
                  if( user_data->code_compression )
		     Print_If( fp,user_data,red_help_ptr->eq_list,
			       red_help_ptr->number-1,1,"*sp","RED",
			       "C","C",1,0,optim_out_data->sx_code_list,
                               optim_out_data->seman_list,extra_info);
                }
	     else
		Print_Normal_If( fp,user_data,red_help_ptr->eq_list,
				 red_help_ptr->number,"*sp","RED","C",
				 "C",((user_data->code_compression ||
                                 (red_help_ptr->number == 1)) ? 1 :
				 0),0,NULL,optim_out_data->seman_list,
                                 extra_info );

	  fprintf(fp,"\n");
	  red_help_ptr = red_help_ptr->next;
	} /* end of while( red_hel... */

     if( extra_info )
	printf("end of function Write_Red_Code( )\n");

   } /* end of function Write_Red_Code( ) */





static void Write_Sim_Act_Code( fp,optim_out_data,user_data,extra_info )


   FILE                          *fp;  /* file pointer to the external
					  output file, where the complete
					  parser should be written         */
   struct optim_out  *optim_out_data;  /* internal interface pointer to a
					  structure which consists of some
					  pointer to different code blocks */
   struct user            *user_data;  /* internal interface vector, which
					  saves information fixed by the
					  user                             */
   char                   extra_info;  /* if extra_info == 1, then extra
					  information about begin and end
					  of function is printed out      */




/* If similar action exist, then the code for the similar action
   mark is printed out here.
*/



   {

     if( extra_info )
	printf("begin of function Write_Sim_Act_Code( )\n");

     if( optim_out_data->sim_act_code != NULL )
	{
	  fprintf(fp,"SA :\n");

	  if( (user_data->list_out == SWITCH) &&
	      (user_data->lower_bound <= optim_out_data->sim_act_code->
	      number) )
	     Print_Switch( fp,user_data,optim_out_data->sim_act_code->
			   eq_list,optim_out_data->sim_act_code->number,
			   "term","S","S","S",1,optim_out_data->
                           sx_code_list,optim_out_data->seman_list,extra_info );

	  else
	     if( (user_data->list_out == BIN_IF) &&
		 (user_data->lower_bound <= optim_out_data->sim_act_code->
		  number) )
		Print_Binary_If( fp,user_data,optim_out_data->sim_act_code->
				 eq_list,0,optim_out_data->sim_act_code->
				 number+1,
				 ((optim_out_data->sim_act_code->number+1)/2+
				  (optim_out_data->sim_act_code->number+1)%2),
                                 ((optim_out_data->sim_act_code->number+1)/2+
				  (optim_out_data->sim_act_code->number+1)%2),
				  1,"term","S","S","S",1,optim_out_data->
                                  sx_code_list,optim_out_data->seman_list,
                                  extra_info );
	     else
		Print_Normal_If( fp,user_data,optim_out_data->sim_act_code->
				 eq_list,optim_out_data->sim_act_code->
				 number,"term","S","S","S",0,0,optim_out_data->
                                 sx_code_list,optim_out_data->seman_list,
                                 extra_info );
	} /* end of if( optim_out_d... */

     if( extra_info )
	printf("end of function Write_Sim_Act_Code( )\n");

   } /* end of function Write_Sim_Act_Code( ) */




static void Write_Parser_Code( fp,optim_out_data,user_data,extra_info )


   FILE                          *fp;  /* file pointer to the external
					  output file, where the complete
					  parser should be written         */
   struct optim_out  *optim_out_data;  /* internal interface pointer to a
					  structure which consists of some
					  pointer to different code blocks */
   struct user            *user_data;  /* internal interface vector, which
					  saves information fixed by the
					  user                             */
   char                   extra_info;  /* if extra_info == 1, then extra
					  information about begin and end
					  of function is printed out      */



/* This function prints out the code for each state.
*/



   {
     struct parser_code  *help_pars_ptr;  /* used to search a parser code
					     element                       */
     char                          part,  /* used to decide if the next code
					     block is a part of the current
					     code block                    */
                               eq_state=
                                  FALSE;


     if( extra_info )
	printf("begin of function Write_Parser_Code( )\n");

     help_pars_ptr = optim_out_data->parser;
     part = FALSE;
     while( help_pars_ptr != NULL )
	{
	  if( !part )
	     {
               if( optim_out_data->scan_mark[help_pars_ptr->mark] )
                  {
	            fprintf(fp,"S_%d :\n",help_pars_ptr->mark );
	            if( user_data->semantic_symbols )
		       {
		         fprintf(fp,"   if( IS_SEM( term ) )\n");
		         fprintf(fp,"      SYMB_SEM( SYMBOL_CONNECTION_VALUE );\n");
		       } /* end of if( user_data->seman... */
	            fprintf(fp,"   SCAN( term );\n");
                  } /* end of if( optim_out_data-... */

	       fprintf(fp,"C_%d :\n",help_pars_ptr->mark);
	       if( help_pars_ptr->push )
		  fprintf(fp,"   *(++sp) = %d;\n",help_pars_ptr->mark );
	       if( help_pars_ptr->stack_check )
		  {
		    fprintf(fp,"   if( STACK_CHECK )\n");
		    fprintf(fp,"      ERR_MSG( DEADLY,FULL_STACK,0,0 );\n");
		  } /* end of if( help_pars_p... */
	     } /* end of if( !part ) */
	  else
             if( eq_state )
	        fprintf(fp,"E_%d :\n",help_pars_ptr->mark );
             else
                fprintf(fp,"Q_%d :\n",help_pars_ptr->mark );


	  if( (user_data->list_out == SWITCH) &&
	      (user_data->lower_bound <= help_pars_ptr->number) )
	     Print_Switch( fp,user_data,help_pars_ptr->eq_list,
			   help_pars_ptr->number,"term","RED","S","C",
			   ((help_pars_ptr->goto_default == -4) ? 1 : 0),
			   optim_out_data->sx_code_list,optim_out_data->
                           seman_list,extra_info );
	  else
	     if( (user_data->list_out == BIN_IF) &&
		 (user_data->lower_bound <= help_pars_ptr->number) )
		{
		  Print_Binary_If( fp,user_data,help_pars_ptr->eq_list,0,
				   ((help_pars_ptr->goto_default == -4) ?
				    help_pars_ptr->number :
				    help_pars_ptr->number+1),
				   ((help_pars_ptr->number+1)/2+
				    (help_pars_ptr->number+1)%2),
                                    ((help_pars_ptr->number+1)/2+
				    (help_pars_ptr->number+1)%2),1,
				   "term","RED","S","C",1,optim_out_data->
                                   sx_code_list,optim_out_data->seman_list,
                                   extra_info );

		  if( help_pars_ptr->goto_default == -4 )
		     Print_If( fp,user_data,help_pars_ptr->eq_list,
			       help_pars_ptr->number-1,1,"term","RED",
			       "S","C",1,0,optim_out_data->sx_code_list,
                               optim_out_data->seman_list,extra_info);

		} /* end of if( (user_data... */
	     else
		Print_Normal_If( fp,user_data,help_pars_ptr->eq_list,
				 help_pars_ptr->number,"term","RED","S",
				 "C",((help_pars_ptr->goto_default == -4) ?
				 1 : 0),0,optim_out_data->sx_code_list,
                                 optim_out_data->seman_list,extra_info );


	  if( help_pars_ptr->goto_default == -2 )
	     {
	       if( (user_data->list_out == NORMAL_IF) ||
		   (user_data->list_out == BIN_IF)    ||
		   (user_data->lower_bound >
				help_pars_ptr->number) )
		  if( part )
		     fprintf(fp,"   _PARSING_ERROR( state );\n\n\n");
		  else
		     fprintf(fp,"   _PARSING_ERROR( %d );\n\n\n",
			     help_pars_ptr->mark);
	       else
		  {
		    fprintf(fp,"        default :\n");
		    if( part )
		       fprintf(fp,"             _PARSING_ERROR( state );\n");
		    else
		       fprintf(fp,"             _PARSING_ERROR( %d );\n",
			       help_pars_ptr->mark);
		    fprintf(fp,"      }\n\n\n");
		  } /* end of else ( if( (user_data-... ) */
               eq_state = FALSE;
	       part     = FALSE;
	     } /* end of if( help_pars_... */
	  else
	     if( help_pars_ptr->goto_default == -3 )
		{
		  part     = FALSE;
                  eq_state = FALSE;
		  if( (user_data->list_out == NORMAL_IF) ||
		      (user_data->list_out == BIN_IF)    ||
                      (user_data->lower_bound >
				   help_pars_ptr->number) )
		     {
		       fprintf(fp,"   if( IS_ELEM( bvector_%d,term ) )\n",
			       optim_out_data->similar_act_rows[
				   help_pars_ptr->mark] );
		       fprintf(fp,"      goto SA;\n");
		       fprintf(fp,"   _PARSING_ERROR( %d );\n\n\n",
			       help_pars_ptr->mark );
		     } /* end of if( (user_data-... */
		  else
		     {
		       fprintf(fp,"        default :\n");
		       fprintf(fp,"             if( IS_ELEM( bvector_%d,",
			       optim_out_data->similar_act_rows[
				   help_pars_ptr->mark] );
		       fprintf(fp,"term ) )\n");
		       fprintf(fp,"                goto SA;\n");
		       fprintf(fp,"             _PARSING_ERROR( %d );\n",
			       help_pars_ptr->mark );
		       fprintf(fp,"      }\n\n\n");
		     } /* end of else ( if( (user_data-... ) */
		} /* end of if( help_pars_p... */
	     else
		if( (help_pars_ptr->goto_default == -1) ||
                    (help_pars_ptr->goto_default == -5)  )
		   {
		     if( (user_data->list_out != NORMAL_IF) &&
			 (user_data->list_out != BIN_IF)    &&
			 (user_data->lower_bound <=
				      help_pars_ptr->number) )

			  fprintf(fp,"      }\n");
		     if( !part ) 
                        fprintf(fp,"   state = %d;\n",
			        help_pars_ptr->mark);
		     part = TRUE;
                     if(help_pars_ptr->goto_default == -5) 
                        eq_state = TRUE;
                     else 
                        eq_state = FALSE;
            
		   } /* end of if( help_pars_p... */
		else
		   if( help_pars_ptr->goto_default == -4 )
		      {
			fprintf(fp,"\n\n\n");
			part = FALSE;
                        eq_state = FALSE;
		      } /* end of if( help_pars_p... */
		   else
		      {
			part = FALSE;
                        eq_state = FALSE;
			if( (user_data->list_out == NORMAL_IF) ||
			    (user_data->list_out == BIN_IF)    ||
			    (user_data->lower_bound >
				     help_pars_ptr->number) )
			   {
			     fprintf(fp,"   state = %d;\n",
				     help_pars_ptr->mark);
                             if( IS_EQUAL_STATE( help_pars_ptr->goto_default ) )
			        fprintf(fp,"   goto E_%d;\n\n\n",
				        OPERAND( help_pars_ptr->goto_default ));
                             else
			        fprintf(fp,"   goto Q_%d;\n\n\n",
				        help_pars_ptr->goto_default);
			   } /* end of if( (user_data-... */
			else
			   {
			     fprintf(fp,"        default :\n");
			     fprintf(fp,"             state = %d;\n",
				     help_pars_ptr->mark);
                             if( IS_EQUAL_STATE( help_pars_ptr->goto_default ) )
			        fprintf(fp,"             goto E_%d;\n",
				        OPERAND( help_pars_ptr->goto_default ));
                             else
			        fprintf(fp,"             goto Q_%d;\n",
				        help_pars_ptr->goto_default);
			     fprintf(fp,"      }\n\n\n");
			   } /* end of else ( if( (user_data-... ) */
		      } /* end of else ( if( help_pars_p... ) */
	  help_pars_ptr = help_pars_ptr->next;
	} /* end of while( help_par... */

     if( extra_info )
	printf("end of function Write_Parser_Code( )\n");

   } /* end of function Write_Parser_Code( ) */








void Write_Parser( user_data,optim_out_data,extra_info )

   struct user               *user_data;  /* internal interface vector,
					     which saves information fixed
					     by the user                   */
   struct optim_out     *optim_out_data;  /* internal interface pointer to
					     a structure which consists of
					     some pointer to different code
					     blocks                        */
   char                      extra_info;  /* if extra_info == 1, then extra
					     information about begin and
					     end of function are printed
					     out                           */



/* This function controls the printing of the whole parser automaton,
   without the error recovery.
*/



   {
     FILE  *fp;  /* file pointer to the external output file, where the
		    complete parser should be written                      */

     if( extra_info )
	printf("begin of function Write_Parser( )\n");


     if( (fp = fopen( "init.h","w" )) == NULL )
	Error_Message( _WRITE_PARSER,MODULE_WRITE_PARSER,NOT_OPEN_FILE,ABORT,
                       " init.h" );

     Write_Initialisation( fp,user_data,optim_out_data,extra_info );
     fprintf(fp,"\n\n");

     if( optim_out_data->similar_act_branches )
	{
	  Write_Bit_Set( fp,optim_out_data,extra_info );
	  fprintf(fp,"\n\n");
	} /* end of if( optim_out_data->s... */

     fclose( fp );


     if( (fp = fopen( "parser.c","w" )) == NULL )
	Error_Message( _WRITE_PARSER,MODULE_WRITE_PARSER,NOT_OPEN_FILE,ABORT,
                       " parser.c" );

     Write_Head( fp,user_data,optim_out_data,extra_info );
     fprintf(fp,"\n\n");

     Write_Parser_Code( fp,optim_out_data,user_data,extra_info );
     fprintf(fp,"\n\n");

     Write_Sim_Act_Code( fp,optim_out_data,user_data,extra_info );
     fprintf(fp,"\n\n\n\n");

     Write_Red_Code( fp,optim_out_data,user_data,extra_info );
     fprintf(fp,"\n\n\n\n");

     fclose( fp );

     if( !user_data->direct_struct_connection )
        {
          if( (fp = fopen( "semantic_productions.h","w" )) == NULL )
	     Error_Message( _WRITE_PARSER,MODULE_WRITE_PARSER,NOT_OPEN_FILE,
                            ABORT," sema_prods.h" );
          Write_Semantic_Code( fp,optim_out_data->nop,optim_out_data->seman_list,
                               NULL,extra_info );
          fclose( fp );
        } /* end of if( !user_data->direc... */

     if( extra_info )
	printf("end of function Write_Parser( )\n");

   } /* end of function Write_Parser( ) */
