/***************************************************************************/
/* filename : sema_prods.c                         first edit  : 19.04.91  */
/* author   : Markus Adam                                                  */
/*            In der Aue 26                        last change : 05.06.91  */
/*            4780 Lippstadt                                               */
/*            Germany                                                      */
/***************************************************************************/

/* $Revision: 1.2 $ */
static char rcsid[] = "$Id: sema_prods.c,v 1.2 1992/03/03 09:40:56 cogito Exp $";

/*************************** INCLUDE - FILES *******************************/


#include <string.h>

#include "over_types.h"

#include "comar.h"

#include "name.h"

#include "errors.h"

#include "seman.h"




/************************* MACRO - DEFINITIONS *****************************/
typedef short *readtype[];


#define GETSYMB( def )   fastsymblist[def.IDLclassCommon->sid]\
			 .IDLclassCommon->str

#define GETDEF( def )   fastdeflist[def]



static symb_entry  *fastsymblist;


static def_entry    *fastdeflist;


/******************************* FUNCTIONS *********************************/


void Build_Reverse_Prod_List( quick_data,seman_data,extra_info )

   readtype      *quick_data;  /* interface vector to optimization         */
   char           extra_info;  /* if extra_info == 1, then extra informa-
                                  tion about begin and end of function
                                  is printed out                           */

   struct seman  *seman_data;  /* vector of all semantic actions           */



/* A vector which converts internal to external production code is given
   by the input module. This function builds a vector which converts
   external to internal production codes.
*/


   {
     short  *rev_prod_list,  /* vector to convert external to internal 
                                production code                            */
                *prod_list,  /* vector to convert internal to external 
                                production code                            */
                       max,  /* The greatest external code                 */
                       nop,  /* number of productions                      */
                      prod;  /* loop index                                 */

     if( extra_info )
        printf("begin of function Build_Reverse_Prod_List()\n");

     prod_list = (*quick_data)[8];
     max = 0;
     nop = *((*quick_data)[5]);
  
     for( prod=0;prod<nop;prod++ )
        if( prod_list[prod] > max )
           max = prod_list[prod];
 
     if( (rev_prod_list = (short*) calloc( max+1,sizeof( short ) )) == NULL )
        Error_Message( _BUILD_REVERSE_PROD_LIST,MODULE_SEMA_PRODS,
                       NO_SPACE_FOR_VECTOR,ABORT," rev_prod_list" );

     for( prod=0;prod<max+1;prod++ )
        rev_prod_list[prod] = -1;


     for( prod=0;prod<nop;prod++ )
        {
          if( prod_list[prod] >= 0 )
             if( rev_prod_list[prod_list[prod]]<0 )
                rev_prod_list[prod_list[prod]] = prod;
             else
                Error_Message( _BUILD_REVERSE_PROD_LIST,MODULE_SEMA_PRODS,
                               OBSCURE_STATE,ABORT,"" );
        } /* end of for( prod=0;p... */

     seman_data->rev_prod_list = rev_prod_list;

     if( extra_info )
        printf("end of function Build_Reverse_Prod_List()\n");

   } /* end of function Build_Reverse_Prod_List() */





static void Build_Semantic_List( seman_data,prod_code,connection,extra_info )

   struct seman  *seman_data;  /* vector of all semantic actions           */
   short           prod_code;  /* an external production code              */
   char          *connection,  /* the semantic action                      */
                  extra_info;  /* if extra_info == 1, then extra informa-
                                  tion about begin and end of function
                                  is printed out                          */

/* This function builds a list of semantic actions, where for each internal
   production code, a semantic action is saved.                            
*/


   {
     if( extra_info )
        printf("begin of function Build_Semantic_List()\n");

     if( seman_data->rev_prod_list[prod_code] < 0 )
        Error_Message( _BUILD_SEMANTIC_LIST,MODULE_SEMA_PRODS,WRONG_VALUE,
                       ABORT," prod_list" );
     seman_data->seman_list[seman_data->rev_prod_list[prod_code]] =
            connection;

     if( extra_info )
        printf("end of function Build_Semantic_List()\n");

   } /* end of function Build_Semantic_List() */





static void Init_Fast_Lists( Comar_root,extra_info )

   p_comar  Comar_root;
   char     extra_info;  /* if extra_info == 1, then extra information 
                            about begin and end of function is printed 
                            out                                            */

   {
     symb_entry                 symb;
     SEQsymb_entry  traversalseqsymb;
     def_entry                   def;
     SEQdef_entry    traversalseqdef;

     if( extra_info )
        printf("begin of function Init_Fast_Lists()\n");

     if( (fastsymblist = (symb_entry*) malloc( (lengthSEQsymb_entry
	   ( Comar_root->symbols )+1) * sizeof( symb_entry ) )) == NULL )
	Error_Message( _INIT_FAST_LISTS,MODULE_SEMA_PRODS,NO_SPACE_FOR_VECTOR,
                       ABORT," fastsymblist" );

     foreachinSEQsymb_entry( Comar_root->symbols,traversalseqsymb,symb )
	{
	  fastsymblist[symb.IDLclassCommon->sid] = symb;
	} /* end of foreachinSEQsy... */

     if( (fastdeflist = (def_entry*) malloc( (lengthSEQdef_entry
	   ( Comar_root->definitions )+1) * sizeof( def_entry ) )) == NULL )
	Error_Message( _INIT_FAST_LISTS,MODULE_SEMA_PRODS,NO_SPACE_FOR_VECTOR,
                       ABORT," fastdeflist" );

     foreachinSEQdef_entry( Comar_root->definitions,traversalseqdef,def )
	{
	  fastdeflist[def.IDLclassCommon->did] = def;
	} /* end of foreachinSEQde... */

     if( extra_info )
        printf("end of function Init_Fast_Lists()\n");

   } /* end of function Init_Fast_Lists() */






static short Get_Prodcode( proddef,extra_info )

   def_entry     proddef;  /* a production - definition - entry of the 
                              COMAR - definitionlist                      */
   char       extra_info;  /* if extra_info == 1, then extra informa-
                              tions about begin and end of function
                              is printed out                             */

   {
      SEQprop_entry  traversalseqprop;
      prop_entry             property;

     if( extra_info )
        printf("begin of function Get_Prodcode()\n");

      foreachinSEQprop_entry( proddef.IDLclassCommon->prop,
			      traversalseqprop,property )
	 {
	   if( !strcmp( GETSYMB( property ),"_SEMA_PRODCODE" ) )
	      return( (property.Vp_prop_val->val).Vp_nval->val );
	 } /* end of foreachinSEQpr... */

     if( extra_info )
        printf("end of function Get_Prodcode()\n");

      return( -1 );

   } /* end of function Get_Prodcode() */




static char Is_Abstract( def,connection,extra_info )

   def_entry           def;
   char       **connection,
                extra_info;  /* if extra_info == 1, then extra informa-
                                tion about begin and end of function
                                is printed out                           */

   {
     def_entry                  def1;
     unit                         un;
     SEQunit        traversalsequnit;
     prop_entry             property;
     SEQprop_entry  traversalseqprop;
     char    *str;
     short   result = FALSE;


     if( extra_info )
        printf("begin of function Is_Abstract()\n");

     *connection = "\0";
     foreachinSEQunit( def.Vp_prod->rhs,traversalsequnit,un )
	{
	  def1 = GETDEF( un.Vp_elunit->did );

	  if( typeof( def1 ) == Kp_other )
	     foreachinSEQprop_entry( def1.IDLclassCommon->prop,
				     traversalseqprop,property )
		{
		  if( ! strcmp(GETSYMB(property), CONNECTION) )
		     {
                        /* structure-connection found */
                        str = *connection;
                        *connection = (char *)malloc(strlen(*connection) +
                                                     strlen(GETSYMB(def1)) +
                                                     1);
                        (void)strcpy(*connection, str);
                        (void)strcat(*connection, GETSYMB(def1));
                        result = TRUE;

		     } /* end of if( strcmp( GETS */
		} /* end of foreachinSEQprop_e */
	} /* end of foreachinSEQunit... */

     if( extra_info )
        printf("end of function Is_Abstract()\n");

     return( result );

   } /* end of function Is_Abstract()... */





void Get_Connections( Comar_root,seman_data,extra_info )

   p_comar        Comar_root;
   struct seman  *seman_data;
   char           extra_info;  /* if extra_info == 1, then extra informa-
                                  tion about begin and end of function
                                  is printed out                         */


   {
     char              *connection;
     SEQdef_entry  traversalseqdef;
     def_entry                 def;
     short               prod_code;


     if( extra_info )
        printf("begin of function Get_Connections()\n");

     Init_Fast_Lists( Comar_root,extra_info );

     foreachinSEQdef_entry( Comar_root->definitions,traversalseqdef,def )
	{
	  if( typeof( def ) == Kp_prod )
	     if( Is_Abstract( def,&connection,extra_info ) )
		{
		  prod_code = Get_Prodcode( def,extra_info );
                  Build_Semantic_List( seman_data,prod_code,connection,
                                     extra_info );
		} /* end of if( Is_Abstract(... */

	} /* end of foreachinSEQdef_en... */

     if( extra_info )
        printf("end of function Get_Connections()\n");

   } /* end of function Get_Connections() */


