/***************************************************************************/
/* filename : errors.h                             first edit  : 23.02.91  */
/* author   : Markus Adam                                                  */
/*            In der Aue 26                        last change : 05.06.91  */
/*            4780 Lippstadt                                               */
/*            Germany                                                      */
/***************************************************************************/

/* $Revision: 1.1 $ */
/* $Id: errors.h,v 1.1 1992/01/10 14:38:40 cogito Exp $ */



/******************************** FUNCTIONS ********************************/


extern void errmsg( /* func_numbermodule_numbererrortextabort
		       add_info */ );

/*
   short    func_number,     Each function has a number, which represents 
                             the position in vector func. There exist to                                  each number the corresponding function name.  
          module_number,     Same as above, but only for modules in
                             vector modules                                
              errortext,     Same as above, but only for error text in
                             vector error                                 
            error_class;     The number of error class. Two error classes 
                             are allowed, ERROR ( != 0 ) and WARNING 
                             ( == 0 )                                     
   char       *add_info;     if additional information should printed out,
                             add_info could be used.                      
 */


/************************* MACRO - DEFINITIONS *****************************/


static short  max_module =  15,
	      max_func   =  101,
	      max_error  =  15;



#define WARN              			 0
#define ABORT                                    1

/*                           positions in vector module                    */
#define MODULE_BUILD_COPA			 0
#define MODULE_BUILD_OPTIM			 1
#define MODULE_BUILD_PATHS			 2
#define MODULE_CLEARING			         3
#define MODULE_ERROR  			         4
#define MODULE_ERROR_OUT  			 5
#define MODULE_HIGH_OPTIM			 6
#define MODULE_LOW_OPTIM			 7
#define MODULE_OPTIM_HELP			 8
#define MODULE_OPTIM_OUT			 9
#define MODULE_OTHER_OPTIM			10
#define MODULE_READ_DATA			11
#define MODULE_SEMA_PRODS			12
#define MODULE_WRITE_ERROR			13
#define MODULE_WRITE_HELP			14
#define MODULE_WRITE_PARSER			15




/*                           positions in vector func                      */

/* function of module build_copa           */
#define _MAIN         				 0


/* function of module build_optim          */
#define _BUILD_OPTIM 				 1


/* function of module build_paths          */
#define _BUILD_REVERSE_VERTICES                  2
#define _RED_SIT				 3
#define _BUILD_REDUCE_PATHS			 4
#define _BUILD_PATHS				 5


/* functions of module clearing            */
#define _EQ_TEST                                 6       
#define _EXIST_OTHER_SITS  			 7
#define _DELETE_SHARED_RED_SITS			 8
#define _JOIN_REDS                               9
#define _EQ_RED_SIT				10


/* function of module error                */
#define _ERROR_MESSAGE                          11      


/* function of module error_out            */
#define _DETERM_SEM_PARA                        12      
#define _BUILD_RSYMBOL				13
#define _BUILD_ANCHOR_SET			14
#define _FIND_EQ_LIST_TRANSITION		15
#define _BUILD_ERROR_AUTOMATON			16
#define _COUNT_RED_CODE				17
#define _FIND_RED_CODE				18
#define _DET_REC_RED_CODE			19
#define _DETERMINE_POSSIBLE_RED_CODE		20
#define _BUILD_ERROR_OUT			21


/* functions of module high_optim          */
#define _DGD_RR_MP_OPTI                         22   
#define _FIND_NON_PUSH_TRANSITIONS		23
#define _SOLVE_PCC                              24   
#define _PCC                                    25   
#define _POP_COUNT_ENTRY                        26   
#define _JOIN_RED_PATHS                         27   
#define _INSERT_CHAIN_RULES			28
#define _NTAB_CHAIN_RULE_ELIMINATION            29   
#define _TTAB_CHAIN_RULE_ELIMINATION            30    
#define _HIGH_OPTIM 				31


/* functions of module low_optim           */
#define _COUNT_EQUAL_POS                      	32       
#define _COMPARE_UNDER                          33   
#define _COMPARE_EQUAL                          34   
#define _DET_UNDER_ROWS                         35   
#define _DET_EQUAL_POS                          36   
#define _DET_SIMILAR_POS                        37   
#define _LOW_OPTIM				38


/* function of module optim_help           */
#define _PROOF_RED_PATHS                     	39        
#define _GEN_REACH_ELEM				40
#define _INS_RED				41
#define _REACHEBILITY_TEST			42
#define _SEARCH_EQUAL_CODE			43
#define _CODE_COMPRESSION			44
#define _FIND_PCC_ELEM				45
#define _GEN_EQ_ELEM				46
#define _NOT_EQUAL_CODE				47
#define _UNIT_ASSIGNMENT			48
#define _FIND_EQ_MARK				49
#define _CHANGE_RED_EQ_MARKS			50
#define _CHANGE_PARS_EQ_MARKS			51


/* function of module optim_out            */
#define _DET_MIN_MAX_TERM                       52     
#define _BUILD_IND_RED_CODE			53
#define _BUILD_RED_CODE				54
#define _BUILD_SIMILAR_ACT_CODE			55
#define _IS_ELEM				56
#define _FIND_RED_SIT				57
#define _BUILD_EQ_LIST				58
#define _BUILD_PARSER_CODE			59
#define _BUILD_SEMAN_LIST			60
#define _OPTIM_OUT				61


/* functions of module other_optim         */
#define _DFS                               	62          
#define _CONTROL_DFS				63
#define _DET_BACK_EDGES                         64   
#define _BUILD_ADJACENT_LIST                    65   
#define _REVERSE_ADJACENT_LIST                  66    
#define _DFS_SCC                                67   
#define _CTR_DFS_SCC                            68   
#define _SCC                                    69   
#define _CTR_SCC                                70   
#define _DET_LONGEST_PATH                       71   
#define _OTHER_OPTIM  				72


/* function of module read_data            */
#define _READ_DATA                          	73         


/* function of module sema_prods           */
#define _BUILD_REVERSE_PROD_LIST            	74         
#define _BUILD_SEMANTIC_LIST			75
#define _INIT_FAST_LISTS			76
#define _GET_PRODCODE 				77
#define _IS_ABSTRACT				78
#define _GET_CONNECTIONS			79


/* function of module write_error          */
#define _WRITE_VAR                              80    
#define _WRITE_STOP_AT_FIRST_ERROR		81
#define _WRITE_STATIC_VAR			82
#define _WRITE_ERROR_BODY			83
#define _WRITE_ERROR_MARK			84
#define _WRITE_CHOICE_LIST			85
#define _WRITE_ERROR_AUTOMATON			86
#define _WRITE_ERROR_RED			87
#define _WRITE_ERROR_RECOVERY			88


/* function of module write_help           */
#define _PRINT_IF                               90      
#define _PRINT_NORMAL_IF			91
#define _WRITE_SEMANTIC_CODE			92


/* function of module write_parser         */
#define _WRITE_BIT_SET                          93     
#define _WRITE_INITIALISATION			94
#define _WRITE_HEAD				95
#define _PRINT_BINARY_IF			96
#define _PRINT_SWITCH				97
#define _WRITE_RED_CODE				98
#define _WRITE_SIM_ACT_CODE			99
#define _WRITE_PARSER_CODE		       100
#define _WRITE_PARSER			       101





/*                                 positions in vector error               */
#define WRONG_ERROR                  		 0     
#define NO_SPACE_FOR_VECTOR           		 1     
#define NO_SPACE_FOR_STRUCTURE         		 2   
#define NO_COMAR_NAME				 3
#define NO_ABSPRS_NAME			  	 4
#define NOT_FIND_ELEMENT			 5
#define OPTION_NOT_EXIST 			 6
#define NOT_OPEN_FILE   			 7
#define OPTION_SYNTAX				 8
#define NUMBER_EXPECTED				 9
#define NOT_IN_BOUND  				10
#define DIFFERENT_CONTINUATION_STATES           11
#define SAME_SYNTAXCODE				12
#define OBSCURE_STATE				13
#define NO_SEMANTIC_TERMINALS			14
#define WRONG_VALUE				15
