/***************************************************************************/
/* filename : dep_main.c                           first edit  :  02.05.91 */
/* author   : Markus Adam                                                  */
/*            In der Aue 26                        last change :  05.06.91 */
/*            4780 Lippstadt                                               */
/*            Germany                                                      */
/***************************************************************************/

/* $Revision: 1.1 $ */
static char rcsid[] = "$Id: dep_main.c,v 1.1 1992/01/10 14:38:40 cogito Exp $";

/************************* MACRO - DEFINITIONS *****************************/



typedef short *readtype[];



/*************************** INCLUDE - FILES *******************************/

#include<stdio.h>

#include<string.h>

#include<ctype.h>

#include "over_types.h"

#include "over.h"

#include "build_optim.h"

#include "write_parser.h"

#include "write_error.h"

#include "error_out.h"

#include "read_data.h"

#include "seman.h"

#include "out.h"

#include "sema_prods.h"

#include "errors.h"



/****************************** FUNCTIONS **********************************/



static char Is_Number( str )

   char *str;  /* String which should be tested.                           */

/* Tests if the given string is a number or not. 
*/

   {  while(*str != '\0')
        if( !isdigit( *(str++) ) )
           return( FALSE );
      return( TRUE );
   } /* end of function Is_Number( ) */




main( argc,argv )

   int      argc;  /* number of arguments                                  */
   char  *argv[];  /* the arguments, saved in a vector                     */

/*  The main function of the program, which get the options for generating
    the parser.
*/

   {

     readtype              *quick_data;  /* interface vector to optimi-
                                            zation                         */
     struct user            *user_data;  /* structure which saves infor- 
                                            mation entered by the user     */
     struct optim_out  *optim_out_data;  /* stores the optimized code in a
                                            form, which can be printed 
                                            out easily                     */
     struct error_out  *error_out_data;  /* interface between error - 
                                            recovery module and the write
                                            module                         */
     struct seman          *seman_data;  /* vector which saves the semantic
                                            connections                    */
     char                  *comar_name=  /* Name of the COMMAR file and    */
                                  NULL,  /* the abstract parser file,      */
                          *absprs_name=  /* which saves all information    */
                                  NULL,  /* about the grammar              */
                            extra_info=  /* if extra_info == 1, then extra */
                                 FALSE;  /* information about begin and                                                         end of function is printed 
                                            out                            */

                                      

  
     if( ((user_data = (struct user*) malloc( 
                             sizeof( struct user ) )) == NULL) ||
         ((seman_data = (struct seman*) malloc( 
                            sizeof( struct seman ) )) == NULL) )
        Error_Message( _MAIN,MODULE_BUILD_COPA,NO_SPACE_FOR_STRUCTURE,ABORT,
                       " seman_data" );


     user_data->scc_or_dfs                 = FALSE;
     user_data->high_before_low            = FALSE;
     user_data->individual_reduce_code     = FALSE;
     user_data->list_out                   = NORMAL_IF;
     user_data->lower_bound                = 3;
     user_data->number_of_common_action    = 7;
     user_data->number_of_similar_action   = 10;
     user_data->min_push                   = FALSE;
     user_data->direct_goto_determination  = FALSE;
     user_data->stack_check                = FALSE;
     user_data->lower_optimization         = FALSE;
     user_data->chain_rule_elimination     = FALSE;
     user_data->code_compression           = FALSE;
     user_data->delete_unit_marks          = FALSE;
     user_data->share_reduce_code          = FALSE;
     user_data->automatic_error_correction = FALSE;
     user_data->stack_size                 = 100;
     user_data->queue_size                 = 50;
     user_data->choose_list                = FALSE;
     user_data->semantic_symbols           = FALSE;
     user_data->direct_struct_connection   = FALSE;

     while( --argc > 0 )
        {
          ++argv;
          if( ((*argv)[0] != '-' )   ||
              (strlen( *argv ) < 2) )
             Error_Message( _MAIN,MODULE_BUILD_COPA,OPTION_SYNTAX,WARN,"" );
          else
             if( !strcmp( *argv,"-scc" ) )
               {
                 user_data->stack_check = TRUE;
                 user_data->scc_or_dfs  = TRUE;
               } /* end of if( !strcmp(... */

          else
             if( !strcmp( *argv,"-dfs" ) )
               {
                 user_data->stack_check = TRUE;
                 user_data->scc_or_dfs  = FALSE;
               } /* end of if( !strcmp(... */
          else
             if( !strcmp( *argv,"-hbl" ) )
                {
                  user_data->high_before_low = TRUE;
                  user_data->lower_optimization = TRUE;
                } /* end of if( !strcmp(... */
          else
             if( !strcmp( *argv,"-irc" ) )
                user_data->individual_reduce_code = TRUE;
          else
             if( !strcmp( *argv,"-dgd" ) )
                user_data->direct_goto_determination = TRUE;
          else
             if( !strcmp( *argv,"-mp" ) )
                user_data->min_push = TRUE;
          else
             if( !strcmp( *argv,"-lp" ) )
                user_data->lower_optimization = TRUE;
          else
             if( !strcmp( *argv,"-cre" ) )
                user_data->chain_rule_elimination = TRUE;
          else
             if( !strcmp( *argv,"-cc" ) )
                user_data->code_compression = TRUE;
          else
             if( !strcmp( *argv,"-dum" ) )
                user_data->delete_unit_marks = TRUE;
          else
             if( !strcmp( *argv,"-src" ) )
                user_data->share_reduce_code = TRUE;
          else
             if( !strcmp( *argv,"-aec" ) )
                user_data->automatic_error_correction = TRUE;
          else
             if( !strcmp( *argv,"-ss" ) )
                user_data->semantic_symbols = TRUE;
          else
             if( !strcmp( *argv,"-cl" ) )
                user_data->choose_list = TRUE;
          else
             if( !strcmp( *argv,"-dsc" ) )
                user_data->direct_struct_connection = TRUE;
          else
             if( !strcmp( *argv,"-info" ) )
                extra_info = TRUE;
          else
             if( !strcmp( *argv,"-c" ) )
                {
                  if( argc != 1 )
                     {
                       comar_name = *(++argv);
                       argc--;
                      } /* end of if( argc !=... */
                } /* end of if( !strcmp(... */
          else
             if( !strcmp( *argv,"-a" ) )
                {
                  if( argc != 1 )
                     {
                       absprs_name = *(++argv);
                       argc--;
                     } /* end of if( argc... */
                } /* end of if( !strcmp(... */
          else
             if( !strcmp( *argv,"-lo" ) )
                {
                  if( argc != 1 )
                     {
                       if( Is_Number( *(++argv) ) )
			  {
                            user_data->list_out = atoi( *argv);
                            argc--;
			  }
                       else
                          {
                            argv--;
                            Error_Message( _MAIN,MODULE_BUILD_COPA,
                                           NUMBER_EXPECTED,
                                           WARN," [ -lo <number> ]");
			  }
                       if( (user_data->list_out < 0) ||
                           (user_data->list_out > 2)  )
                          {
                            user_data->list_out = NORMAL_IF;
                            Error_Message( _MAIN,MODULE_BUILD_COPA,NOT_IN_BOUND,
                                           WARN," ( 0 < number < 4 )" );
                          } /* end of if( (user_data->... */
                     } /* end of if( argc !... */ 
                } /* end of if( !strcmp(... */
          else
             if( !strcmp( *argv,"-noc" ) )
                {
                  if( argc != 1 )
                     {
                       if( Is_Number( *(++argv) ) )
			  {
                            user_data->number_of_common_action = atoi( *argv);
                            argc--;
			  }
                       else
			  {
                            argv--;
                            Error_Message( _MAIN,MODULE_BUILD_COPA,
                                           NUMBER_EXPECTED,
                                           WARN," [ -noc <number> ]" );
			  }
                       if( user_data->number_of_common_action < 1 ) 
                          {
                            user_data->number_of_common_action = 7;
                            Error_Message( _MAIN,MODULE_BUILD_COPA,NOT_IN_BOUND,
                                           WARN," ( 0 < number )" );
                          } /* end of if( user_data->... */
                     } /* end of if( argc !=... */
                } /* end of if( !strcmp(... */
          else
             if( !strcmp( *argv,"-nosa" ) )
                {
                  if( argc != 1 )
                     {
                       if( Is_Number( *(++argv) ) )
			  {
                            user_data->number_of_similar_action = atoi( *argv);
                            argc--;
			  }
                       else
			  {
                            argv--;
                            Error_Message( _MAIN,MODULE_BUILD_COPA,
                                           NUMBER_EXPECTED,
                                           WARN," [ -nosa <number> ]" );
			  }
                       if( user_data->number_of_similar_action < 1 ) 
                          {
                            user_data->number_of_similar_action = 10;
                            Error_Message( _MAIN,MODULE_BUILD_COPA,NOT_IN_BOUND,
                                           WARN," ( 0 < number )" );
                          } /* end of if( user_data->... */
                     } /* end of if( argc !=... */
                } /* end of if( !strcmp( ... */

          else
             if( !strcmp( *argv,"-lb" ) )
                {
                  if( argc != 1 )
                     {
                       if( Is_Number( *(++argv) ) )
			  {
                            user_data->lower_bound = atoi( *argv);
    			    argc--;
			  }
                       else
			  {
			    argv--;
                            Error_Message( _MAIN,MODULE_BUILD_COPA,
                                           NUMBER_EXPECTED,
                                           WARN," [ -lb <number> ]" );
			  }
                       if( user_data->lower_bound < 3 ) 
                          {
                            user_data->lower_bound = 3;
                            Error_Message( _MAIN,MODULE_BUILD_COPA,NOT_IN_BOUND,
                                           WARN," ( 2 < number )" );
                          } /* end of if( user_data->... */
                     } /* end of if( argc !... */
                } /* end of if( !strcmp(... */
          else
             if( !strcmp( *argv,"-sz" ) )
                {
                  if( argc != 1 )
                     {
                       if( Is_Number( *(++argv) ) )
			  {
                            user_data->stack_size = atoi( *argv);
			    argc--;
			  }
                       else
			  {
			    argv--;
                            Error_Message( _MAIN,MODULE_BUILD_COPA,
                                           NUMBER_EXPECTED,
                                           WARN," [ -sz <number> ]" );
			  }
                       if( user_data->stack_size < 1 ) 
                          {
                            user_data->stack_size = 100;
                            Error_Message( _MAIN,MODULE_BUILD_COPA,NOT_IN_BOUND,
                                           WARN," ( 0 < number )" );
                          } /* end of if( user_data->... */
                     } /* end of if( argc !=... */
                } /* end of if( argc !=... */
          else
             if( !strcmp( *argv,"-qz" ) )
                {
                  if( argc != 1 )
                     {
                       if( Is_Number( *(++argv) ) )
			  {
                            user_data->queue_size = atoi( *argv);
			    argc--;
			  }
                       else
			  {
			    argv--;
                            Error_Message( _MAIN,MODULE_BUILD_COPA,
                                           NUMBER_EXPECTED,
                                           WARN," [ -qz <number> ]" );
			  }
                       if( user_data->queue_size < 1 ) 
                          {
                            user_data->queue_size = 50;
                            Error_Message( _MAIN,MODULE_BUILD_COPA,NOT_IN_BOUND,
                                           WARN," ( 0 < number )" );
                          } /* end of if( user_data->... */
                     } /* end of if( argc !=... */
                } /* end of if( !strcmp(... */
          else
             Error_Message( _MAIN,MODULE_BUILD_COPA,OPTION_NOT_EXIST,WARN,"" );

        } /* end of while( --ar... */
     if( comar_name == NULL )
        Error_Message( _MAIN,MODULE_BUILD_COPA,NO_COMAR_NAME,ABORT,"" );

     if( absprs_name == NULL )
        Error_Message( _MAIN,MODULE_BUILD_COPA,NO_ABSPRS_NAME,ABORT,"" );


     quick_data = Read_Data( quick_data,seman_data,comar_name,
                             absprs_name,extra_info );

     optim_out_data = Build_Optim( quick_data,user_data,extra_info );

     optim_out_data->seman_list = seman_data->seman_list;
     optim_out_data->nop = *((*quick_data)[5]);

     Write_Parser( user_data,optim_out_data,extra_info );

     if( user_data->automatic_error_correction )
        {
          error_out_data = Build_Error_Out( quick_data,user_data,
                                            optim_out_data,extra_info );
          error_out_data->seman_list = seman_data->seman_list;
          Write_Error_Recovery( user_data,error_out_data,extra_info );
        }
     else
        Write_Error_Recovery( user_data,NULL,extra_info );

     return( 0 );

   } /* end of function main */

