# $Id: src.lalr.back.direct.Makefile.cpp,v 1.11 1992/11/26 16:48:08 cogito Exp $
# $Revision: 1.11 $

DESTDIR = ELISYS
DISTRIB = ELISYS

# parameter for control-output of the read-module


OBJ = dep_main.o build_optim.o build_paths.o clearing.o errors.o \
      error_out.o high_optim.o low_optim.o optim_help.o optim_out.o \
      other_optim.o read_data.o sema_prods.o write_error.o \
      write_help.o write_parser.o

SRC = build_optim.c   error_out.c     optim_help.c    sema_prods.c \
      build_paths.c   errors.c        optim_out.c     write_error.c \
      clearing.c      high_optim.c    other_optim.c   write_help.c \
      dep_main.c      low_optim.c     read_data.c     write_parser.c

HDR = build_optim.h build_paths.h clear.h clearing.h determ.h error_out.h \
      error_text.h errors.h high.h high_optim.h low.h low_optim.h optim_help.h \
      optim_out.h other.h other_optim.h out.h over.h over_types.h reach.h \
      read_data.h sema_prods.h seman.h write_error.h write_help.h write_parser.h

RCSFILES = $(SRC) $(HDR)

IDL     = ../../../idl
ZEITEL  = ../both
AUSGABE = ../../..

LIB = test.a $(IDL)/IDL.a $(ZEITEL)/both.a


IHDRS = -I$(IDL) -I$(ZEITEL) 

CFLAGS  = $(IHDRS)
CC	= cc -O
CO	= co
COFLAGS = -q

TIDY    = core a.out  *% *.o ERRS lintmsg
CLEAN   = $(TIDY) *.exe *.a
CLOBBER = $(CLEAN) Makefile

###########################################################################

all :  $(AUSGABE)/cola_dep.exe

$(AUSGABE)/cola_dep.exe:	$(OBJ) $(LIB)
	$(CC) $(CFLAGS) dep_main.o $(LIB) -o $(AUSGABE)/cola_dep.exe
	
#
# Installation
#
install: $(AUSGABE)/cola_dep.exe
	@echo install -c -s -m 0644 $(AUSGABE)/cola_dep.exe $(DESTDIR)
	@rm -r $(DESTDIR)/cola_dep.exe
	@cp $(AUSGABE)/cola_dep.exe $(DESTDIR)
	@chmod 0644 $(DESTDIR)/cola_dep.exe

#
# Distribution
#

distrib:	$(SRC) $(HDR)
	-rm -rf $(DISTRIB)/lalr/back/direct
	mkdir $(DISTRIB)/lalr/back/direct
	cp $(SRC) $(HDR) Makefile.cpp $(DISTRIB)/lalr/back/direct
	cd $(DISTRIB)/lalr/back/direct; chmod 0644 $(SRC) $(HDR)  Makefile.cpp

#
# Cleaning Targets
#

tidy:
	rm -f $(TIDY)

clean:
	rm -f $(CLEAN)

clobber:
	rm -f $(CLOBBER)

#
# Checking out
#
checkout:	RCS
	$(CO) $(COFLAGS) $(RCSFILES)

#
# Source Distribution
#

SourceDistr: $(RCSFILES) Makefile.cpp README

#if defined(NO_RANLIB)
test.a  :    $(OBJ) 
	rm -f test.a
	ar rcus test.a $(OBJ)
#else
test.a  :    $(OBJ) 
	rm -f test.a
	ar cru test.a $(OBJ)
	ranlib test.a
#endif

##########################################################

dep_main.o   : dep_main.c  		\
	       over_types.h   		\
               over.h         		\
               out.h          		\
               build_optim.h  		\
               write_parser.h 		\
               write_error.h  		\
               error_out.h    		\
               read_data.h    		\
               errors.h        		\
               seman.h        		\
               sema_prods.h


build_optim.o : build_optim.c   	\
               over.h           	\
               over_types.h     	\
               determ.h         	\
               errors.h          	\
               clearing.h       	\
               high_optim.h     	\
               low_optim.h     		\
               other_optim.h   	 	\
               optim_out.h


build_paths.o  : build_paths.c  	\
               over.h           	\
               over_types.h     	\
               determ.h         	\
               high.h           	\
               errors.h



clearing.o   : clearing.c    		\
               over.h        		\
               over_types.h  		\
               determ.h      		\
               clear.h       		\
               errors.h



errors.o      : errors.c       		\
               errors.h       		\
               error_text.h


error_out.o  : error_out.c   		\
               over.h        		\
               over_types.h  		\
               out.h        	 	\
               errors.h       		\
               error_out.h


high_optim.o  : high_optim.c    	\
               over.h           	\
               over_types.h     	\
               determ.h         	\
               clearing.h       	\
               errors.h          	\
               high.h           	\
               build_paths.h


low_optim.o   : low_optim.c  		\
               over.h        		\
               over_types.h 		\
               determ.h      		\
               errors.h       		\
               low.h


optim_help.o : optim_help.c  		\
               over.h        		\
               over_types.h  		\
               determ.h      		\
               errors.h       		\
               out.h         		\
               clearing.h    		\
               reach.h


optim_out.o  : optim_out.c   		\
               over.h        		\
               over_types.h  		\
               determ.h      		\
               errors.h       		\
               out.h         		\
               clearing.h    		\
               reach.h       		\
               optim_help.h 		\
               optim_out.h


other_optim.o : other_optim.c  		\
               over.h          		\
               errors.h         		\
               over_types.h    		\
               determ.h        		\
               other.h

read_data.o  : read_data.c  	        \
	       over_types.h  	        \
               $(ZEITEL)/rd_absprs.h 	\
               $(IDL)/comar.h        	\
               $(IDL)/prsiface.h     	\
	       sema_prods.h          	\
               seman.h               	\
               errors.h 

sema_prods.o : sema_prods.c    		\
	       over_types.h    		\
               $(IDL)/comar.h  		\
               $(IDL)/name.h   		\
               errors.h         		\
               seman.h

write_error.o  : write_error.c  	\
               error_out.h      	\
               over.h           	\
               over_types.h     	\
               out.h            	\
               write_help.h     	\
               errors.h	

write_help.o   : write_help.c  		\
               over.h          		\
               over_types.h    		\
               out.h

write_parser.o   : write_parser.c  	\
               over.h              	\
               over_types.h        	\
               out.h               	\
               write_help.h        	\
               errors.h









