# $Id: Makefile.cpp,v 1.10 1992/06/23 22:23:45 kadhim Exp $
# Copyright (c) 1991, The Regents of the University of Colorado

SHELL	= /bin/sh

CFLAGS	= -I../..
COFLAGS	= -q

SYS	= clp.head clpintf.c clplib.c clplib.pdl clplib.h lists.h

TIDY	= core a.out *.o
CLEAN	= $(TIDY)
CLOBBER	= $(CLEAN) Makefile

all:	$(SYS)

install:
	@for f in $(SYS); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/clp/lib; \
		rm -f $(DESTDIR)/Tool/clp/lib/$$f; \
		cp $$f $(DESTDIR)/Tool/clp/lib/$$f; \
		chmod 644 $(DESTDIR)/Tool/clp/lib/$$f; \
		done

executable:
	rm -rf $(TIDY) Makefile Makefile.cpp

SourceDistr:	$(SYS)

tidy:
	rm -rf $(TIDY)

clean:
	rm -f $(CLEAN)

clobber:
	rm -rf $(CLOBBER)

rcsclean:
	-rcsclean $(COFLAGS) $(SYS) Makefile.cpp
	rm -f $(CLEAN) Makefile

.PRECIOUS:	$(SYS)
