/* $Id: sym.h,v 1.11 1992/07/26 23:11:15 waite Exp $ */
/* Copyright, 1989, The Regents of the University of Colorado */

#ifndef sym_DEF
#define sym_DEF

#include "cagt_config.h"
#include "cagt_usr_err.h"
#include "queue.h"

typedef char *STRPTR;

#define ASNSTRPTR(to,from) to = from;

typedef struct chainelt **SYMTBL;		       /* Symbol table type */


/* Types exported by the symbol table */
typedef struct extobject {        /* Definition of an identifier or literal */
        int str;					  /* Character form */
	int l;						/* Length of string */
	char is_IDNT;			     /* TRUE if IDNT, FALSE if LITT */
	char non_term;	 /* TRUE if IDNT is a Non-Terminal, FALSE otherwise */
	struct symbol_back *back_chain;	 /* Points back at symbol_ptr_nodes */
	struct extobject *assoc;  /* Points at circle of associated SYMBOLs */
	} *SYMBOL;

typedef struct symbol_back {
	struct symbol_back *next;		  /* Chain of back pointers */
	struct symbol_ptr_node *back;	/* Points back at those pointing in */
	} SYMBOL_BACK, *SYMBOL_BACK_PTR;

typedef struct symbol_ptr_node {
	SYMBOL symbol_ptr;			  /* Points at a SYMBOL which 
						     points at an extobject */
	} SYMBOL_PTR_NODE, *SYMBOL_PTR_NODE_PTR;


/* Types local to the symbol table module (Here to make Lint happy) */
struct chainelt {					/* Lookup mechanism */
        struct chainelt *nxt;				      /* Chain link */
        STRPTR ptr;			     /* Pointer to the string table */
        int len;					          /* Length */
        int typ;				   /* Terminal symbol class */
        SYMBOL dat;	      /* Corresponding identifier or literal string */
        };



#define HTSIZE 421		        /* Number of bins in the hash table */




#define mkidentifier(index,symbpt,l,type,nt) \
	if ((*symbpt = (SYMBOL) malloc(sizeof(struct extobject))) == (SYMBOL)0)\
	cagt_msg(0, MSG_EXIT, (cagt_msg_text, msg_arr[-(CAGT_CNTGETMEM)], "mkidentifier", 1))\
        (*symbpt)->str = index;\
        (*symbpt)->l = l;\
	(*symbpt)->is_IDNT = (char) (type == IDNT);\
	(*symbpt)->non_term = nt;\
	(*symbpt)->back_chain = (struct symbol_back *)0;\
	(*symbpt)->assoc = *symbpt;	/* Start out pointing at self */


extern int prtsym();
extern void getsymb();
extern int idnt_exists();
extern int num_assoc_sym();
extern SYMTBL init_sym();
extern SYMTBL set_cur_symtbl();
extern QUEUE_PTR get_symbol_queue();
extern void delete_symtbl();
extern void rename_identifier();
extern SYMBOL_PTR_NODE_PTR first_symbol_ptr();

#endif /* ! sym_DEF */
