static char RCSid[] = "$Id: queue.c,v 1.7 1992/07/26 23:13:01 waite Exp $";
/* Copyright, 1989, The Regents of the University of Colorado */

/* This module implements a first-in-first-out queue, each element of
 * which is a pointer (The basic assumption upon which this module is
 * based is that pointers in C are all of the same size).
 *
 * Routines:
 *      1) init_queue - Create a new queue initialized to the empty state.
 *      2) empty - Returns TRUE if a given queue is empty.
 *      3) dequeue - Remove the first element from a given queue.
 *      4) enqueue - Add an element to the tail of a given queue.
 *      5) empty_queue - Delete all existing elements from a queue.
 *      6) reverse_queue - Reverse the ordering of elements in a given queue.
 *	7) count_queue - Returns the number of elements in a queue.
 *	8) dup_queue - Returns a duplicate queue.
 *	9) delete_queue - Delete an existing queue.
 */

#include <stdio.h>
#include <stdlib.h>
#include "cagt_config.h"
#include "cagt_usr_err.h"
#include "queue.h"







public QUEUE_PTR init_queue()
/* init_queue initializes queue_ptr to an empty state */
   {
   QUEUE_PTR temp;

   GET_MEMORY(temp, QUEUE_PTR, 1, QUEUE, "init_queue", 1)
   temp->front = (QUEUE_ELT_PTR) 0;
   temp->end = (QUEUE_ELT_PTR) 0;
   return(temp);
   }







public int empty(queue_ptr)
   QUEUE_PTR queue_ptr;
/*
 * On Entry:
 *      queue_ptr specifies a valid queue
 * On Exit:
 *      if the queue is empty, empty returns TRUE
 *      otherwise FALSE
*/
   {
   if (queue_ptr->front)
         return(FALSE);
      else
         return(TRUE);
   }







public void *dequeue(queue_ptr)
   QUEUE_PTR queue_ptr;
/*
 * On Entry:
 *      queue_ptr represents a valid queue.
 *
 * On Exit:
 *      If the queue was not empty:
 *         dequeue returns the pointer at the front of the queue and
 *            removes the front element of the queue.
 *      Otherwise
 *         dequeue returns NULL.
*/

   {
   void *ret_val;
   QUEUE_ELT_PTR temp_ptr;


   if (!(temp_ptr = queue_ptr->front))          /* Assignment, not equality */
        return((void *) 0);

   ret_val = queue_ptr->front->value;                     /* Remember value */

   queue_ptr->front = temp_ptr->next;              /* dequeue front element */
   if (!queue_ptr->front) queue_ptr->end = (QUEUE_ELT_PTR) 0;
   FREE_MEMORY(temp_ptr, "dequeue", 1)
   return(ret_val);
   }







public void enqueue(queue_ptr,value)
   QUEUE_PTR queue_ptr;
   void *value;
/*
 * On Entry:
 *      queue_ptr represents a valid queue.
 *      value contains a pointer to a user object.
 *
 * On Exit:
 *      Value has been added to the end of the queue.
*/
   {
   if (queue_ptr->front)
         {
	 GET_MEMORY(queue_ptr->end->next, QUEUE_ELT_PTR, 1, QUEUE_ELT,
		    "enqueue", 1)
         queue_ptr->end = queue_ptr->end->next;
         }
      else
         {
	 GET_MEMORY(queue_ptr->front = queue_ptr->end, QUEUE_ELT_PTR, 1,
		    QUEUE_ELT, "enqueue", 2)
         }
   queue_ptr->end->next = (QUEUE_ELT_PTR) 0;
   queue_ptr->end->value = value;
   }







public void empty_queue(queue_ptr)
   QUEUE_PTR queue_ptr;
/*
 * On Entry:
 *      queue_ptr represents a valid queue.
 *
 * On Exit:
 *      The queue is empty.
*/

   {


   if (queue_ptr->front)
        {
        do {
           queue_ptr->end = queue_ptr->front->next;
	   FREE_MEMORY(queue_ptr->front, "empty_queue",1)
           queue_ptr->front = queue_ptr->end;
           } while (queue_ptr->end != (QUEUE_ELT_PTR) 0);
        queue_ptr->front = (QUEUE_ELT_PTR) 0;
        }
   }







public void reverse_queue(queue_ptr)
   QUEUE_PTR queue_ptr;
/*
 * On Entry:
 *      queue_ptr represents a valid queue.
 *
 * On Exit:
 *      The queue has been reversed (last element is now first)
*/
   {
   QUEUE_ELT_PTR temp;
   QUEUE_ELT_PTR reverse = (QUEUE_ELT_PTR) 0;

   while (queue_ptr->front)
	{
	temp = queue_ptr->front;
	queue_ptr->front = queue_ptr->front->next;
	temp->next = reverse;
	reverse = temp;
	}
   queue_ptr->front = queue_ptr->end;
   queue_ptr->end = reverse;

   }







public int count_queue(queue_ptr)
   QUEUE_PTR queue_ptr;
/*
 * On Entry:
 *      queue_ptr represents a valid queue.
 *
 * On Exit:
 *	The number of elements in the queue is returned.
*/

   {
   QUEUE_ELT_PTR cur = queue_ptr->front;
   int num = 0;

   while (cur)
	{
	num++;
	cur = cur->next;
	}
   return num;
   }







public QUEUE_PTR dup_queue(queue_ptr)
   QUEUE_PTR queue_ptr;
/*
 * On Entry:
 *      queue_ptr represents a valid queue.
 *
 * On Exit:
 *	The QUEUE_PTR for a duplicate queue is returned.
*/
   {
   QUEUE_PTR dup;
   QUEUE_ELT_PTR temp = queue_ptr->front;

   dup = init_queue();
   while (temp)
	{
	enqueue(dup,((void *) temp->value));
	temp = temp->next;
	}

   return(dup);
   }







public void delete_queue(queue_ptr)
   QUEUE_PTR queue_ptr;
/* delete_queue returns all storage to the operating system. The
 * queue is then unusable unless reinitialized with init_queue.
 *
 * On entry:
 *	queue_ptr specifies a valid queue.
 * On exit:
 *	The queue has been deleted.
*/
   {
   empty_queue(queue_ptr);

   FREE_MEMORY(queue_ptr, "delete_queue", 1)
   }
