/* $Id: gram_parse.y,v 1.16 1992/08/02 22:25:39 kadhim Exp $ */
/* Copyright, 1989, The Regents of the University of Colorado */

/* The original CAGT (May 1986) did not use a parser in
 * it's front end, leading to an unnecessarily large and
 * complicated grammar structure. This module specifies a parser to
 * build the grammar structure simplifying the grammar structure, and
 * improving error detection.
 *
 * Routines:
 *	1) get_ebnf_grammar - Returns a pointer to an ebnf grammar.
 */

%{
#include "gram_parse.h"
%}

/* Terminals returned by lexical analyzer - must agree with term.h */
/* Not all of these codes are seen by the parser */
%token	<intval>	EOPT	0
%token	<intval>	NULT	1
%token	<intval>	IDNT	2
%token	<intval>	LITT	3
%token	<intval>	LPNT	4
%token	<intval>	RPNT	5
%token	<intval>	LBKT	6
%token	<intval>	RBKT	7
%token	<intval>	CLNT	8
%token	<intval>	IST	9
%token	<intval>	BART	10
%token	<intval>	ASTT	11
%token	<intval>	PLST	12
%token	<intval>	DOTT	13
%token	<intval>	SEPT	14
%token	<intval>	SLHT	15
%token	<intval>	AMPT	16
%token	<intval>	GTRT	17
%token	<intval>	LSST	18
%token	<intval>	 ATT	19
%token	<intval>	DOLT	20
%token	<intval>	CMNT	21

%start specification

%{
#include <stdio.h>
#include "cagt_config.h"
#include "support.h"
#include "gram.h"
#include "cagt.h"
#include "cagt_usr_err.h"

/*
 * Given the start node of a list (first) EOL returns the tail (last).
 * The use of this macro is driven by the need to build lists from
 * left recursive productions. It is inherently inefficient, but
 * simple to implement. If measurments indicate that parsing is
 * taking too long, a more sophisticated approach to building
 * such lists should be considered.
*/
#define EOL(first,last) last = first; while(last->next) last = last->next;

LEFT_NODE_PTR start;			       /* Top of grammar structure */
RIGHT_NODE_PTR temp;			        /* Used to build sub-rules */
char build_gs;		/* Used to stop gram. struc. construction on error */

%}
%%
specification	: rule		{ if (build_gs) start = $<l_s>1; }
		| specification
		  rule		{
				if (build_gs)
				   {
				   $<l_s>1->next_rule=$<l_s>2;
				   $<l_s>$ = $<l_s>2;
				   }
				}
		| error		{
				message(FATAL,"Syntax error",
					                0,&(lex_curtok.pos));
				build_gs = FALSE;
				}
		  DOTT
		;

rule		: l_identifier
		  IST expression
		  DOTT		{
				if (build_gs)
				   {
				   $<l_s>1->right_side =
						      create_right_node(IST);
				   $<l_s>1->right_side->next=$<r_s>3;
				   EOL($<r_s>3,temp)
				   temp->next=create_right_node(DOTT);
				   $<l_s>$ = $<l_s>1;
				   }
				}
		| l_identifier
		  IST DOTT	{
				if (build_gs)
				   {
				   $<l_s>1->right_side = temp =
						      create_right_node(IST);
				   temp->next=create_right_node(DOTT);
				   $<l_s>$ = $<l_s>1;
				   }
				}
		;

expression	: tertiary	{ if (build_gs) $<r_s>$ = $<r_s>1; }
		| expression
		  SEPT atom	{
				if (build_gs)
				   $<r_s>$ = create_infix_node(SEPT,
							    $<r_s>1,$<r_s>3);
				}
		;

tertiary	: secondary	{ if (build_gs) $<r_s>$ = $<r_s>1; }
		| tertiary BART
		  secondary	{
				if (build_gs)
				   $<r_s>$ = create_infix_node(BART,
							    $<r_s>1,$<r_s>3);
				}
		| BART
		  secondary	{
				if (build_gs)
				   $<r_s>$ = create_infix_node(BART,
					       (RIGHT_NODE_PTR)0,$<r_s>2);
				}
		| tertiary BART
		  		{
				if (build_gs)
				   $<r_s>$ = create_infix_node(BART,
					      $<r_s>1, (RIGHT_NODE_PTR)0);
				}
		;

secondary	: primary	{ if (build_gs) $<r_s>$ = $<r_s>1; }
		| secondary
		  primary	{
				if (build_gs)
				   {
				   EOL($<r_s>1,temp);
				   temp->next = $<r_s>2;
				   $<r_s>$ = $<r_s>1;
				   }
				}
		;

primary		: unit		{ if (build_gs) $<r_s>$ = $<r_s>1; }
		| unit ASTT	{
				if (build_gs)
				   {
				   $<r_s>$ = create_right_node(ASTT);
				   $<r_s>$->x.nest = $<r_s>1;
				   }
				}
		| unit PLST	{
				if (build_gs)
				   {
				   $<r_s>$ = create_right_node(PLST);
				   $<r_s>$->x.nest = $<r_s>1;
				   }
				}
		| LBKT expression
		  RBKT		{
				if (build_gs)
				   {
				   $<r_s>$ = create_right_node(LBKT);
				   $<r_s>$->x.nest = $<r_s>2;
				   EOL($<r_s>2,temp)
				   temp->next = create_right_node(RBKT);
				   }
				}
		;

unit		: atom		{ if (build_gs) $<r_s>$ = $<r_s>1; }
		| LPNT expression
		  RPNT		{
				if (build_gs)
				   {
				   $<r_s>$ = create_right_node(LPNT);
				   $<r_s>$->x.nest = $<r_s>2;
				   EOL($<r_s>2,temp)
				   temp->next = create_right_node(RPNT);
				   }
				}
		;

atom		: r_identifier	{ if (build_gs) $<r_s>$ = $<r_s>1; }
		| LITT		{
				if (build_gs)
				   {
				   $<r_s>$=create_right_node(LITT);
				   $<r_s>$->x.text = first_symbol_ptr(
					       lex_curtok.subrosa.LITVAL);
				   }
				}
		| connection	{ if (build_gs) $<r_s>$ = $<r_s>1; }
		| pgs_mod	{ if (build_gs) $<r_s>$ = $<r_s>1; }
		;

l_identifier	: IDNT		{
				if (build_gs)
				   {
				   $<l_s>$ = create_left_node(IDNT,
					       lex_curtok.subrosa.IDSYMB);
				   lex_curtok.subrosa.IDSYMB->non_term =TRUE;
				   }
				}
	 	| LSST l_bnf_idnt
		  GTRT		{ if (build_gs) $<l_s>$ = $<l_s>2; }
		;

l_bnf_idnt	: IDNT
				{
				if (build_gs)
				   {
				   $<l_s>$ = create_left_node(IDNT,
					       lex_curtok.subrosa.IDSYMB);
    				   lex_curtok.subrosa.IDSYMB->non_term =TRUE;
				   }
				}
		;


r_identifier	: IDNT		{
				if (build_gs)
				   {
				   $<r_s>$ = create_right_node(IDNT);
				   $<r_s>$->x.text = first_symbol_ptr(
					       lex_curtok.subrosa.IDSYMB);
				   }
				}
	 	| LSST r_bnf_idnt
		  GTRT		{ if (build_gs) $<r_s>$ = $<r_s>2; }
		;

r_bnf_idnt	: IDNT		{
				if (build_gs)
				   $<r_s>$ = create_right_node(IDNT);
				   $<r_s>$->x.text = first_symbol_ptr(
					       lex_curtok.subrosa.IDSYMB);
				}
		;

connection	: AMPT LITT	{
				if (build_gs)
				   {
				   $<r_s>$ = create_right_node(AMPT);
				   $<r_s>$->x.nest = create_right_node(LITT);
				   $<r_s>$->x.nest->x.text =first_symbol_ptr(
					       lex_curtok.subrosa.LITVAL);
				   }
				}
		;

pgs_mod		: pgs_mod_token
		  IDNT		{
				if (build_gs)
				   {
				   $<r_s>1->x.nest = create_right_node(IDNT);
				   $<r_s>1->x.nest->x.text =first_symbol_ptr(
					       lex_curtok.subrosa.IDSYMB);
				   $<r_s>$ = $<r_s>1;
				   }
				}
		| pgs_mod_token
		  LITT		{
				if (build_gs)
				   {
				   $<r_s>1->x.nest = create_right_node(LITT);
				   $<r_s>1->x.nest->x.text =first_symbol_ptr(
					       lex_curtok.subrosa.LITVAL);
				   $<r_s>$ = $<r_s>1;
				   }
				}

		;

pgs_mod_token	: ATT		{
				if (build_gs)
					$<r_s>$ = create_right_node(ATT);
				}
		| DOLT		{
				if (build_gs)
					$<r_s>$ = create_right_node(DOLT);
				}
		;

%%


public LEFT_NODE_PTR get_ebnf_grammar(file, desc, init_table)
   char *file;
   int desc;
   char init_table;
/*
 * On Entry:
 *      The lexical analyzer is not in use elsewhere.
 *	file contains the name of the file containing the grammar.
 *	desc is a file descriptor for file.
 *	init_table is TRUE if a new symbol table needs to be created,
 *	   FALSE if a valid table is already in use.
 * On Exit:
 *	get_ebnf_grammar returns a pointer to a complete EBNF internal
 *	   grammar structure.
 *	The lexical analyzer has returned the EOPT token
 *	   (i.e. input is exhausted).
 *	A valid symbol table exists.
*/
   {
   LEFT_NODE_PTR cur;
   SYMBOL_PTR_NODE_PTR dummy;		      /* used to call is_chainrule */

   initBuf(file, desc);			       /* Initialize Source Module */
   lexinit();			     /* Initialize Lexical Analysis Module */
   if (init_table) (void) set_cur_symtbl(init_sym()); /* Get Symbol Table */


   /* Read and normalize grammar */
   build_gs = TRUE;		     /* Build gram. structure unless error */
   (void) yyparse();
   if (ErrorCount[FATAL] != 0)
	{
	usr_do_errlist_exit(ErrorCount[FATAL], file, err_fname);
	exit(1);
	}
   cur = start;
   while (cur)
	{
	remove_alternation(cur);	      /* Separate alternated rules */
	trim_nesting(cur->right_side);	    /* Remove unneeded parenthesis */
	/* Set chain rule status */
	cur->chain_rule = is_chainrule(cur->right_side, FALSE, &dummy, TRUE);
	cur = cur->next_rule;
	}

   (void) delete_redundant_rules(start);       /* Weed out duplicate rules */

   return(start);
   }







#ifdef DEBUG
main()
{
SYMTBL table;
char *file = "test.dat";
int desc;
LEFT_NODE_PTR grammar;


if ( (desc = open(file,0)) == -1)
   {
   (void) fprintf(stderr,"FILE OPEN TROUBLES\n");
   exit(1);
   }


grammar = get_ebnf_grammar(file,desc,&table,TRUE);
output_ebnf_grammar(stdout,start);
}
#endif






yyerror(s) char *s; {
#ifdef lint				     /* Avoid argument s unused msg */
	(void) fprintf(stderr,"%s at line %d\n",s,lex_curtok.pos.line);
#endif
	}
