/* $Id: gram_parse.h,v 1.5 1991/07/01 21:35:30 tony Exp $ */
/* Copyright, 1989, The Regents of the University of Colorado */

#ifndef gram_parse_DEF
#define gram_parse_DEF

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif



/* This defines the union for yylval that YACC and yylex use to point at
 * lex_curtok.
 */
typedef union
	{
	int intval;
	struct left_node *l_s;
	struct right_node *r_s;
	} YYSTYPE;

extern YYSTYPE yylval;



extern struct left_node *get_ebnf_grammar(/* file, desc, init_table */);
   /*
   char *file;
   int desc;
   char init_table;
   */
/*
 * On Entry:
 *      The lexical analyzer is not in use elsewhere.
 *	file contains the name of the file containing the grammar.
 *	desc is a file descriptor for file.
 *	*table is a symbol table pointer.
 *	init_table is TRUE if a new symbol table needs to be created,
 *	   FALSE if a valid table is already in use.
 * On Exit:
 *	get_ebnf_grammar returns a pointer to a complete EBNF internal
 *	   grammar structure.
 *	The lexical analyzer has returned the EOPT token
 *	   (i.e. input is exhausted).
 *	A valid symbol table exists.
*/

#endif /* ! gram_parse_DEF */
