/* $Id: gram.h,v 1.6 1991/07/01 21:34:33 tony Exp $ */
/* Copyright, 1989, The Regents of the University of Colorado */

#ifndef gram_DEF
#define gram_DEF

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif


typedef struct left_node LEFT_NODE;
typedef struct left_node *LEFT_NODE_PTR;
typedef struct right_node RIGHT_NODE;
typedef struct right_node *RIGHT_NODE_PTR;
typedef struct infix_nest INFIX_NEST;
typedef struct infix_nest *INFIX_NEST_PTR;
typedef struct rel_chain_elt REL_CHAIN_ELT;
typedef struct rel_chain_elt *REL_CHAIN_ELT_PTR;



/* left_node defines the left side of a grammar rule */
struct left_node {
        int code;					      /* Token code */
        SYMBOL_PTR_NODE_PTR text;	      /* Identifier or Literal Text */
	char chain_rule;			  /* Rules chainrule status */
	REL_CHAIN_ELT_PTR rel_ptr;	   /* Holds rule #s this abstract rule
					     represents in concrete grammar
					     ('relationship index')         */
	RIGHT_NODE_PTR right_side;	    /* Points at right side of rule */
	LEFT_NODE_PTR next_rule;		     /* Points at next rule */
	LEFT_NODE_PTR undo;		       /* Rule replaced by this one */
	LEFT_NODE_PTR redo;			 /* Rule replacing this one */
	};



/*
 * A rel_chain_elt (relationship chain element) holds the number of a rule
 * in the concrete grammar that is represented by the current rule in the
 *  abstract grammar. An abstract rule can represent more than one concrete
 *  rule, hence rel_chain_elts can be combined into a linked list.
*/
struct rel_chain_elt {
	int rule_num;
	REL_CHAIN_ELT_PTR next;
	};



struct right_node {
        int code;					      /* Token code */
	RIGHT_NODE_PTR next;			    /* Next element of rule */
	RIGHT_NODE_PTR undo;		    /* Subtree replaced by this one */
	RIGHT_NODE_PTR redo;		      /* Subtree replacing this one */
	union {					      /* Mutually Exclusive */
           SYMBOL_PTR_NODE_PTR text;	      /* Identifier or Literal Text */
	   RIGHT_NODE_PTR nest;		   /* Points to nested rule section */
	   INFIX_NEST_PTR infix;		 /* Points to infix nesting */
	   } x;
	};



/*
 * infix_nest contains pointers to the left and right sides of an
 * infix rule. It is used via the x (extend) field of the right_node
 * struct to allow alternation and seperater nesting.
*/
struct infix_nest {
	RIGHT_NODE_PTR left;			      /* Left side of infix */
	RIGHT_NODE_PTR right;			     /* Right side of infix */
	};



/*
 * An indexed_access_block is used to manage the access to grammar rules
 * in constant time.
*/
struct indexed_access_block {
	int rule_cnt;			 /* Number of rules in EBNF grammar */
	LEFT_NODE_PTR *block;		/* Points to block of ptrs to rules */
	};


/* Include files that are part of the grammar module */
#include "gram_parse.h"
#include "gram_tools.h"
#include "gram_rev.h"
#include "gram_fileio.h"


#endif	/* ! gram_DEF */
