/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  _vga.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/



/*   Basic graphic routines (declared in "msdos.h")
     for VGA 640x480 monochrome graphics mode     

     experimental implementation

 */


#ifdef __TURBOC__
#include <alloc.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include <dos.h>

#include "msdos.h"

static unsigned char FONT[] =
{ 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,126,129,165,129,129,189,153,129,129,126,  0,  0,  0,  0,
  0,  0,126,255,219,255,255,195,231,255,255,126,  0,  0,  0,  0,
  0,  0,102,255,255,255,255,126,126, 60, 60, 24, 24,  0,  0,  0,
  0, 24, 24, 60, 60,126,126,255,126,126, 60, 60, 24, 24,  0,  0,
  0,  0, 24, 60, 60, 24,102,255,255,102, 24, 60,126,  0,  0,  0,
  0,  0, 24, 24, 60, 60,126,255,255,255,126, 24, 60,126,  0,  0,
  0,  0,  0,  0,  0, 24, 60, 60, 60, 24,  0,  0,  0,  0,  0,  0,
255,255,255,255,231,195,195,195,231,255,255,255,255,255,255,255,
  0,  0,  0, 60,102, 66, 66, 66,102, 60,  0,  0,  0,  0,  0,  0,
255,255,255,195,153,189,189,189,153,195,255,255,255,255,255,255,
  0, 30, 14, 26, 50,120,204,204,204,204,120,  0,  0,  0,  0,  0,
  0, 60,102,102,102,102, 60, 24,126, 24, 24,  0,  0,  0,  0,  0,
  0, 63, 51, 51, 63, 48, 48, 48,112,240,224,  0,  0,  0,  0,  0,
  0,127, 99, 99,127, 99, 99, 99,103,231,230,192,  0,  0,  0,  0,
  0, 24, 24,219, 60,231,231, 60,219, 24, 24,  0,  0,  0,  0,  0,
  0,128,192,224,248,254,254,248,224,192,128,  0,  0,  0,  0,  0,
  0,  2,  6, 14, 62,254,254, 62, 14,  6,  2,  0,  0,  0,  0,  0,
 24, 60,126, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,126, 60, 24,
  0,102,102,102,102,102,102,102,102,102,  0,102,102,  0,  0,  0,
  0,127,219,219,219,219,219,123, 27, 27, 27, 27, 27,  0,  0,  0,
  0,124,198, 96, 56,108,198,198,108, 56, 12,198,124,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,254,254,254,254,254,  0,  0,  0,
  0, 24, 60,126, 24, 24, 24, 24, 24,126, 60, 24,126,  0,  0,  0,
 24, 60,126,255, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,255,126, 60, 24,
  0,  0,  0,  0,  8, 12, 14,255, 14, 12,  8,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 16, 48,112,255,112, 48, 16,  0,  0,  0,  0,  0,
  0,  0,  0,  0,192,192,192,192,254,254,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 36,102,255,102, 36,  0,  0,  0,  0,  0,  0,
  0,  0, 16, 16, 56, 56,124,124,254,254,  0,  0,  0,  0,  0,  0,
  0,  0,254,254,124,124, 56, 56, 16, 16,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 24, 60, 60, 60, 60, 24, 24, 24, 24,  0, 24, 24,  0,  0,  0,
  0, 99, 99,198,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
108,108,108,254,254,108,108,108,254,254,108,108,108,  0,  0,  0,
 48, 48,120,204,192,192,192,120, 12, 12, 12,204,120, 48, 48,  0,
  0,230,166,236, 12, 24, 24, 48, 48, 96,110,202,206,  0,  0,  0,
  0, 56,108,108,108, 56,118,220,220,204,204,204,118,  0,  0,  0,
  0, 24, 24, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 12, 24, 24, 48, 48, 48, 48, 48, 48, 48, 48, 24, 24, 12,  0,  0,
 48, 24, 24, 12, 12, 12, 12, 12, 12, 12, 12, 24, 24, 48,  0,  0,
  0,  0,  0,  0,  0,102,102, 60,255,255, 60,102,102,  0,  0,  0,
  0,  0,  0,  0,  0, 24, 24,126,126, 24, 24,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 24, 24, 48,  0,  0,
  0,  0,  0,  0,  0,  0,  0,126,126,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 24, 24,  0,  0,  0,
  0,  6,  6, 12, 12, 24, 24, 48, 48, 96, 96,192,192,  0,  0,  0,
  0,124,198,198,198,206,222,246,230,198,198,198,124,  0,  0,  0,
  0, 24, 56,120, 24, 24, 24, 24, 24, 24, 24, 24,126,  0,  0,  0,
  0,124,198,  6,  6, 12, 24, 48, 96,192,198,198,254,  0,  0,  0,
  0,254,  6, 12, 24, 48, 56, 12,  6,  6,198,108, 56,  0,  0,  0,
  0, 28, 28, 60, 60,108,108,204,204,254, 12, 12, 30,  0,  0,  0,
  0,252,192,192,192,248,204,  6,  6,  6,134,204,120,  0,  0,  0,
  0, 60, 96,192,192,248,236,198,198,198,198,108, 56,  0,  0,  0,
  0,254,198,  6, 12, 12, 24, 24, 48, 48, 48, 48, 48,  0,  0,  0,
  0,124,198,198,198,198,124,124,198,198,198,198,124,  0,  0,  0,
  0, 56,108,198,198,198,198,110, 62,  6,  6, 12,120,  0,  0,  0,
  0,  0,  0,  0,  0, 24, 24,  0,  0,  0,  0, 24, 24,  0,  0,  0,
  0,  0,  0,  0,  0, 24, 24,  0,  0,  0,  0, 24, 24, 48,  0,  0,
  0,  0,  3,  6, 12, 24, 48, 96, 48, 24, 12,  6,  3,  0,  0,  0,
  0,  0,  0,  0,  0,126,126,  0,126,126,  0,  0,  0,  0,  0,  0,
  0,  0,192, 96, 48, 24, 12,  6, 12, 24, 48, 96,192,  0,  0,  0,
  0,124,254,198,198, 12, 12, 24, 24, 24,  0, 24, 24,  0,  0,  0,
  0,  0,  0,124,198,198,222,222,222,220,192,192,124,  0,  0,  0,
  0, 16, 56,124,238,198,198,198,198,254,198,198,198,  0,  0,  0,
  0,252,102,102,102,102,124,102,102,102,102,102,252,  0,  0,  0,
  0, 60,102,194,192,192,192,192,192,192,194,102, 60,  0,  0,  0,
  0,248,108,102,102,102,102,102,102,102,102,108,248,  0,  0,  0,
  0,254,102, 98, 96,104,120,104, 96, 96, 98,102,254,  0,  0,  0,
  0,254,102, 98, 96,104,120,104, 96, 96, 96, 96,248,  0,  0,  0,
  0, 60,102,194,192,192,192,222,198,198,198,102, 58,  0,  0,  0,
  0,198,198,198,198,198,254,198,198,198,198,198,198,  0,  0,  0,
  0, 60, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 60,  0,  0,  0,
  0, 30, 12, 12, 12, 12, 12, 12,204,204,204,120,120,  0,  0,  0,
  0,230,102,102,108,108,120,108,108,102,102,102,230,  0,  0,  0,
  0,240, 96, 96, 96, 96, 96, 96, 96, 96, 98,102,254,  0,  0,  0,
  0,198,238,254,254,214,214,214,198,198,198,198,198,  0,  0,  0,
  0,198,198,230,230,246,246,222,222,206,206,198,198,  0,  0,  0,
  0, 56,108,198,198,198,198,198,198,198,198,108, 56,  0,  0,  0,
  0,252,102,102,102,102,102,124, 96, 96, 96, 96,240,  0,  0,  0,
  0, 56,108,198,198,198,198,198,198,198,222,126, 60, 12, 14,  0,
  0,252,102,102,102,102,102,124,108,102,102,102,246,  0,  0,  0,
  0,124,198,198,192, 96, 48, 24, 12,  6,198,198,124,  0,  0,  0,
  0,126,126, 90, 24, 24, 24, 24, 24, 24, 24, 24, 60,  0,  0,  0,
  0,198,198,198,198,198,198,198,198,198,198,198,124,  0,  0,  0,
  0,198,198,198,198,198,198,198,198,198,124, 56, 16,  0,  0,  0,
  0,198,198,198,198,214,214,214,214,214,254,108,108,  0,  0,  0,
  0,198,198,108,108, 56, 56, 56, 56,108,108,198,198,  0,  0,  0,
  0,102,102,102,102,102,126, 60, 24, 24, 24, 24, 60,  0,  0,  0,
  0,254,198,140, 12, 24, 24, 48, 48, 96, 98,198,254,  0,  0,  0,
  0, 60, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 60,  0,  0,  0,
  0,192,192, 96, 96, 48, 48, 24, 24, 12, 12,  6,  6,  0,  0,  0,
  0, 60, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 60,  0,  0,  0,
  0, 16, 56,108,198,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,255,255,  0,
  0, 48, 48, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,120, 12,124,204,204,204,204,118,  0,  0,  0,
  0,224, 96, 96, 96,124,126,102,102,102,102,118,220,  0,  0,  0,
  0,  0,  0,  0,  0,124,198,192,192,192,192,198,124,  0,  0,  0,
  0, 28, 12, 12, 12,124,252,204,204,204,204,220,118,  0,  0,  0,
  0,  0,  0,  0,  0,124,198,198,198,254,192,198,124,  0,  0,  0,
  0, 56,108,100, 96,240, 96, 96, 96, 96, 96, 96,240,  0,  0,  0,
  0,  0,  0,  0,  0,118,204,204,204,204,204,204,124, 12,204,120,
  0,224, 96, 96, 96,124,102,102,102,102,102,102,230,  0,  0,  0,
  0,  0, 24, 24,  0, 56, 24, 24, 24, 24, 24, 24, 60,  0,  0,  0,
  0,  0,  6,  6,  0, 14,  6,  6,  6,  6,  6,  6,  6,102,102, 60,
  0,224, 96, 96, 96,102,102,108,120,108,102,102,230,  0,  0,  0,
  0, 56, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 60,  0,  0,  0,
  0,  0,  0,  0,  0,236,254,214,214,214,198,198,198,  0,  0,  0,
  0,  0,  0,  0,  0,220,102,102,102,102,102,102,102,  0,  0,  0,
  0,  0,  0,  0,  0,124,198,198,198,198,198,198,124,  0,  0,  0,
  0,  0,  0,  0,  0,220,102,102,102,102,102,102,124, 96, 96,240,
  0,  0,  0,  0,  0,118,204,204,204,204,204,204,124, 12, 12, 30,
  0,  0,  0,  0,  0,220,118,102, 96, 96, 96, 96,240,  0,  0,  0,
  0,  0,  0,  0,  0,124,198,192,112, 28,  6,198,124,  0,  0,  0,
  0,  0, 16, 48, 48,252, 48, 48, 48, 48, 48, 54, 28,  0,  0,  0,
  0,  0,  0,  0,  0,204,204,204,204,204,204,204,118,  0,  0,  0,
  0,  0,  0,  0,  0,198,198,198,198,238,124, 56, 16,  0,  0,  0,
  0,  0,  0,  0,  0,198,198,214,214,214,214,254,108,  0,  0,  0,
  0,  0,  0,  0,  0,198,238,124, 56, 56,124,238,198,  0,  0,  0,
  0,  0,  0,  0,  0,198,198,198,198,198,198,198,126, 12, 24,112,
  0,  0,  0,  0,  0,254,198, 12, 24, 48, 96,198,254,  0,  0,  0,
  0, 14, 24, 24, 24, 24,112,112, 24, 24, 24, 24, 14,  0,  0,  0,
  0, 24, 24, 24, 24, 24,  0,  0, 24, 24, 24, 24, 24,  0,  0,  0,
  0,112, 24, 24, 24, 24, 30, 30, 24, 24, 24, 24,112,  0,  0,  0,
  0,  0,118,220,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 16, 56,108,198,198,198,254,  0,  0,  0,  0 
};

#if defined(GNUDOS)
#define VIDEO_PTR    unsigned char*
#else
#define VIDEO_PTR    unsigned char far*
#endif


static VIDEO_PTR  VIDEO_START;
static VIDEO_PTR  screen_buf;

static int COLOR = 0;
static int MODE = 0; 
static int LINEWIDTH = 1; 
static int LINESTYLE = 0;

static void put_pixel(int x, int y, int col)
{ register VIDEO_PTR pos = VIDEO_START+80*y+(x>>3);

  if (x < 0 || x > 639 || y < 0 || y > 479) return;

  if (MODE==0) /* copy */
     if (col)
        *pos |=  (128 >> (x&7));
     else
        *pos &= ~(128 >> (x&7));
  else        /* xor */
     if (col==0)
        *pos ^=  (128 >> (x&7));
}


static int   get_pixel(int x, int y)
{ register VIDEO_PTR pos = VIDEO_START;
  if (x < 0 || x > 639 || y < 0 || y > 479) return 0;
  pos += 80*y+(x>>3);
  return ((*pos & (128 >> (x&7))) !=0);
}



static void vline(int x, int y0, int y1, int col)
{ register VIDEO_PTR pos = VIDEO_START;
  register VIDEO_PTR last= pos + 80*y1+x/8;
  int y;
  unsigned char byte = 128 >> (x&7);

  if (x < 0 || x > 639 || y1 < 0 || y0 > 479) return;

  if (y0 < 0)   y0 = 0;
  if (y1 > 479) y1 = 479;


  pos += 80*y0+x/8;

  if (MODE==0)  /* copy */
     if (col)
        while(pos <= last)
        { *pos |= byte; 
          pos += 80;
         }
     else
        while(pos <= last)
        { *pos &= ~byte;
          pos += 80;
          }
  else         /* xor */
     if (col==0)
        while(pos <= last)
        { *pos ^= byte;
          pos += 80;
         }

}


#define FILLPUT(pos,byte,d)\
{ p = pos;\
  if (*p & (byte))\
  { *p &= ~(byte);\
    POS[top] = p; \
    BYTE[top] = byte; \
    DIR[top]= d; \
    top++; \
    top &= 2047; } else;\
}

static void fill(int x, int y)
{ register int bot = 0;
  register int top = 0;
  VIDEO_PTR      POS[2048];
  unsigned char  BYTE[2048];
  char           DIR[2048];
  int d;
  VIDEO_PTR p;
  VIDEO_PTR pos;
  unsigned char byte;

  pos = VIDEO_START + 80*y + x/8;
  byte = (128 >> (x&7));

  FILLPUT(pos,byte,0)

  while (top != bot)
  { pos  = POS[bot];
    byte = BYTE[bot];
    d    = DIR[bot];
    bot++;
    bot &= 2047;
    if (d != 1) 
      if (byte == 128)
         FILLPUT(pos-1,1,3) 
      else
         FILLPUT(pos,byte<<1,3) 
    if (d != 3)
      if (byte == 1)
         FILLPUT(pos+1,128,1) 
      else
         FILLPUT(pos,byte>>1,1) 
    if (d != 2) FILLPUT(pos-80,byte,4)
    if (d != 4) FILLPUT(pos+80,byte,2)
  }
}



/* routines declared in "msdos.h" */


int   max_xcoord()         { return 639; }
int   max_ycoord()         { return 479; }
int   text_height(char* s) { return 16; }
int   text_width(char* s)  { return 8*strlen(s); }
int   get_mode()           { return MODE; }
void  set_mode(int mode)   { MODE = mode; }
int   get_color()          { return COLOR; }
void  set_color(int color) { COLOR = (color==0) ? 1 : 0; }
float xy_ratio()           { return 1; }

void  set_line_style(int style,int width)
{ LINESTYLE = style;
  LINEWIDTH = width;
 }


void init_graphics()
{ union REGS regs;

/* set graphics mode 12 (VGA) */
  regs.h.ah=0x00;
  regs.h.al=0x12;
  int86(0x10,&regs,&regs);

#if defined(GNUDOS)
  VIDEO_START = (VIDEO_PTR)0xd0000000;
#else
#if defined(__ZTC__) && defined(DOS386)
  VIDEO_START = (VIDEO_PTR)_x386_mk_protected_ptr(0xa0000);
#else
  VIDEO_START = (VIDEO_PTR)MK_FP(0xa000,0);
#endif
#endif

  screen_buf =  malloc(80*480);
}


void exit_graphics()
{ union REGS regs;
  regs.h.ah=0x00;
  regs.h.al=0x02;
  int86(0x10,&regs,&regs);

  free((char*)screen_buf);
}


void  clear_screen() 
{ register VIDEO_PTR p;
  register VIDEO_PTR stop = VIDEO_START + 480*80;
  for(p=VIDEO_START; p != stop; p++) *p = 0xFF;
}



void pixel(int x, int y) { put_pixel(x,y,COLOR);}



void line(int x1, int y1, int x2, int y2)
{
  int sx = 1;
  int sy = 1;
  int dx = x2 - x1;
  int dy = y2 - y1;

  int count;
  int i,c,max;

  if (dx==0)
  { if (y1 > y2)
    { c = y1;
      y1 = y2;
      y2 = c;
     }
    vline(x1,y1,y2,COLOR);
    for (i=1; i<=LINEWIDTH/2; i++)
    { vline(x1-i,y1,y2,COLOR);
      vline(x1+i,y1,y2,COLOR);
     }
    return;
   }

  if (dx < 0)
  { dx *= -1;
    sx *= -1;
   }

  if (dy < 0)
  { dy *= -1;
    sy *= -1;
   }

  if (dx > dy)
  { max = dx;
    c = dx / 2;
    put_pixel(x1, y1, COLOR);
    for (i=1; i<=LINEWIDTH/2; i++)
    { put_pixel(x1, y1+i, COLOR);
      put_pixel(x1, y1-i, COLOR);
     }
    for (count = dx; count; count--)
    { x1 += sx;
      c += dy;
      if (c > max)
      { c -= dx;
        y1 += sy;
       }
      put_pixel(x1, y1, COLOR);
      for (i=1; i<=LINEWIDTH/2; i++)
      { put_pixel(x1, y1+i, COLOR);
        put_pixel(x1, y1-i, COLOR);
       }
    }
  }
  else
  { max = dy;
    c = dy / 2;
    put_pixel(x1, y1, COLOR);
    for (i=1; i<=LINEWIDTH/2; i++)
    { put_pixel(x1+i, y1, COLOR);
      put_pixel(x1-i, y1, COLOR);
     }
    for (count = dy; count; count--)
    { y1 += sy;
      c += dx;
      if (c > max)
      { c -= dy;
        x1 += sx;
       }
      put_pixel(x1, y1, COLOR);
      for (i=1; i<=LINEWIDTH/2; i++)
      { put_pixel(x1+i, y1, COLOR);
        put_pixel(x1-i, y1, COLOR);
       }
    }
  }
}


void fill_polygon(n,xcoord,ycoord)
int n, *xcoord, *ycoord;
{ int i,j,m1,m2;
  int minxi = 0;
  int maxxi = 0;
  int minyi = 0;
  int maxyi = 0;
  int minx,maxx,miny,maxy;
  int save_mode  = MODE;
  int save_color = COLOR;
  int save_lw    = LINEWIDTH;

  VIDEO_PTR start1;
  VIDEO_PTR start2;
  VIDEO_PTR video_start = VIDEO_START;
  VIDEO_PTR stop;
  VIDEO_PTR p;
  VIDEO_PTR q;

  VIDEO_START = screen_buf;
  clear_screen();
  MODE  = 0;
  COLOR = 0;
  LINEWIDTH = 1;

  for(i=0; i<n-1; i++) 
     line(xcoord[i],ycoord[i],xcoord[i+1],ycoord[i+1]);

  line(xcoord[0],ycoord[0],xcoord[n-1],ycoord[n-1]);

  for(i=1;i<n;i++) 
  { minxi = (xcoord[i] < xcoord[minxi]) ? i : minxi;
    minyi = (ycoord[i] < ycoord[minyi]) ? i : minyi;
    maxxi = (xcoord[i] > xcoord[maxxi]) ? i : maxxi;
    maxyi = (ycoord[i] > ycoord[maxyi]) ? i : maxyi;
   }

  m1 =  (minxi == 0)   ?  n-1 : minxi-1;
  m2 =  (minxi == n-1) ?  0   : minxi+1;

  fill((xcoord[m1] + xcoord[m2] + xcoord[minxi])/3,
       (ycoord[m1] + ycoord[m2] + ycoord[minxi])/3 );

  MODE  = save_mode;
  COLOR = save_color;
  LINEWIDTH = save_lw;
  VIDEO_START = video_start;

  minx = xcoord[minxi]/8;
  maxx = xcoord[maxxi]/8;
  miny = ycoord[minyi];
  maxy = ycoord[maxyi];


  start1 = screen_buf+80*miny+minx;
  start2 = VIDEO_START+80*miny+minx;

  if (MODE==0)
     if (COLOR==0)
        for(j=miny; j<=maxy; j++) 
        { stop = start2+maxx-minx+1;
          for(q = start1,p=start2; p!=stop; p++,q++) *p &= *q;
          start1 += 80;
          start2 += 80;
         }
     else
        for(j=miny; j<=maxy; j++) 
        { stop = start2+maxx-minx+1;
          for(q = start1,p=start2; p!=stop; p++,q++) *p |= ~(*q);
          start1 += 80;
          start2 += 80;
         }
  else
     if (COLOR==0)
        for(j=miny; j<=maxy; j++) 
        { stop = start2+maxx-minx+1;
          for(q = start1,p=start2; p!=stop; p++,q++) *p ^= ~(*q);
          start1 += 80;
          start2 += 80;
         }
}


void put_text(int x, int y, char *text, int mode)
{
  /* mode = 0 : transparent
     mode = 1 : opaque
   */
  register unsigned char *fp;
  register int i, byte;

  int bgcol = 1-COLOR;

  while (*text)
  { fp = FONT + 16 * (*text&127);
    for (i=0; i<16; i++)
    { byte = *fp++;
      if (byte & 128) put_pixel(x,   y+i, COLOR);
      else if (mode)  put_pixel(x,   y+i, bgcol);
      if (byte & 64)  put_pixel(x+1, y+i, COLOR);
      else if (mode)  put_pixel(x+1, y+i, bgcol);
      if (byte & 32)  put_pixel(x+2, y+i, COLOR);
      else if (mode)  put_pixel(x+2, y+i, bgcol);
      if (byte & 16)  put_pixel(x+3, y+i, COLOR);
      else if (mode)  put_pixel(x+3, y+i, bgcol);
      if (byte & 8)   put_pixel(x+4, y+i, COLOR);
      else if (mode)  put_pixel(x+4, y+i, bgcol);
      if (byte & 4)   put_pixel(x+5, y+i, COLOR);
      else if (mode)  put_pixel(x+5, y+i, bgcol);
      if (byte & 2)   put_pixel(x+6, y+i, COLOR);
      else if (mode)  put_pixel(x+6, y+i, bgcol);
      if (byte & 1)   put_pixel(x+7, y+i, COLOR);
      else if (mode)  put_pixel(x+7, y+i, bgcol);
    }
    text++;
    x += 8;
  }
}


void*  save_box(int left, int top, int right, int bottom) 
{ int i,j;
  VIDEO_PTR start = VIDEO_START + 80*top + left/8;
  register VIDEO_PTR pos;
  unsigned char* p;
  int width  = right/8-left/8 + 1;
  int height = bottom-top + 1;
  int* bitmap = (int*)malloc(4*(sizeof(int))+width*height);
  bitmap[0] = left/8;
  bitmap[1] = top;
  bitmap[2] = width;
  bitmap[3] = height;
  p = (unsigned char*)(bitmap+4);
  for(j=top; j<=bottom; j++) 
  { for(pos = start; pos!=start+width; pos++) *p++ = *pos;
    start += 80;
   }
  return (unsigned char*)bitmap;
}

void  restore_box(void *q) 
{ int i,j;
  VIDEO_PTR start;
  VIDEO_PTR stop;
  register VIDEO_PTR pos;
  int* bitmap = (int*) q;
  unsigned char* p = (unsigned char*)(bitmap+4);
  start = VIDEO_START+80*bitmap[1]+bitmap[0];
  for(j=0; j<bitmap[3]; j++) 
  { stop = start+bitmap[2];
    for(pos = start; pos!=stop; pos++) *pos = *p++;
    start += 80;
   }
}

void box(int x0, int y0, int x1, int y1)
{ int y,i;
  VIDEO_PTR start = VIDEO_START+80*y0;
  VIDEO_PTR stop;
  register VIDEO_PTR pos;
  unsigned char lbyte = 0xFF;
  unsigned char rbyte = 0xFF;
  for(i=7;i>=x0%8;i--) lbyte <<= 1;
  for(i=0;i<=x1%8;i++) rbyte >>= 1;
  if (COLOR==0)
    for(y=y0; y<=y1; y++) 
    { pos = start+x0/8;
      stop = start+x1/8;
      *pos++ &= lbyte;
      while(pos!=stop) *pos++ = 0;
      *pos &= rbyte;
      start += 80;
     }
  else
    for(y=y0; y<=y1; y++) 
    { pos = start+x0/8;
      stop = start+x1/8;
      *pos++ |= ~lbyte;
      while(pos!=stop) *pos++ = 0xFF;
      *pos |= ~rbyte;
      start += 80;
     }
}

void  rectangle(int x0, int y0, int x1, int y1)
{ int left  = x0;
  int right = x1;
  int top   = y0;
  int bottom= y1;
  
  if (x0 > x1)
  { left  = x1;
    right = x0;
   }

  if (y0 > y1)
  { top  = y1;
    bottom = y0;
   }

  line(left, top,     right,top);
  line(left, bottom,  right,bottom);
  line(left, bottom-1,left, top+1);
  line(right,bottom-1,right,top+1);
}


void circle(int x0,int y0,int r)
{ int x = 0;
  int y = r;
  int e = 3-2*y;

  put_pixel(x0,y0+r,COLOR);
  put_pixel(x0,y0-r,COLOR);
  put_pixel(x0+r,y0,COLOR);
  put_pixel(x0-r,y0,COLOR);
  
  for (x=1;x<y;)
    { put_pixel(x0+x,y0+y,COLOR);
      put_pixel(x0+x,y0-y,COLOR);
      put_pixel(x0-x,y0+y,COLOR);
      put_pixel(x0-x,y0-y,COLOR);
      put_pixel(x0+y,y0+x,COLOR);
      put_pixel(x0+y,y0-x,COLOR);
      put_pixel(x0-y,y0+x,COLOR);
      put_pixel(x0-y,y0-x,COLOR);
      x++;
      if (e>=0) { y--; e = e - 4*y; }
      e = e + 4*x + 2;
     }

   put_pixel(x0+x,y0+y,COLOR);
   put_pixel(x0+x,y0-y,COLOR);
   put_pixel(x0-x,y0+y,COLOR);
   put_pixel(x0-x,y0-y,COLOR);
}

void fill_circle(x0,y0,r)
int x0,y0;
int r;
{ int x = 1;
  int y = r;
  int e = 3-2*r;

  vline(x0,y0-y,y0+y,COLOR);

  while (x<=y)
  { vline(x0+x,y0-y,y0+y,COLOR);
    vline(x0-x,y0-y,y0+y,COLOR);

    if (x<y && e>=0) 
    { vline(x0+y,y0-x,y0+x,COLOR);
      vline(x0-y,y0-x,y0+x,COLOR);
      y--; 
      e = e - 4*y; 
     }
    x++;
    e = e + 4*x + 2;
   }
}


