/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  _all_pairs.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/



/*******************************************************************************
*                                                                              *
*  ALL PAIRS SHORTEST PATHS                                                    *
*                                                                              *
*******************************************************************************/


#include <LEDA/graph_alg.h>

void ALL_PAIRS_SHORTEST_PATHS(graph&G, const edge_array(int)& cost, 
                                             node_matrix(int)& DIST)
{ 
  // computes for every node pair (v,w) DIST(v,w) = cost of the least cost
  // path from v to w, the single source shortest paths algorithms BELLMAN_FORD
  // and DIJKSTRA are used as subroutines

  edge e;
  node v,w;

  int C = 0;
  forall_edges(e,G)  C += ((cost[e]>0) ? cost[e] : -cost[e]);

  node s = G.new_node();
  forall_nodes(v,G) G.new_edge(s,v);

  edge_array(int) cost1(G);
  node_array(int) dist1(G);

  node_array(edge)  pred(G);

  forall_edges(e,G)  
    if (source(e)==s) cost1[e] = C;
    else cost1[e] =  cost[e];

  BELLMAN_FORD(G,s,cost1,dist1,pred);

  G.del_node(s);

  forall_edges(e,G) cost1[e] = dist1[source(e)] + cost[e] - dist1[target(e)];

  forall_nodes(v,G) DIJKSTRA(G,v,cost1,DIST[v],pred);

  forall_nodes(v,G)
    forall_nodes(w,G)
      { int d = dist1[w] - dist1[v];
        DIST(v,w) += d;
       }

}



#ifndef __TURBOC__

// For double valued edge costs:

void ALL_PAIRS_SHORTEST_PATHS(graph&G, const edge_array(double)& cost, 
                                             node_matrix(double)& DIST)
{ 

  edge e;
  node v,w;
  double C = 0;

  forall_edges(e,G) 
   if (cost[e]>0) C += cost[e];
   else  C -= cost[e];

  node s = G.new_node();
  forall_nodes(v,G) G.new_edge(s,v);

  edge_array(double) cost1(G);
  node_array(double) dist1(G);

  node_array(edge)  pred(G);

  forall_edges(e,G)  
    if (source(e)==s) cost1[e] = C;
    else cost1[e] =  cost[e];

  BELLMAN_FORD(G,s,cost1,dist1,pred);

  G.del_node(s);

  forall_edges(e,G) cost1[e] = dist1[source(e)] + cost[e] - dist1[target(e)];

  forall_nodes(v,G) DIJKSTRA(G,v,cost1,DIST[v],pred);

  forall_nodes(v,G)
    forall_nodes(w,G)
      { double d = dist1[w] - dist1[v];
        DIST(v,w) += d;
       }
}



#endif
