/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  skiplist.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef LEDA_SKIPLIST_H
#define LEDA_SKIPLIST_H

#include <LEDA/basic.h>

//------------------------------------------------------------------------------
//  skip lists by William Pugh
//------------------------------------------------------------------------------

class skiplist_node
{ 
  friend class skiplist;

  GenPtr key;
  GenPtr inf;
  int    level;
  skiplist_node* forward[1];   // variable sized array of forward pointers 

 };

typedef skiplist_node* skiplist_item;


class skiplist
{  
   int level;                  // maximum level of the list 
   skiplist_node*  header;     // pointer to header
   skiplist_item STOP;         // end of list
   int randomBits;             // random bit source
   int randomsLeft;            // number of unused bit pairs in randomBits
   int count;                  // number of entries

   int  randomLevel();

virtual int int_type()          const { return 1; }
virtual int cmp(GenPtr, GenPtr) const { return 0; }
virtual void copy_key(GenPtr&)  const {}
virtual void copy_inf(GenPtr&)  const {}
virtual void clear_key(GenPtr&) const {}
virtual void clear_inf(GenPtr&) const {}

public:

 skiplist();
 skiplist(const skiplist&);
 skiplist& operator=(const skiplist&);
~skiplist();

 GenPtr key(skiplist_item p) const;
 GenPtr inf(skiplist_item p) const;

 skiplist_item insert(GenPtr key, GenPtr inf);
 skiplist_item lookup(GenPtr key) const;
 skiplist_item first_item() const;
 skiplist_item next_item(skiplist_item p) const;

 void   del(GenPtr key);
 void   change_inf(skiplist_item p, GenPtr inf);
 void   del_item(skiplist_item p);
 void   clear();

 int    size() const;

};




inline GenPtr skiplist::key(skiplist_item p) const { return p->key; }
inline GenPtr skiplist::inf(skiplist_item p) const { return p->inf; }


inline skiplist_item skiplist::first_item() const  
{ skiplist_item q = header->forward[0];
  return (q==STOP) ? 0 : q;
 }

inline skiplist_item skiplist::next_item(skiplist_item p) const 
{ skiplist_item q =  p->forward[0]; 
  return (q==STOP) ? 0 : q;
 }

inline void skiplist::change_inf(skiplist_item p, GenPtr inf) { p->inf = inf; }
inline void skiplist::del_item(skiplist_item p)               { del(p->key); }
inline int  skiplist::size() const { return count; }

#endif
