/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  prio.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/



#ifndef PRIOH
#define PRIOH

//------------------------------------------------------------------------------
// priority queues (fibonacci heaps)
//------------------------------------------------------------------------------

#include <LEDA/basic.h>

#ifndef FHEAPH
#include <LEDA/f_heap.h>
#endif

typedef f_heap_item pq_item;

#define priority_queue_body(ktype,itype)  : public f_heap \
{\
ktype name2(ktype,X1);\
itype name2(itype,X2);\
\
  int  cmp(GenPtr x, GenPtr y) const\
                        { return compare(ACCESS2(itype,x),ACCESS2(itype,y)); }\
  void print_key(GenPtr& x)   const { Print(ACCESS2(itype,x),cout); }\
  void print_inf(GenPtr& x)   const { Print(ACCESS1(ktype,x),cout); }\
  void clear_key(GenPtr& x)   const { Clear(ACCESS2(itype,x)); }\
  void clear_inf(GenPtr& x)   const { Clear(ACCESS1(ktype,x)); }\
  void copy_key(GenPtr& x)    const { x=Copy(ACCESS2(itype,x)); }\
  void copy_inf(GenPtr& x)    const { x=Copy(ACCESS1(ktype,x)); }\
\
public:\
\
  ktype key(pq_item x)      const { return ACCESS1(ktype,f_heap::inf(x)); }\
  itype inf(pq_item x)      const { return ACCESS2(itype,f_heap::key(x)); }\
  itype info(pq_item x)     const { return inf(x); }\
\
  pq_item insert(ktype k,itype i) { return f_heap::insert(Convert(i),Convert(k));}\
  void  del_min(ktype& k, itype& i)   { k = key(find_min());\
                                        i = inf(find_min());\
                                        f_heap::del_min(); }\
\
  ktype del_min()   { ktype x = key(find_min()); f_heap::del_min(); return x; }\
  ktype delete_min(){ ktype x = key(find_min()); f_heap::del_min(); return x; }\
  bool  empty()             const { return (size()==0) ? true:false; }\
  void  change_key(pq_item x, ktype k) { f_heap::change_inf(x,Convert(k)); }\
  void  decrease_inf(pq_item x,itype i){ f_heap::decrease_key(x,Convert(i)); }\
\
  _priority_queue(ktype,itype)()  {}\
  _priority_queue(ktype,itype)(const _priority_queue(ktype,itype)& Q)\
  : f_heap((f_heap&)Q)  {}\
\
  _priority_queue(ktype,itype)& operator=(const _priority_queue(ktype,itype)& Q)\
  { f_heap::operator=((f_heap&)Q); return *this; }\
\
 ~_priority_queue(ktype,itype)()  { clear(); }\
};
 

#ifdef __TEMPLATES__

#define _priority_queue(K,I) priority_queue
template<class K, class I> class priority_queue priority_queue_body(K,I)

#else

#define _priority_queue(K,I) name3(K,I,priority_queue)
#define priority_queue(K,I) name3(K,I,priority_queue)
#define priority_queuedeclare2(K,I) class priority_queue(K,I) priority_queue_body(K,I)

#endif


#define forall_pq_items(i,Q) for(i = (Q).first_item(); i; i=(Q).next_item(i))

#endif
 
