/*
 * Copyright 1993 by the University of Pennsylvania
 *
 * Permission to use, copy, and distribute for non-commercial purposes,
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * The software may be modified for your own purposes, but modified versions
 * may not be distributed.
 *
 * This software is provided "as is" without any expressed or implied warranty.
 */

/********************************************************************
                  MPEGTool Global Header file
 ********************************************************************/
#define NUM_P 2        /* priority level, fixed 2 */

#define DCT_SIZE       (8)
#define DCT_SIZE_2     (DCT_SIZE*DCT_SIZE)

#define MBSIZE 16
#define MBSIZE_2 (MBSIZE*MBSIZE)

#define ATM_BITS 352      /* 44 byte/packet x 8 bit/byte */

#define RANGE(x,a,b) (((x) < (a)) ? (a) : (((x) > (b)) ? (b) : (x)))
#define sgn(x) (((x) > 0) ? 1 : (((x) < 0) ? -1 : 0))

typedef unsigned short word;
typedef unsigned char byte;
/*****************************************************************
                   Encoder related structures
 *****************************************************************/
/*** VLC CODE structure ***/
typedef struct {
  unsigned int data;
  int length;
} CODE;

/*** Macro Block Structure ***/
typedef struct {
  short **data;  /* pointer to each macro block 
                    each MB's are represented by 
                    one dimension short array with 6*64 factors. */
  int  mv[4];   /* motion vector 1,0: forward MV's (x,y)
                                  3,2: backward MV's (x,y) */
  int  mc;      /* 0 : no mc,    1 : yes, mc */
  int  intra;    /* 0 : No intra, 1 : Intra */
  int type;     /* 0 : Intra 
                    1 : Forward Prediction
                    2 : Backward Prediction 
                    3 : Bi-Direction          */
} MB;

typedef struct {
  byte *Y;
  byte *Cr;
  byte *Cb;
  int width;
  int height;
} FRAME;

/*** interface parameter for MPEG encoder ***/
typedef struct mpeg_param_struct {
  int  N;             /* inter I frame interval */
  int  M;             /* inter I or P frane interval */
  int  quant;         /* quantization scale */
  int  Beta;          /* # of blocks for HP stream */

  int  start_frame;   /* first frame number */
  int  num_of_frame;  /* number of frame to encode */

  int  CCIR;          /* 0: RGB, 1: CCIR */
  int  height;        /* picture height(pixel) */
  int  width;         /* picture width (pixel) */

  char data_name[256];/* picture name */
  
  int  in_dev;            /* input device - 1: disk, 2: tape */
  char in_dev_name[256];  /* video data device/file name */
  char in_file_name[256];  /* video data device/file name */
  int  out_dev;           /* mpeg data device - 0: None, 1: disk, 2: tape */
  char out_dev_name[256]; /* mpeg data device/fine name */
  char out_file_name[256]; /* mpeg data device/fine name */
  int  stat_out;            /* 0: None, 1: disk, 2: tape */
  char stat_file_name[256]; /* stat data file name */
  struct mpeg_param_struct *Psave; /* storage for mpeg paramter itself */
} MPEG_param;
/*********************************************************
               Statistics related structures
 *********************************************************/
/*** interface parameter for MPEG statistics ***/
typedef struct {
  int  atm_mode;  /* 0: bit mode,  1: ATM packet mode (44 byte/packet) */ 
  int  scope;     /* 0: per frame, 1: per slice, 2: per macro block */
  int  level;     /* 0:bit/frm, 1:bit/slc, 2:bit/MB, 3:ATM/frm, 4: ATM/slc */
  int  priority;    /* 0: both, 1: HP, 2: LP, 3:HP+LP */
  int  kind_of_stat;/* 0: distribution,    1: generation record, 
                       2: autocorrelation, 3: interarrival time */
  int  start_frame; /* satrt frame # to make statistics */
  int  stat_num;    /* item # to make statistics */
  int  ps_out;      /* 0: No PS, 1: create PS grpgh */
  char stat_file_name[256]; /* stat data file name */
  char ps_file_name[256];   /* filename for PS file */
  char plot_macro_name[256];/* filename for gnuplot macro file */
  char plot_data_name[256]; /* filename for gnuplot data file */
} STAT_param;

/*** statistics data structure to store ***/
typedef struct {
     int width;
     int height;
     int frame;          /* frame number */
     int frame_mode;     /* 0: Intra, 1: Fwd pred, 3: Bi-dir-pred */
     double SNR;
     char  *block_mode;   /* coding mode of each macroblock */
     short *bit_num;      /* number of bits in each macroblock (HP)*/
     short *bit_numl;     /* number of bits in each macroblock (LP)*/
} FRAME_STAT;
/*------------------------------------------------------------------
  FRAME_STAT is used to obtaind coding and generated bit information
  in each MB's. The size of each array depends on width and height of
  orginal video data. 
 -------------------------------------------------------------------*/
/*** structure for storage of read stat data ***/
typedef struct 
{
  int    mb_num; /* # of MB's in each frame */
  int    slice_num; /* # of Slice's in each frame */
  int    num;    /* # of stat data in this structure */
  int    max, maxl, maxs;
  int    min, minl, mins;
  double avg, avgl, avgs;
  double sd,  sdl,  sds;
  double distmax, distmaxl, distmaxs;
  double ac_min,  ac_minl, ac_mins;
  char*  block_mode; /* available only MB mode */
  int*   bit_num;
  int*   bit_numl;
  int*   bit_nums;
} STAT;

int Xon;
