/*
 * Copyright 1993 by the University of Pennsylvania
 *
 * Permission to use, copy, and distribute for non-commercial purposes,
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * The software may be modified for your own purposes, but modified versions
 * may not be distributed.
 *
 * This software is provided "as is" without any expressed or implied warranty.
 */

/**********************************************************************
  Creates the MPEGTool Encoder Configulation dialog. This dialog is
  contains toggle switchs and text input labels ,which specify 
  Video Format, Input Deveice, Output Device and Record Statistics.
  'Ok' button update the MPEG_param and close dialog, while 'Cancel' 
  close window without updating window.
 ***********************************************************************/
#include <Xm/DialogS.h>
#include <Xm/PanedW.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/RowColumn.h>
#include <Xm/ToggleBG.h>
#include <Xm/PushBG.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>

#include <stdio.h>
#include <malloc.h>

#include "global.h"

Widget GetTopShell();
Widget CreateLabeledTextForm3();
Widget CreateLabeledTextRC();
/**********************************************************
  callback functions
 **********************************************************/
void                  /* restore old parameter */
  cancel_update_parameter(widget, P)
Widget widget;
MPEG_param *P;
{ 
  if((P->Psave  == NULL)||(P == NULL)) { /* some error */
    fprintf(stderr,"No data has been stored\n");
    return;
  }
  *P = *P->Psave; /* structure parameter passing */
  free(P->Psave);
  return;  
}

int
  store_mpeg_parameter(P)
MPEG_param *P;
{
  if(P == NULL) return -1;
  P->Psave = (MPEG_param *)malloc(sizeof(MPEG_param));
  *P->Psave = *P;
  return 0;
}
/**********************************************************
  Configuration menu window
***********************************************************/
void
  configure_pushed(w,P)
Widget w;
MPEG_param *P;
{
  static Widget dialog;
  Widget pane, form, radio_box, 
  toggle1, toggle2, toggle3,
  label, textform, textform2, textrc, textrc2, frame, pb;

  extern void toggle_set(); 
  extern void quit_dialog();
  extern void SetUnmanage();
  extern void SetManage();
  extern void SetUnsensitive();
  extern void SetSensitive();
/*---------------- check duplication ----------------------------*/
  XtSetSensitive(XtParent(w),False); 
                 /* make mpeg window  unsensitive */
  store_mpeg_parameter(P);
/*---------------- make tempral parameter ----------------------*/
  dialog = XtVaCreatePopupShell("dialog",
             xmDialogShellWidgetClass, GetTopShell(w),
             XmNtitle, "MPEGTool: Encoder Configuration",
             XmNdeleteResponse, XmDESTROY,
             XmNx,    WidthOfScreen(XtScreen(XtParent(w))) / 4 + 20,
             XmNy,    HeightOfScreen(XtScreen(XtParent(w))) / 4 + 20,
             XmNwidth,  340,
             XmNheight, 425,
             XmNmaxWidth,  340,
             XmNminWidth,  340,
             XmNmaxHeight, 425,
             XmNminHeight, 425,
             NULL);
/*--------------- Creating the pane window (Base) ----------------*/
  pane = XtVaCreateWidget("pane", 
           xmPanedWindowWidgetClass,   dialog,
           XmNmarginWidth, 15,
           XmNsashWidth,    1,
           XmNsashHeight,   1,
           NULL);
/*-----------------------------------------------------------------------*/
/*------------------- Creating Video Format section ---------------------*/
/*-----------------------------------------------------------------------*/
  form = XtVaCreateWidget("form",
           xmFormWidgetClass, pane,
           XmNfractionBase,   2,
           XmNpaneMinimum,    100,
           XmNpaneMaximum,    100,
           NULL);
/*------- toggle for input device selection ------------------------*/
  label = XtVaCreateManagedWidget("Video Format:  ",
            xmLabelGadgetClass, form,
            XmNtopAttachment,   XmATTACH_FORM,
            XmNtopOffset,       15,
            NULL);
  frame = XtVaCreateWidget("frame",
            xmFrameWidgetClass, form,
            XmNleftAttachment, XmATTACH_WIDGET,
            XmNleftWidget,     label,
            XmNtopAttachment,  XmATTACH_FORM,
            XmNtopOffset,      7,
            XmNtopPosition,    1,
            NULL);
  radio_box = XmCreateRadioBox(frame, "radio_box", 
                NULL,0);
  toggle1 = XtVaCreateManagedWidget("RGB ",
              xmToggleButtonGadgetClass, radio_box,
              XmNset, (P->CCIR == 0),
              XmNuserData,  &P->CCIR,
              NULL);
  XtAddCallback(toggle1,XmNvalueChangedCallback,toggle_set,0);
  toggle2 = XtVaCreateManagedWidget("CCIR ",
              xmToggleButtonGadgetClass, radio_box,
              XmNset, (P->CCIR == 1),
              XmNuserData,  &P->CCIR,
              NULL);
  XtAddCallback(toggle2,XmNvalueChangedCallback,toggle_set,1);
  XtVaSetValues(radio_box,
    XmNnumColumns, 2,
    NULL);
  XtManageChild(radio_box);
  XtManageChild(frame);
/*--------------- Creating the width, height entry box ------------------*/
  textrc = CreateLabeledTextRC(form,"Width: ",&(P->width));
  XtVaSetValues(textrc,
    XmNbottomAttachment, XmATTACH_FORM,
    XmNbottomOffset    , 10,
    NULL);
  XtManageChild(textrc);

  textrc2 = CreateLabeledTextRC(form,"Height: ",&(P->height));
    XtVaSetValues(textrc2,
    XmNbottomAttachment, XmATTACH_FORM,
    XmNbottomOffset,     10,
    XmNleftAttachment,   XmATTACH_POSITION,
    XmNleftPosition,     1,
    NULL);

  XtAddCallback(toggle1,XmNvalueChangedCallback,SetSensitive,textrc);
  XtAddCallback(toggle1,XmNvalueChangedCallback,SetSensitive,textrc2);
  XtAddCallback(toggle2,XmNvalueChangedCallback,SetUnsensitive,textrc);
  XtAddCallback(toggle2,XmNvalueChangedCallback,SetUnsensitive,textrc2);

  if(P->CCIR==1) {
    XtSetSensitive(textrc,False);
    XtSetSensitive(textrc2,False);
  }
  XtManageChild(textrc2);
  XtManageChild(form);
/*-----------------------------------------------------------------------*/
/*------------------- Creating Input Device section ---------------------*/
/*-----------------------------------------------------------------------*/
  form = XtVaCreateWidget("form",
           xmFormWidgetClass, pane,
           XmNpaneMinimum,    100,
           XmNpaneMaximum,    100,
           NULL);
/*------- toggle for input device selection ------------------------*/
  label = XtVaCreateManagedWidget("Input Device:  ",
            xmLabelGadgetClass, form,
            XmNtopAttachment,   XmATTACH_FORM,
            XmNtopOffset,       15,
            NULL);
  frame = XtVaCreateWidget("frame",
            xmFrameWidgetClass, form,
            XmNleftAttachment, XmATTACH_WIDGET,
            XmNleftWidget,     label,
            XmNtopAttachment,  XmATTACH_FORM,
            XmNtopOffset,      7,
            XmNtopPosition,    1,
            NULL);
  radio_box = XmCreateRadioBox(frame, "radio_box", 
                NULL,0);
  toggle1 = XtVaCreateManagedWidget("Disk",
              xmToggleButtonGadgetClass, radio_box,
              XmNset, (P->in_dev == 1),
              XmNuserData,  &P->in_dev,
              NULL);
  XtAddCallback(toggle1,XmNvalueChangedCallback,toggle_set,1);
  toggle2 = XtVaCreateManagedWidget("Tape ",
              xmToggleButtonGadgetClass, radio_box,
              XmNset, (P->in_dev == 2),
              XmNuserData,  &P->in_dev,
              NULL);
  XtAddCallback(toggle2,XmNvalueChangedCallback,toggle_set,2);
  XtVaSetValues(radio_box,
    XmNnumColumns, 2,
    NULL);
  XtManageChild(radio_box);
  XtManageChild(frame);
/*--------------- Creating the filename text entry box ------------------*/
  textform = CreateLabeledTextForm3(form,"File Name  : ",P->in_file_name);
  XtVaSetValues(textform,
    XmNbottomAttachment, XmATTACH_FORM,
    XmNbottomOffset    , 10,
    NULL);
  textform2 = CreateLabeledTextForm3(form,"Device Name: ",P->in_dev_name);
  XtVaSetValues(textform2,
    XmNbottomAttachment, XmATTACH_FORM,
    XmNbottomOffset    , 10,
    NULL);

/*pb = XtVaCreateManagedWidget("BROWSE",
         xmPushButtonGadgetClass, form,
         XmNbottomAttachment,    XmATTACH_FORM,
         XmNbottomOffset,        10,
         XmNrightAttachment,     XmATTACH_FORM,
         XmNrightOffset,         5,
         XmNleftAttachment,      XmATTACH_FORM,
         XmNleftWidget,          textform2,
         XmNleftOffset,          5,
         XmNshowAsDefault,       False,
         XmNdefaultButtonShadowThickness, 1,
         NULL);*/

  XtAddCallback(toggle1,XmNvalueChangedCallback,SetUnmanage,textform2);
  XtAddCallback(toggle1,XmNvalueChangedCallback,SetManage,textform);
  XtAddCallback(toggle2,XmNvalueChangedCallback,SetUnmanage,textform);
  XtAddCallback(toggle2,XmNvalueChangedCallback,SetManage,textform2);

  if(P->in_dev == 1)   XtManageChild(textform);
  if(P->in_dev == 2)   XtManageChild(textform2);

  XtManageChild(form);
/*-----------------------------------------------------------------------*/
/*------------------- Creating Output Device section --------------------*/
/*-----------------------------------------------------------------------*/
  form = XtVaCreateWidget("form",
           xmFormWidgetClass, pane,
           XmNpaneMinimum,    100,
           XmNpaneMaximum,    100,
           NULL);
/*------- toggle for output device selection ------------------------*/
  label = XtVaCreateManagedWidget("Output Device: ",
            xmLabelGadgetClass, form,
            XmNtopAttachment,   XmATTACH_FORM,
            XmNtopOffset,       15,
            NULL);
  frame = XtVaCreateWidget("frame",
            xmFrameWidgetClass, form,
            XmNleftAttachment, XmATTACH_WIDGET,
            XmNleftWidget,     label,
            XmNtopAttachment,  XmATTACH_FORM,
            XmNtopOffset,      7,
            XmNtopPosition,    1,
            NULL);
  radio_box = XmCreateRadioBox(frame, "radio_box", 
                NULL,0);
  toggle1 = XtVaCreateManagedWidget("Disk",
              xmToggleButtonGadgetClass, radio_box,
              XmNset, (P->out_dev == 1),
              XmNuserData,  &P->out_dev,
              NULL);
  XtAddCallback(toggle1,XmNvalueChangedCallback,toggle_set,1);
  toggle2 = XtVaCreateManagedWidget("Tape",
              xmToggleButtonGadgetClass, radio_box,
              XmNset, (P->out_dev == 2),
              XmNuserData,  &P->out_dev,
              NULL);
  XtAddCallback(toggle2,XmNvalueChangedCallback,toggle_set,2);
  toggle3 = XtVaCreateManagedWidget("None",
              xmToggleButtonGadgetClass, radio_box,
              XmNset, (P->out_dev == 0),
              XmNuserData,  &P->out_dev,
              NULL);
  XtAddCallback(toggle3,XmNvalueChangedCallback,toggle_set,0);
  XtVaSetValues(radio_box,
    XmNnumColumns, 3,
    NULL);
  XtManageChild(radio_box);
  XtManageChild(frame);
/*--------------- Creating the filename text entry box ------------------*/
  textform  = CreateLabeledTextForm3(form,"File Name  : ",P->out_file_name);
  XtVaSetValues(textform,
    XmNbottomAttachment, XmATTACH_FORM,
    XmNbottomOffset    , 10,
    NULL);
  textform2 = CreateLabeledTextForm3(form,"Device Name: ",P->out_dev_name);
  XtVaSetValues(textform2,
    XmNbottomAttachment, XmATTACH_FORM,
    XmNbottomOffset    , 10,
    NULL);
/*------ change sensitivity by the device selected ------*/
  XtAddCallback(toggle1,XmNvalueChangedCallback,SetUnmanage,textform2);
  XtAddCallback(toggle1,XmNvalueChangedCallback,SetManage,textform);
  XtAddCallback(toggle1,XmNvalueChangedCallback,SetSensitive,textform);

  XtAddCallback(toggle2,XmNvalueChangedCallback,SetUnmanage,textform);
  XtAddCallback(toggle2,XmNvalueChangedCallback,SetManage,textform2);
  XtAddCallback(toggle2,XmNvalueChangedCallback,SetSensitive,textform2);

  XtAddCallback(toggle3,XmNvalueChangedCallback,SetUnsensitive,textform);
  XtAddCallback(toggle3,XmNvalueChangedCallback,SetUnsensitive,textform2);

  switch(P->out_dev) {
    case 1: XtManageChild(textform); break;
    case 2: XtManageChild(textform2); break;
    case 0: XtManageChild(textform);
            XtSetSensitive(textform, False); break;
  }
  XtManageChild(form);
/*-----------------------------------------------------------------------*/
/*---------------- Statistics data  Output section ----------------------*/
/*-----------------------------------------------------------------------*/
  form = XtVaCreateWidget("form",
           xmFormWidgetClass, pane,
           XmNpaneMinimum,    50,
           XmNpaneMaximum,    50,
           NULL);
  label = XtVaCreateManagedWidget("Record Statistics:",
            xmLabelGadgetClass, form,
            XmNtopAttachment,   XmATTACH_FORM,
            XmNtopOffset,       15,
            NULL);
/*------- toggle for stat data storage option ------------------------*/
  frame = XtVaCreateWidget("frame",
            xmFrameWidgetClass, form,
            XmNleftAttachment,  XmATTACH_WIDGET,
            XmNleftWidget,      label,
            XmNtopAttachment,   XmATTACH_FORM,
            XmNtopOffset,       7,
            XmNtopPosition,     1,
            XmNmarginHeight,    1,
            XmNmarginWidth,     1,
            NULL);
  radio_box = XmCreateRadioBox(frame, "radio_box", 
                NULL,0);
  toggle1 = XtVaCreateManagedWidget("Yes  ",
              xmToggleButtonGadgetClass, radio_box,
              XmNset, (P->stat_out == 1),
              XmNuserData,  &P->stat_out,
              NULL);
  XtAddCallback(toggle1,XmNvalueChangedCallback,toggle_set,1);
  toggle2 = XtVaCreateManagedWidget("No   ",
              xmToggleButtonGadgetClass, radio_box,
              XmNset, (P->stat_out == 0),
              XmNuserData,  &P->stat_out,
              NULL);
  XtAddCallback(toggle2,XmNvalueChangedCallback,toggle_set,0);
  XtVaSetValues(radio_box,
    XmNnumColumns, 2,
    NULL);
  XtManageChild(radio_box);
  XtManageChild(frame);
  XtManageChild(form);
/*-----------------------------------------------------------------------*/
/*------------------------------ Action area ----------------------------*/
/*-----------------------------------------------------------------------*/
  form = XtVaCreateWidget("form",
           xmFormWidgetClass, pane,
           XmNfractionBase,   7,
           XmNpaneMinimum,    40,
           XmNpaneMaximum,    40,
           NULL);
/*---------------  Creating the pushbutton "Ok" that starts encoding --------*/
  pb = XtVaCreateManagedWidget("Ok",
         xmPushButtonGadgetClass, form,
         XmNtopAttachment,       XmATTACH_FORM,
         XmNbottomAttachment,    XmATTACH_FORM,
         XmNleftAttachment,      XmATTACH_POSITION,
         XmNleftPosition,        1,
         XmNrightAttachment,     XmATTACH_POSITION,
         XmNrightPosition,       3,
         XmNshowAsDefault,       True,
         XmNdefaultButtonShadowThickness, 1,
         NULL);
  XtAddCallback(pb, XmNactivateCallback, SetSensitive, XtParent(w));
  XtAddCallback(pb, XmNactivateCallback, quit_dialog,  dialog);
/*-------------- Creating the pushbutton "Cancel" that pops up new window ---*/
  pb = XtVaCreateManagedWidget("Cancel",
         xmPushButtonGadgetClass, form,
         XmNtopAttachment,       XmATTACH_FORM,
         XmNbottomAttachment,    XmATTACH_FORM,
         XmNleftAttachment,      XmATTACH_POSITION,
         XmNleftPosition,        4,
         XmNrightAttachment,     XmATTACH_POSITION,
         XmNrightPosition,       6,
         XmNshowAsDefault,       False,
         XmNdefaultButtonShadowThickness, 1,
         NULL);
  XtAddCallback(pb, XmNactivateCallback, cancel_update_parameter, P);
  XtAddCallback(pb, XmNactivateCallback, SetSensitive, XtParent(w));
  XtAddCallback(pb, XmNactivateCallback, quit_dialog,  dialog);
  XtManageChild(form);

  XtManageChild(pane);

  XtPopup(dialog, XtGrabNone);
}
