 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vhough.h
 >>>>            Author: Patrick Arnoul, Jean-Pierre Guerin, Jean-Francois Larue
 >>>> Date Last Updated: Thu Mar 26 10:42:31 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vhough_h_
#define _vhough_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vhough Argument Structure
*
****************************************************************/

typedef struct _vhough  {

/*
 *  input image to be transformed (Required infile)
 */
char	*i_file;	/* input image to be transformed FILENAME */
int	 i_flag;	/* input image to be transformed FLAG */

/*
 *  resulting output image (Required outfile)
 */
char	*o_file;	/* resulting output image FILENAME */
int	 o_flag;	/* resulting output image FLAG */

/*
 *  Selects one (Direct or Forward) or Inverse Transform (Optional logical)
 */
int	 d_logic;	/* Selects one (Direct or Forward) or Inverse Transform LOGIC */
int	 d_flag;  	/* Selects one (Direct or Forward) or Inverse Transform FLAG */

/*
 *  draw 4 lines surrounding the inverse transformed image (Optional logical)
 */
int	 b_logic;	/* draw 4 lines surrounding the inverse transformed image LOGIC */
int	 b_flag;  	/* draw 4 lines surrounding the inverse transformed image FLAG */

/*
 *  selects one (Normalization) or zero (Optional logical)
 */
int	 n_logic;	/* selects one (Normalization) or zero LOGIC */
int	 n_flag;  	/* selects one (Normalization) or zero FLAG */

}  vhough_struct;

vhough_struct *vhough;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image) \
    image = readimage(vhough->i_file); \
    if(image == NULL){ \
        (void) fprintf(stderr,"vhough: Image could not be read...\n"); \
        exit(1); \
    }

#define CHECKINPUT(program, image) \
        (void) proper_num_images(program,image,1,TRUE); \
        (void) proper_num_bands(program,image,1,TRUE)

#define WRITEOUTPUT(image) \
    writeimage(vhough->o_file, image)

/* for direct H. input xy image: */
#define INIT_IMA_TYP     unsigned char
#define INIT_VVF_TYP     VFF_TYP_1_BYTE

/* for direct H. output and inverse H. input az image: */
#define IMA_TYP          unsigned long
#define VVF_HOUGH_TYP    VFF_TYP_4_BYTE

/* for inverse H. output xy image: */
#define IMA_INV_TYP      unsigned long
#define OUT_INV_VVF_TYP  VFF_TYP_4_BYTE

/* -include_macros_end */

#endif
