/*
 * NAME
 *     Room.h -- Room definitions
 *
 * AUTHOR
 *     Ken MacLeod
 *
 * SCCS
 *     @(#) Room.h  1.2 06 Jun 1991 18:12:00 
 */

typedef struct {
	char *name;			/* From '.newsrc' or 'active' */
	char *lastCharOfName;		/* For quicker searches */
	char *articlesRead;		/* ascii bitmap of articles read, "1-50,60-70,80,90-1000", from '.newsrc' */
	char *originalArticlesRead;	/* original bitmap, for ungoto */
	char *fileDir;			/* file directory if there is one, from 'fileDirs' */
	char *description;		/* description, if there is one, from 'newsgroups' */
	short floor;			/* floor this room is on */
	char type;				/* Index into type table */
	unsigned int forgotten:1;		/* room is forgotten, from '.newsrc' or 'F' in 'active' */
	unsigned int readOnly:1;		/* Read only room, from 'R' in 'active' */
	unsigned int private:1;			/* Private room, from 'P' in 'active' */
	unsigned int inviteOnly:1;		/* By invite only, from 'I' in 'active' */
	unsigned int anonymous:1;		/* Anonymous room, from 'A' in 'active' */
	unsigned int moderated:1;		/* Room is moderated, from 'M' in 'active' */
	unsigned int localOnly:1;		/* Local posting only, from 'L' in 'active' */
	unsigned int displayNumber:1;		/* Display article number, from 'D' in 'active' */
	unsigned int displaySubject:1;		/* Display/require message subject, from 'S' in 'active' */
	unsigned int invited:1;			/* Has been invited to an invite only room, from 'Invited: ' in '.unidelrc' */
	unsigned int newArticles:1;		/* room has new articles, the union of !articlesRead and lowest-highest */
	unsigned int lowest, highest;	/* lowest and highest articles in the room, from 'active' */
} Room;

#define _deadType 0
#define _newsType 1
#define _mailType 2
#define _numRoomTypes 3

typedef struct {
	char *name;			/* from 'Floors' */
	short nameLength;		/* length of name, used for strncmp when comparing room names */
	char *description;		/* Verbose floor name, from 'Floors' */
	unsigned int forgotten:1;		/* Floor is forgotten, set from 'F' in 'Floors' cleared by 'KnownFloors:' in '.unidelrc' */
	unsigned int readOnly:1;		/* Read only floor, from 'R' in 'Floors' */
	unsigned int allowNewRooms:1;		/* New rooms allowed to be created in this floor, from 'N' in 'Floors' */
	unsigned int inviteOnly:1;		/* By invite only, from 'I' in 'Floors' */
	unsigned int anonymous:1;		/* Anonymous floor, from 'A' in 'Floors' */
	unsigned int moderated:1;		/* Moderated floor, from 'M' in 'Floors' */
	unsigned int localOnly:1;		/* Local posting only, from 'L' in 'Floors' */
	unsigned int private:1;			/* Private room, from 'P' in 'Floors' */
	unsigned int displayNumber:1;		/* Display article number, from 'D' in 'Floors' */
	unsigned int displaySubject:1;		/* Display/require message subject, from 'S' in 'Floors' */
	unsigned int invited:1;			/* Has been invited to an invite only floor, from 'Invited: ' in '.unidelrc' */
} Floor;

char *RoomPath (), *RoomNameString ();

extern Room *rooms;
extern Floor *floors;

/* Room by room information */
extern unsigned int currentFloor;
extern unsigned int currentRoom, previousRoom;
