/*
 * NAME
 *     Read.c -- General reading commands and functions
 *
 * AUTHOR
 *     Ken MacLeod
 */

#ifndef lint
static char sccsId [] = "@(#) Read.c  1.3 4/9/91 08:03:19\n\t";
#endif

#include <sys/types.h>
#include <stdio.h>
#include <fgetmfs.h>
#include <time.h>
#include <string.h>
#include <ctype.h>
#include "ErrorLog.h"
#include "defs.h"
#include "Unidel.h"
#include "Room.h"
#include "User.h"
#include "Message.h"
#include "File.h"

extern char *hdr[];
extern int linesLeft;

ReadStatus ()

{
	time_t theTime, time ();
	long totalArticles, diff;
	int totalRooms, totalFloors;
	struct tm *tm;

	(void) printf ("  This is %s, site name %s\n", _organization, _siteName);
	(void) time (&theTime);
	tm = localtime (&theTime);
	(void) printf ("  %2d%s%2.2d %d:%2.2d %cm\n", tm -> tm_year,
	  months[tm -> tm_mon], tm -> tm_mday, tm -> tm_hour % 12, tm -> tm_min,
	  (tm -> tm_hour / 12) == 0 ? 'a' : 'p');
	(void) printf ("  Version %s.\n", _version);
	(void) printf ("  Logged in as %s (%s)\n", logname, logname);
	if (floorMode)
		(void) printf ("  Floor mode.\n");
	(void) printf ("  Your terminal type is %s.\n", terminalType);
	(void) printf ("  Your transfer protocol is %s.\n", transferProtocol == NULL ? "None" : transferProtocol);
	(void) printf ("  Your editor is %s.\n", editorName == NULL ? "None" : editorName);
	totalArticles = 0;
	for (totalRooms = 0; rooms[totalRooms].name != NULL; totalRooms ++)
		if ((diff = rooms[totalRooms].highest - rooms[totalRooms].lowest) != -1)
			totalArticles += diff;
	for (totalFloors = 0; floors[totalFloors].name != NULL; totalFloors ++);
	(void) printf ("  %ld messages in %d rooms in %d floors.\n", totalArticles,
	  totalRooms, totalFloors);
	(void) printf ("  %dmeg message and file space.\n", _siteSize);
}

ReadMessageByNumber (firstDigit)

long firstDigit;

{
	char articleString[_bufSize], fileName[_bufSize];
	int article;

	articleString[0] = '0' + (char) firstDigit;
	GetString (&articleString[1], _normal);
	article = atoi (articleString) - 1;
	if (article < 0 || article > numArticles) {
		(void) printf ("%d isn't a valid article number.\n", article + 1);
		return;
	}
	(void) sprintf (fileName, "%s/%d", RoomPath (rooms[currentRoom].name), articles[article].number);
	linesLeft = lines;
	(void) PrintMessage (_readMoreDefault, fileName, article, _false);
}

ReadMessageByMessageID ()

{
	char messageID[_bufSize], *ptr;

	messageID[0] = '<';
	GetString (&messageID[1], _normal);
	ptr = strchr (messageID, '>');
	if (ptr == NULL)
	  (void)strcat (messageID, ">");
	if (messageID[0]) {
		if (!PrintMessageByMessageID (messageID))
			(void) printf ("Article %s not found.\n", messageID);
	}
}

PrintMessageByMessageID (messageID)
/* MessageID must include '<' and '>' */

char *messageID;

{
	FILE *historyFile;
	char historyFileName[_bufSize], historyLine[_bufSize * 4], *ptr1, *ptr2, fileName[_bufSize];
	long articleNum, atol ();
	int article, room;

	(void) sprintf (historyFileName, "%s/history", _newsLibDir);
	historyFile = fopen (historyFileName, "r");
	if (historyFile == NULL) {
		ErrorLog ("PrintMessageByMessageID:001", _warning, "Unable to open news history file.");
		return (_false);
	}
	while (fgets (historyLine, _bufSize * 4, historyFile) != NULL) {
		ptr1 = strchr (historyLine, '\t');	/* ptr1 --> tab before date */
		if (ptr1 == NULL)
			continue;	/* If no '\t' then must be a screwy line, try another */
		*ptr1 = '\0';				/* terminate the messageID */
		ptr1 = strchr (ptr1 + 1, '\t');		/* ptr1 --> tab before newsgroup/article */
		if (ptr1 == NULL)	/* We should have zipped past the date, if not, then another screwy line */
			continue;
		if (ptr1[1] == '\n')
			continue;	/* this article has expired, don't even try to test it */
		ptr2 = ptr1 + 1;			/* ptr2 --> newsgroup/article */
		ptr1 = strchr (ptr2, ' ');		/* ptr1 --> space before next newsgroup/article */
		if (ptr1 == NULL)
			ptr1 = strchr (ptr2, '\n');	/* if not found, ptr1 --> new-line */
		if (ptr1 == NULL)
			continue;			/* if still not found, then it's another screwy line */
		*ptr1 = '\0';				/* terminate the first newsgroup/article */
		if (strcmp (messageID, historyLine) == 0) {	/* Is this the article we're looking for? */
			ptr1 = strrchr (ptr2, '/');	/* ptr1 --> '/' in newsgroup/article */
			if (ptr1 == NULL)		/* if no '/' then screwy line */
				return (_false);	/*   but since we found the article, we'll exit */
			articleNum = atol (ptr1 + 1);	/* get article number */
			*ptr1 = '\0';			/* terminate newsgroup name */
			room = FindRoom (_findExact, ptr2);
			Goto (room);
			for (article = 0; article < numArticles && articles[article].number != articleNum; article ++)
				;
			if (article < numArticles) {
				(void) sprintf (fileName, "%s/%d", RoomPath (rooms[currentRoom].name), articles[article].number);
				linesLeft = lines;
				if (PrintMessage (_readMoreDefault, fileName, article, _false) == -1)
					return (_false);
				else
					return (_true);
			}
			return (_false);
		}
	}
	return (_false);
}

ReadMessages (flags)

long flags;

{
	char fileName[_bufSize], dumpFileName[_bufSize];
	int article, increment, start, end, back;

	if (numArticles == 0)
		return;

	if (flags & _readForward) {
		start = 0;
		end = numArticles;
		increment = 1;
	} else {
		start = numArticles - 1;
		end = -1;
		increment = -1;
	}

	if (flags & _transferProtocol) {
		(void) sprintf (dumpFileName, "%s/tempFile", flTempDir);
		dumpFile = fopen (dumpFileName, "w");
		(void) printf ("Preparing download file...\n");
	}

	back = _false;		/* back == 2 to exit */
	linesLeft = lines;
	for (article = start; back != 2 && article != end; article += increment) {
		if (!((flags & _readAll) || back || ((flags & _readNew) && !articles[article].read) ||
		  (!(flags & _readNew) && articles[article].read))) {
			continue;
		}
		(void) sprintf (fileName, "%s/%d", RoomPath (rooms[currentRoom].name), articles[article].number);
		back = PrintMessage (flags, fileName, article, back);
		if (back) {
			article -= increment * 2;
		}
		if (article < -1)
			article = -1;
		else if (article > numArticles)
			article = numArticles;
	}
	
	if (flags & _transferProtocol) {
	  (void)fclose (dumpFile);
		dumpFile = stdout;
		(void) printf ("Download file completed.\n");
		ReadFile (dumpFileName);
		if (unlink (dumpFileName) == -1) {
			(void) sprintf (errorString, "Unlinking temporary download file '%s'.\n", dumpFileName);
			ErrorLog ("ReadMessage", _error, errorString);
		}
	}
}
