/*
 * NAME
 *     Init.c -- Load and initialization functions
 *
 * AUTHOR
 *     Ken MacLeod
 */

#ifndef lint
static char sccsId [] = "@(#) Init.c  1.9 16 Nov 1991 19:39:08\n\t";
#endif

#include <sys/types.h>
#include <fgetmfs.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <ctype.h>
#include <search.h>
#include <getenvs.h>
#include "ErrorLog.h"
#include "defs.h"
#include "Unidel.h"
#include "Message.h"
#include "User.h"
#include "Room.h"
#include "File.h"

ENTRY *hsearch ();

extern Envs envs[];		/* Environment table */

char *userFieldNames[] = {
	"Mail-Directory: ",
	"Terminal: ",
	"Editor: ",
	"More: ",
	"FloorMode: ",
	"ExpertMode: ",
	"Columns: ",
	"Lines: ",
	"Transfer: ",
	"KnownFloors: ",
	"Pager: ",
	NULL,
};
char *user[sizeof (userFieldNames)/sizeof (char *)-1];

char *controlFieldNames[] = {
	"Invited: ",
	NULL,
};
char *control[sizeof (userFieldNames)/sizeof (char *)-1];

static char *options = NULL;	/* the options line from .newsrc, will be saved and re-written out if needed */

int secure;	/* true if we started as r* */

main (argc, argv)

int argc;
char *argv[];

{
  (void)hcreate (_maxRooms);
	(void)free (malloc (32000));	/* Keep from calling brk so many times */
	setbuf (stdout, (char *) NULL);
	Initialize (argc, argv);
	(void) printf (".");
	ReadFloorsFile ();		/* '_libDir/Floors', floor descriptions */
	(void) printf (".");
	ReadNewsFile ();		/* '$HOME/.newsrc' Articles that user has already read, fills 'room' array in user's preferred order */
	(void) printf (".");
	ReadActiveFile ();		/* '_newsLibDir/active' Articles that are available, adds any rooms not in '.newsrc' */
	(void) printf (".");
	ReadUserFile ();		/* '$HOME/.unidelrc' */
	(void) printf (".");
	ReadUserControlFile ();		/* '_libDir/Admin/$LOGNAME' */
	(void) printf (".");
	ReadFileDirectoryFile ();	/* '_libDir/fileDir' */
	(void) printf (".");
	ReadNewsgroupsFile ();		/* '_newsLibDir/newsgroups' */
	(void) printf (".");

	ScanNewArticles ();		/* Find out which newsgroups have new articles */
	(void) printf ("\n");

	SetupTerminal (_true);
	UserLoop ();
	SetupTerminal (_false);

	WriteNewsFile ();
	WriteUserFile ();
	UnInitialize ();

	return (0);
}

/*ARGSUSED*/
Initialize (argc, argv)

int argc;
char *argv[];

{
	char commandString[_bufSize], *lineBuf, *ptr, *realLine,
	*ttyname (), *tmpnam ();
	FILE			*ttyFile;

	/* Program variables */
	debug = 9;
	programName = argv[0];
	
	/* modes */
	local = _false;
	dumpFile = stdout;
	secure = (programName [0] == 'r') || ((programName[0] == '-') && (programName[1] == 'r'));

	if ((realLine = ttyname (fileno (stdin))) != NULL) {
		if ((ptr = strrchr (realLine, '/')) != NULL)
			realLine = ptr + 1;
		if ((ttyFile = fopen (_local, "r")) != NULL) {
			while ((lineBuf = fgetms (ttyFile)) != NULL) {
				if (IsIn (realLine, lineBuf) && IsIn (_isLocal, lineBuf)) {
					local = _true;
					(void)free ((malloc_t)lineBuf);
					break;
				}
				(void)free ((malloc_t)lineBuf);
			}
			(void)fclose (ttyFile);
		}
	}

	if (getenvs (envs) == -1)
	  ErrorLog ("main:003", _fatalError, "Unable to allocate memory for environment.");
	
	guest = (strcmp (logname, _guestName) == 0) ? _true : _false;

	if ((rooms = (Room *) malloc ((size_t) _maxRooms * sizeof (Room))) == NULL)
		ErrorLog ("main:003", _fatalError, "Unable to allocate memory for rooms.");

	(void) memset ((char *) rooms, 0, _maxRooms * sizeof (Room));

	if ((floors = (Floor *) malloc ((size_t) _maxFloors * sizeof (Floor))) == NULL)
		ErrorLog ("main:003", _fatalError, "Unable to allocate memory for floors.");

	(void) memset ((char *) floors, 0, _maxFloors * sizeof (Floor));

	(void) sprintf (commandString, "%s/unidelin", _libDir);
	if (!access (commandString, 0))
	  (void)system (commandString);
	(void) sprintf (commandString, "%s/.unidelin", homeDir);
	if (!access (commandString, 0))
	  (void)system (commandString);

	flTempDir = tmpnam ((char *) NULL);
	flTempDir = KeepString (flTempDir, strlen (flTempDir));
	if (mkdir (flTempDir, 0755) == -1) {
		(void) sprintf (errorString, "Cannot mkdir '%s'.", flTempDir);
		ErrorLog ("Initialize", _fatalError, errorString);
	}
}

ReadUserFile ()
/* Read in user's '.unidelrc' file */

{
	void ClearHeader ();
	FILE *userFile;
	char userFileName[_bufSize], *knownFloor, *ptr;
	int floor;

	(void) sprintf (userFileName, "%s/.unidelrc", homeDir);
	if (access (userFileName, 0)) {	/* Is there a unidelrc file? */
		if (close (creat (userFileName, 0666))) {	/* No, try to create it */
			(void) sprintf (errorString, "Cannot create '%s'.", userFileName);
			ErrorLog ("ReadUserFile:001", _warning, errorString);
		}
	}
	userFile = fopen (userFileName, "r");
	if (userFile == NULL) {
		(void) sprintf (errorString, "Unable to open '%s'.", userFileName);
		ErrorLog ("ReadUserFile:002", _fatalError, errorString);
	}
	ClearHeader (user, userFieldNames);
	(void) ReadHeader (userFile, user, userFieldNames);
	(void)fclose (userFile);

	if (user[_userTerm]
	    && (putenvs (envs, "TERM", user[_userTerm]) == -1))
	  ErrorLog ("ReadUserFile:001", _fatalError, "Unable to allocate memory for environment.");

	more = moreDefault = 1;
	if (user[_userMore] && isdigit (user[_userMore][0]))
		more = moreDefault = atoi (user[_userMore]);
	if (more < 0 || more > 2)
		more = 1;

	if (user[_userFloorMode])
		floorMode = (strcmp (user[_userFloorMode], "Yes") == 0) ? _true : _false;
	else
		floorMode = _true;
	if (user[_userExpertMode])
		expertMode = (strcmp (user[_userExpertMode], "Yes") == 0) ? _true : _false;
	else
		expertMode = _false;

	columns = 80;
	if (user[_userTermWidth])
		columns = atoi (user[_userTermWidth]);
	lines = 24;
	if (user[_userTermHeight])
		lines = atoi (user[_userTermHeight]);

	transferProtocol = NULL;
	SetupTransferProtocol (user[_userProtocol]);
	if (editorCommand != NULL) {
	  editorName = NULL;
	   /* XXX KeepString? */
	  AllocString ("Initialize", &editorName, editorCommand);
	  (void) strtok (editorName, " \t");
	  if ((ptr = strrchr (editorName, '/')) != NULL)
	    editorName = ptr;
	  SetupEditor (editorName);
	} else
	  SetupEditor (user[_userEditor]);
/* XXX	SetupPager (&user[_userPager]); */

	/* knownFloors are floors that we know about, i.e. not forgotten */
	if (user[_userFloors]) {
		int forgotten;

		for (knownFloor = strtok (user[_userFloors], ", ");
		  knownFloor != NULL;
		  knownFloor = strtok ((char *)NULL, ", ")) {
			if (*knownFloor == '!') {
				forgotten = _true;
				knownFloor ++;
			} else {
				forgotten = _false;
			}
			for (floor = 0; floors[floor].name != NULL && strcmp (floors[floor].name, knownFloor) != 0; floor ++);
			if (floors[floor].name != NULL)
				floors[floor].forgotten = forgotten;
		}
		(void)free ((malloc_t)user[_userFloors]), user[_userFloors] = NULL;
	}
}

ReadUserControlFile ()
{
  void ClearHeader ();
  ENTRY theEntry, *entry;
  FILE *controlFile;
  char controlFileName[_bufSize], *knownFloor;
  int floor;

  (void) sprintf (controlFileName, "%s/Admin/%s", _libDir, logname);
  controlFile = fopen (controlFileName, "r");
  if (controlFile == NULL)
    return;			/* No problem if no file for this user */
  ClearHeader (control, controlFieldNames);
  (void) ReadHeader (controlFile, control, controlFieldNames);
  (void)fclose (controlFile);

  /* Invited are rooms and floors that we have been invited into */
  if (control[_controlInvited]) {
    knownFloor = strtok (control[_controlInvited], ", ");
    while (knownFloor != NULL) {
      for (floor = 0; floors[floor].name != NULL && strcmp (floors[floor].name, knownFloor) != 0; floor ++);
      if (floors[floor].name != NULL)
	floors[floor].invited = _true;
      else {	/* try rooms */
	theEntry.key = knownFloor;
	theEntry.data = NULL;
	if ((entry = hsearch (theEntry, FIND)) != NULL)
	  ((Room *) entry -> data) -> invited = _true;
      }
      knownFloor = strtok ((char *) NULL, ", ");
    }
    (void)free ((malloc_t)control[_controlInvited]), control[_controlInvited] = NULL;
  }
}


ReadNewsFile ()
/* Read in user's '.newsrc' file */

{
	ENTRY theEntry;
	FILE *newsrcFile;
	char newsrcFileName[_bufSize], *newsrcLine, *roomName, *articlesRead, *ptr;
	int line, i;

	(void) sprintf (newsrcFileName, "%s/.newsrc", homeDir);
	if ((newsrcFile = fopen (newsrcFileName, "r")) == NULL) {
		return;
	}
	line = -1;
	options = NULL;
	while ((newsrcLine = cfgetms (newsrcFile)) != NULL) {
		if (line == -1 && strncmp (newsrcLine, "options", 7) == 0) {
			options = newsrcLine;	/* We'll leave the malloced string in the options variable */
			continue;
		}

		if (++line >= _maxNewsrcLines) {
			ErrorLog ("ReadNewsFile:004", _fatalError, "Too many .newsrc lines.");
			break;
		}

		/* Note: We're using pointers here instead of strtok/split for speed */
		/* Get room name, name length in i */
		roomName = ptr = newsrcLine;
		while (*ptr && *ptr != ' ' && *ptr != '!' && *ptr != ':')
			ptr++;
		i = ptr - roomName; /* String length */
		/* Test forgotten/not-forgotten flag */
		if (*ptr == '!')
			rooms[line].forgotten = 1;
		else
			rooms[line].forgotten = 0;
		*ptr++ = '\0';
		while (*ptr && (*ptr == ' ' || *ptr == '\t')) /* skip spaces */
			ptr++;
		/* Get articles read */
		articlesRead = ptr;
		while (*ptr && *ptr != '\n')
			ptr ++;
		*ptr = '\0';

		rooms[line].name = KeepString (roomName, i);
		AllocString ("ReadNewsFile:006", &rooms[line].articlesRead, articlesRead);
		rooms[line].originalArticlesRead = KeepString (articlesRead, i);
		rooms[line].lastCharOfName = &rooms[line].name[i];
		for (i = 0; floors[i].name != NULL && strncmp (floors[i].name, rooms[line].name, floors[i].nameLength - 1) != 0; i ++);
		if (floors[i].name == NULL)
			i = 0;
		rooms[line].floor = i;

		theEntry.key = rooms[line].name;
		theEntry.data = (char *) &rooms[line];
		(void) hsearch (theEntry, ENTER);
		(void)free ((malloc_t)newsrcLine);
	}
	(void)fclose (newsrcFile);
}

ReadActiveFile ()

{
	FILE *activeFile;
	ENTRY theEntry, *entry;
	Room *theRoom;
	char *activeFileNames[2], types[2], *ptr;
	char activeLine[_bufSize], *roomStatus, *roomName, *highestString, *lowestString;
	int n, i, j, room, highest, lowest, floor, newRoom;

	/* parse Active file for newsgroups and highest/lowest values */
	/* XXX where we get active files should be more generic,
	       from Config and .unidelrc maybe? */
	activeFileNames[0] = (char *)malloc ((size_t) strlen (_newsLibDir) + 8);
	(void) sprintf (activeFileNames[0], "%s/active", _newsLibDir);
	types[0] = _newsType;
	activeFileNames[1] = (char *)malloc ((size_t) strlen (homeDir) + 14);
	(void) sprintf (activeFileNames[1], "%s/mail/active", homeDir);
	types[1] = _mailType;
	for (j = 0; j < 2; j ++) {
		activeFile = fopen (activeFileNames[j], "r");
		if (activeFile == (FILE *)NULL) {
			continue;
		}
		while (fgets (activeLine, _bufSize, activeFile) !=
		       (char *)NULL) {
			roomName = ptr = activeLine;
			while (*ptr && *ptr != ' ')
				ptr ++;
			*ptr++ = '\0';
			highestString = ptr;
			while (*ptr && *ptr != ' ')
				ptr ++;
			*ptr++ = '\0';
			highest = atoi (highestString);
			lowestString = ptr;
			while (*ptr && *ptr != ' ')
				ptr++;
			*ptr++ = '\0';
			lowest = atoi (lowestString);
			roomStatus = ptr;
			while (*ptr && *ptr != ' ' && *ptr != '\n' && *ptr != '\t')
				ptr++;
			*ptr = '\0';

			newRoom = _false;
			theEntry.key = roomName;
			theEntry.data = NULL;
			entry = hsearch (theEntry, FIND);
			if (entry == NULL) {
				for (room = 0; rooms[room].name != NULL; room ++);
				if (room >= _maxNewsrcLines)
					ErrorLog ("ReadActiveFile:002", _fatalError, "Too many .newsrc lines.");
				
				n = strlen (roomName);
				rooms[room].name = KeepString (roomName, n);
/*				AllocString ("ReadActiveFile:004", &rooms[room].articlesRead, "");*/
				rooms[room].originalArticlesRead = KeepString ("", 0);
				rooms[room].lastCharOfName = &rooms[room].name[n];
				newRoom = _true;
				theEntry.key = rooms[room].name;
				theEntry.data = (char *) &rooms[room];
				(void) hsearch (theEntry, ENTER);
				theRoom = &rooms[room];
			} else
				theRoom = (Room *) entry -> data;
			theRoom -> lowest = lowest;
			theRoom -> highest = highest;
			theRoom -> type = types[j];
			for (floor = 0; floors[floor].name != NULL
			    && strncmp (floors[floor].name, theRoom -> name, floors[floor].nameLength - 1) != 0; floor ++)
				;
			if (floors[floor].name == NULL)
				floor = 0;
			theRoom -> floor = floor;
			for (i = 0; roomStatus[i] != '\0'; i ++) {
				if (islower (roomStatus[i]))
					roomStatus[i] = toupper (roomStatus[i]);
				switch (roomStatus[i]) {
				case 'A':	/* Anonymous */
					theRoom -> anonymous = _true;
					break;
				case 'D':	/* Display article number */
					theRoom -> displayNumber = _true;
					break;
				case 'I':	/* Invite only */
					theRoom -> inviteOnly = _true;		/* implies 'P' */
				case 'P':	/* Private */
					theRoom -> private = _true;		/* implies 'F' */
				case 'F':	/* Forgotten */
					if (newRoom)
						theRoom -> forgotten = _true;
					break;
				case 'L':	/* local distribution only */
					theRoom -> localOnly = _true;
					break;
				case 'M':	/* moderated */
					theRoom -> moderated = _true;
					break;
				case 'R':	/* Read only */
					theRoom -> readOnly = _true;
					break;
				case 'S':	/* Display Subject */
					theRoom -> displaySubject = _true;
					break;
				}
			}
		}
		(void)fclose (activeFile);
	}
}

ReadFileDirectoryFile ()

{
	ENTRY theEntry, *entry;
	FILE *directoryFile;
	char directoryFileName[_bufSize], *lineBuf, *fields[3];
	int nf;

	/* parse FileDir file directories matched to rooms */
	(void) sprintf (directoryFileName, "%s/fileDirs", _libDir);
	directoryFile = fopen (directoryFileName, "r");
	if (directoryFile == NULL) {
		return;
	}
	while ((lineBuf = fgetms (directoryFile)) != NULL) {
		if (lineBuf[0] == '#' || isspace (lineBuf[0])) {
		  (void)free ((malloc_t)lineBuf);
			continue;
		}
		(void)nstrip (lineBuf);
		/* fields: name flags directory */
		nf = split (lineBuf, fields, 3, " \t");
		if (nf == 3) {
			theEntry.key = fields[0];
			theEntry.data = NULL;
			entry = hsearch (theEntry, FIND);
			if (entry != NULL)
				((Room *) entry -> data) -> fileDir = KeepString (fields[2], strlen (fields[2]));
		}
		(void)free ((malloc_t)lineBuf);
	}
	(void)fclose (directoryFile);
}

ReadNewsgroupsFile ()
/* parse newsgroups file for newsgroup descriptions */

{
	ENTRY theEntry, *entry;
	FILE *newsgroupsFile;
	char newsgroupsFileName[_bufSize], *description, *newsgroupName;
	register char *ptr;
	char newsgroupLine[_bufSize];

	(void) sprintf (newsgroupsFileName, "%s/newsgroups", _newsLibDir);
	newsgroupsFile = fopen (newsgroupsFileName, "r");
	if (newsgroupsFile == NULL) {
		return;
	}
	while (fgets (newsgroupLine, _bufSize, newsgroupsFile) != NULL) {
		newsgroupName = ptr = newsgroupLine;
		while (*ptr && *ptr != ' ' && *ptr != '\t')
			ptr ++;
		*ptr++ = '\0';
		while (*ptr && (*ptr == ' ' || *ptr == '\t'))
			ptr ++;
		description = ptr;
		while (*ptr && *ptr != '\n')
			ptr ++;
		*ptr = '\0';

		theEntry.key = newsgroupName;
		theEntry.data = NULL;
		if ((entry = hsearch (theEntry, FIND)) != NULL)
			((Room *) entry -> data) -> description = KeepString (description, strlen (description));
	}
	(void)fclose (newsgroupsFile);
}

ReadFloorsFile ()
/* parse Floors file for floor descriptions */

{
	FILE *floorsFile;
	char floorsFileName[_bufSize], floorName[_bufSize], description[_bufSize], floorStatus[_bufSize], floorsLine[_bufSize];
	int i, floor;

	(void) sprintf (floorsFileName, "%s/Floors", _libDir);
	floorsFile = fopen (floorsFileName, "r");
	if (floorsFile == NULL) {
		floors[0].name = KeepString ("lobby.", 6);
		floors[0].nameLength = strlen (floors[0].name);
		floors[0].description = KeepString ("The Floor with No Door", 22);
		floors[0].allowNewRooms = _true;
		return;
	}
	floor = 0;
	while (fgets (floorsLine, _bufSize, floorsFile) != NULL) {
		if (isspace (floorsLine[0]) || floorsLine[0] == '#')
			continue;
		(void)sscanf (floorsLine, "%s %s %[^\n]", floorName, floorStatus, description);
		floors[floor].name = KeepString (floorName, strlen (floorName));
		floors[floor].nameLength = strlen (floors[floor].name);
		floors[floor].description = KeepString (description, strlen (description));
		for (i = 0; floorStatus[i] != '\0'; i ++) {
			if (islower (floorStatus[i]))
				floorStatus[i] = toupper (floorStatus[i]);
			switch (floorStatus[i]) {
			case 'A':	/* Anonymous */
				floors[floor].anonymous = _true;
				break;
			case 'D':	/* Display article number */
				floors[floor].displayNumber = _true;
				break;
			case 'I':	/* Invite only */
				floors[floor].inviteOnly = _true;		/* implies 'P' */
			case 'P':	/* Private */
				floors[floor].private = _true;		/* implies 'F' */
			case 'F':	/* Forgotten */
				floors[floor].forgotten = _true;
				break;
			case 'L':	/* local distribution only */
				floors[floor].localOnly = _true;
				break;
			case 'N':	/* Allow New Rooms */
				floors[floor].allowNewRooms = _true;
				break;
			case 'M':	/* moderated */
				floors[floor].moderated = _true;
				break;
			case 'R':	/* Read only */
				floors[floor].readOnly = _true;
				break;
			case 'S':	/* Display Subject */
				floors[floor].displaySubject = _true;
				break;
			}
		}
		floor ++;
		if (floor >= _maxFloors) {
			ErrorLog ("ReadConfiguration:004", _fatalError, "Too many Floors.");
		}

	}
	(void)fclose (floorsFile);
}

WriteNewsFile ()
/* Write out '.newsrc' file */

{
	FILE *newsrcFile;
	char newsrcFileName[_bufSize];
	int line;

	(void) sprintf (newsrcFileName, "%s/.newsrc", homeDir);
	newsrcFile = fopen (newsrcFileName, "w");
	if (newsrcFile == NULL) {
		(void) sprintf (errorString, "Unable to open '%s' to update.", newsrcFileName);
		ErrorLog ("WriteNewsFile:001", _fatalError, errorString);
	}

	if (options != NULL)
		(void) fprintf (newsrcFile, "%s", options);

	for (line = 0; rooms[line].name != NULL; line++) {
		if (rooms[line].type != _deadType)
			(void) fprintf (newsrcFile, "%s%c %s\n", rooms[line].name, rooms[line].forgotten ? '!' : ':', rooms[line].articlesRead);
	}
	(void)fclose (newsrcFile);
}

WriteUserFile ()
/* Write out '.unidelrc' file */

{
	FILE *userFile;
	void WriteHeader();
	char userFileName[_bufSize];
	int floor;

	(void) sprintf (userFileName, "%s/.unidelrc", homeDir);
	userFile = fopen (userFileName, "w");
	if (userFile == NULL) {
		(void) sprintf (errorString, "Unable to open '%s'.", userFileName);
		ErrorLog ("WriteUserFile:001", _fatalError, errorString);
	}

	for (floor = 1; floors[floor].name != NULL; floor ++) {
		if (floor == 1)
			(void) fprintf (userFile, "KnownFloors: ");
		else
			(void) fprintf (userFile, ",");
		if (floors[floor].forgotten)
			(void) fprintf (userFile, "!%s", floors[floor].name);
		else
			(void) fprintf (userFile, "%s", floors[floor].name);
	}
	if (floor != 1)
		(void) fprintf (userFile, "\n");
	if (user[_userFloors])
	  (void)free ((malloc_t)user[_userFloors]), user[_userFloors] = NULL;
	WriteHeader (userFile, user, userFieldNames);
	(void)fclose (userFile);
}

UserLoop ()

{
	PrintRoomsWithUnreadMessages ();
	Goto (0);
	finished = _false;
	while (!finished) {
		if (!expertMode)
			(void) printf ("[?]=menu, [H]elp%s\n", guest ? ", [L]ogin" : "");
		(void) printf ("%s ", RoomNameString (currentRoom));
		(void) DoMenu (0l, mainMenu);
	}
}

UnInitialize ()

{
	char commandString[_bufSize];

	(void) sprintf (commandString, "%s/unidelout", _libDir);
	if (!access (commandString, 0))
	  (void)system (commandString);
	(void) sprintf (commandString, "%s/.unidelout", homeDir);
	if (!access (commandString, 0))
	  (void)system (commandString);
	(void) sprintf (commandString, "rm -r %s", flTempDir);
	(void)system (commandString);
}
