/*
 * NAME
 *     Header.c -- Header handling functions
 *
 * AUTHOR
 *     Ken MacLeod
 */

#ifndef lint
static char sccsId [] = "@(#) Headers.c  1.2 11 Nov 1990 07:40:38\n\t";
#endif

#include <fgetmfs.h>
#include <stdio.h>
#include <malloc.h>

static int StrLNCmp ();

void
ClearHeader (hdr, hdrFieldNames)

char **hdr, **hdrFieldNames;

{
	while (*hdrFieldNames++)
		*hdr++ = NULL;
}

void
FreeHeader (hdr, hdrFieldNames)

char **hdr, **hdrFieldNames;

{
	while (*hdrFieldNames++) {
		if (*hdr)
		  (void)free ((malloc_t)*hdr);
		hdr ++;
	}
}

int
ReadHeader (file, hdr, hdrFieldNames)

char **hdr, **hdrFieldNames;
FILE *file;

{
	char *headerLine;
	int i;

	while ((headerLine = cfgetms (file)) != NULL) {
		if (headerLine[0] == '\n') {
			(void)free ((malloc_t)headerLine);
			break;
		}
		(void) nstrip (headerLine);
		if (headerLine[0] == '>') {	/* Quicky, get rid of '>From ' lines in mail */
		  (void)free ((malloc_t)headerLine);
		  continue;
		}
		for (i = 0; hdrFieldNames[i] != NULL && StrLNCmp (headerLine,
		  hdrFieldNames[i], strlen (hdrFieldNames[i])) != 0; i ++);
		if (hdrFieldNames[i] != NULL) {
			register char *ptr, *ptr1;

			hdr[i] = headerLine;
			ptr = &headerLine[0];
			ptr1 = &headerLine[strlen(hdrFieldNames[i])];
			while (*ptr++ = *ptr1++)
				;
		} else
		  (void)free ((malloc_t)headerLine);
	}
	return (feof (file));	/* Error: out of memory, iff not end of file */
}

void
WriteHeader (file, hdr, hdrFieldNames)

FILE *file;
char **hdr, **hdrFieldNames;

{
	while (*hdrFieldNames) {
		if (*hdr)
			(void) fprintf (file, "%s%s\n", *hdrFieldNames, *hdr);
		hdr ++;
		hdrFieldNames ++;
	}
	(void) putc ('\n', file);
}

/* Assumes ASCII strings and only characters from the set "A-Za-z0-9" and "-" */
static int
StrLNCmp (s1, s2, n)

register char *s1, *s2;
int n;

{
	register int d;

	while (*s1 && *s2 && n && ((d = (*s1 - *s2)) == 0 || d == -32 || d == 32))
		s1++, s2++, n--;

	return (n);
}
