/*
 * NAME
 *     EnterFile.c -- File entering (upload)
 *
 * AUTHOR
 *     Ken MacLeod
 */

#ifndef lint
static char sccsId [] = "@(#) EnterFile.c  1.3 06 Jun 1991 17:52:44\n\t";
#endif

#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <dirent.h>
#include <time.h>
#include "ErrorLog.h"
#include "defs.h"
#include "Unidel.h"
#include "Room.h"
#include "User.h"
#include "File.h"

/* ARGSUSED */
int
EnterFileCommand (type)

long type;

{
	char fileName[_bufSize], fileDescription[_bufSize];

	if (rooms[currentRoom].fileDir == NULL) {
		(void) printf ("Files can be entered only in rooms that end with \"]\".\n");
		return;
	}

	if (!transferBatch) {
		(void) printf ("Enter filename:\n:");
		GetString (fileName, _normal);
		if (fileName[0] == '\0')
			return;
		if (strchr (fileName, '/') != NULL) {
			(void) printf ("A file name cannot include a '/'.\n");
			return;
		}
		(void) printf ("Enter description:\n:");
		GetString (fileDescription, _normal);
		if (fileDescription[0] == '\0')
			return;
	} else {
	  (void)strcpy (fileName, "");
	  (void)strcpy (fileDescription, "");
	}

	(void) EnterFile (fileName, fileDescription);
}

EnterFile (fileName, fileDescription)	/* fileName can be a path for multiple files, or a single filename */
/* XXX Some of the logic here leaves much to be desired */

char *fileName, *fileDescription;

{
	FILE *aFile;
	DIR *tempDir;
	struct dirent *dirEnt;
	char commandString[_bufSize], descriptionFileName[_bufSize], readyQuestion[_bufSize];
	char sourceFileName[_bufSize], commandString1[_bufSize];
	int bad, n, i, answer;
	time_t theTime, time ();

	bad = _false;
	if (local) {
		(void) printf ("Copy from: ");
		GetString (sourceFileName, _normal);
		if (sourceFileName[0] != '\0') {
			(void) sprintf (commandString, "exec cp %s %s", sourceFileName, flTempDir);
			bad = system (commandString);
		}
	} else {
		if (transferProtocol == NULL) {
			(void) printf ("\nYou have not selected a transfer protocol.\n");
			return (_true);
		}
		if (transferEnterCommand == NULL) {
			(void) printf ("\n%s transfer not implemented.\n", transferProtocol);
			return (_true);
		}
		(void) sprintf (readyQuestion, "Ready for %s upload ([Y]/N)? ", transferProtocol);
		answer = AnswerYesNo (readyQuestion, _defaultAnswer | _defaultYes);
		if (answer == _true) {
			SetupTerminal (_false);
			(void) sprintf (commandString1, transferEnterCommand, fileName);
			(void) sprintf (commandString, "export SHELL PATH ; SHELL=/bin/rsh PATH=/usr/rbin cd %s ; exec %s", flTempDir, commandString1);
			bad = system (commandString);
			SetupTerminal (_true);
		}
		if (bad || (answer != _true))
			return _true;
	}

	(void) sprintf (descriptionFileName, "%s/.fileList", rooms[currentRoom].fileDir);
	if (access (descriptionFileName, 0)) {	/* Is there a files file? */
		if (close (creat (descriptionFileName, 0666))) {	/* No, try to create it */
			(void) sprintf (errorString, "Cannot create '%s'.", descriptionFileName);
			ErrorLog ("main:004", _warning, errorString);
		}
	}
	aFile = fopen (descriptionFileName, "a");
	if (aFile == NULL) {
		(void) sprintf (errorString, "Unable to open '%s'.", descriptionFileName);
		ErrorLog ("main:004", _error, errorString);
		return _true;
	}

	if ((tempDir = opendir (flTempDir)) == NULL) {
	  (void)fclose (aFile);
		(void) sprintf (errorString, "Cannot open temp directory '%s'.", flTempDir);
		ErrorLog ("EnterFile", _error, errorString);
		return (_true);
	}
	/* slow way to count number of entries in dir */
	for (n = 0; (dirEnt = readdir (tempDir)) != NULL;) {
		if (strcmp (dirEnt -> d_name, ".") != 0
		  && strcmp (dirEnt -> d_name, "..") != 0)
			n ++;
	}
	rewinddir (tempDir);
	for (i = 0; i < n && (dirEnt = readdir (tempDir)) != NULL;) {
		if (strcmp (dirEnt -> d_name, ".") == 0
		  || strcmp (dirEnt -> d_name, "..") == 0)
			continue;
		i ++;
		(void) sprintf (commandString, "exec cp %s/%s %s", flTempDir, dirEnt -> d_name, rooms[currentRoom].fileDir);
		if ((bad = system (commandString)) != 0) {
			(void) sprintf (errorString, "Copying uploaded file '%s/%s' to '%s', cp returned %d.\n",
			  flTempDir, dirEnt -> d_name, rooms[currentRoom].fileDir, bad);
			ErrorLog ("EnterFile", _error, errorString);
		}
		(void) sprintf (commandString, "%s/%s", flTempDir, dirEnt -> d_name);
		if (unlink (commandString) == -1) {
			(void) sprintf (errorString, "Unlinking uploaded file '%s', errno %d.\n", commandString, errno);
			ErrorLog ("EnterFile", _error, errorString);
		}

		(void) fprintf (aFile, "\nFile: %s\n", dirEnt -> d_name);
		if (n == 1 && fileDescription != NULL && fileDescription[0] != '\0')
			(void) fprintf (aFile, "Desc: %s\n", fileDescription);
		(void) fprintf (aFile, "User: %s@%s (%s)\n", logname, _siteName, logname);
		(void) time (&theTime);
		(void) fprintf (aFile, "Date: %s", ctime (&theTime));
	}
	(void)closedir (tempDir);
	(void)fclose (aFile);
	if (n != 0)			/* Generate an article for this */
		PostFileDescription (fileName, fileDescription, 0l);

	return (_false);
}

PostFileDescription (fileName, fileDescription, fileSize)

char *fileName, *fileDescription;
long fileSize;

{
	FILE *articlePipe;
	char commandString[_bufSize];

	(void) sprintf (commandString, "%s -t \"File '%s'.\" -n %s -f unidel",
			_newsDelivery, fileName, rooms[currentRoom].name);
	articlePipe = popen (commandString, "w");
	if (articlePipe == NULL) {
		ErrorLog ("EnterFile:001", _error, "Unable to open pipe to generate file uploaded article.");
		return;
	}

	(void) fprintf (articlePipe, "Reply-To: unidel@%s (Unidel BBS Version %s)\n", _siteName, _version);
	(void) fprintf (articlePipe, "Summary: %s\n", fileDescription);
	(void) fprintf (articlePipe, "File: %s/%s@%s\n", rooms[currentRoom].name, fileName, _siteName);
	if (fileSize >= _maxMailServerSize) {
		(void) fprintf (articlePipe, "Distribution: local\n");
	}
	(void) fprintf (articlePipe, "\n");
	if (fileSize < _maxMailServerSize) {
		(void) fprintf (articlePipe, "#SENDME %s/%s\n", rooms[currentRoom].name, fileName);
		(void) fprintf (articlePipe, "#ME user@site\n");
		(void) fprintf (articlePipe, "\n");
		(void) fprintf (articlePipe, "  To receive the file described in the Summary line, reply to this article\n");
		(void) fprintf (articlePipe, "with the above '#SENDME' line intact.  The file will be sent to you by e-mail.\n");
		(void) fprintf (articlePipe, "  To ensure prompt and reliable delivery, change 'user' and 'site' in the '#ME'\n");
		(void) fprintf (articlePipe, "line to your login name and site name, do not add any spaces or '!' mail paths.\n");
		(void) fprintf (articlePipe, "\n");
		(void) fprintf (articlePipe, "  If your reply does not get through you can mail to the sysop of the system at\n");
		(void) fprintf (articlePipe, "'sysop@%s'.  To receive a listing of files available, send e-mail\n", _siteName);
		(void) fprintf (articlePipe, "to 'unidel@%s' with the line '#SENDME %s/.fileList'.\n", _siteName,
		    rooms[currentRoom].name);
		(void) fprintf (articlePipe, "  Other available files and information are available by requesting\n");
		(void) fprintf (articlePipe, "'#SENDME AllList' and '#SENDME Info'.  Be sure to include a '#ME' line.\n");
	}
	(void) pclose (articlePipe);
}
