/*
 * NAME
 *     Enter.c -- General entering commands and functions
 *
 * AUTHOR
 *     Ken MacLeod
 */

#ifndef lint
static char sccsId [] = "@(#) Enter.c  1.3 4/12/91 20:50:09\n\t";
#endif

#include <sys/types.h>
#include <stdio.h>
#include <fgetmfs.h>
#include <malloc.h>
#include <ctype.h>
#include <string.h>
#include <getenvs.h>
#include "ErrorLog.h"
#include "defs.h"
#include "Unidel.h"
#include "Message.h"
#include "Room.h"
#include "User.h"
#include "File.h"

extern Envs envs[];
extern char *user[];

EnterSignature ()

{
	char signatureFileName[_bufSize];

	(void) sprintf (signatureFileName, "%s/.signature", homeDir);

	(void) printf ("Signatures can only be FOUR lines.  The less the better.\n");
	(void) Edit (signatureFileName);	/* We don't check size for now. */
}

EnterFullName ()

{
	char fullNameFileName[_bufSize];

	(void) sprintf (fullNameFileName, "%s/.name", homeDir);

	(void) printf ("Names can only be ONE line.\n");
	(void) Edit (fullNameFileName);
}

/* ARGSUSED */
int
ToggleExpertMode (dummy)

long dummy;

{
	if (expertMode) {
		(void) printf ("\n Now in Novice Mode\n");
		AllocString ("ToggleExpertMode", &user[_userExpertMode], "No");
		expertMode = _false;
	} else {
		(void) printf ("\n Now in Expert Mode\n");
		AllocString ("ToggleExpertMode", &user[_userExpertMode], "Yes");
		expertMode = _true;
	}
}

/* ARGSUSED */
int
EnterPauseMode (dummy)

long dummy;

{
	int aChar;

	(void) printf ("Do you want to pause at the end of a screen ([Y]/N)? ");
	aChar = GetChar (_upperCase | _noEcho);
	if (aChar == 'N') {
		(void) printf ("No\n");
		AllocString ("EnterPauseMode", &user[_userMore], "0");
		moreDefault = 0;
	} else {
		(void) printf ("Yes\n");
		(void) printf ("Do you want to pause after a header ([Y]/N)? ");
		aChar = GetChar (_upperCase | _noEcho);
		if (aChar == 'N') {
			(void) printf ("No\n");
			AllocString ("EnterPauseMode", &user[_userMore], "1");
			moreDefault = 1;
		} else {
			(void) printf ("Yes\n");
			AllocString ("EnterPauseMode", &user[_userMore], "2");
			moreDefault = 2;
		}
	}
}

/* ARGSUSED */
int
EnterTerminalType (dummy)

long dummy;

{
	char tempString[_bufSize];

	if (user[_userTerm]) {
		(void) strcpy (tempString, user[_userTerm]);
	} else {
		(void) strcpy (tempString, "none");
	}
	/* XXX Can we get a better list of terminal types, or a selection? */
	(void) printf ("  Some popular terminal types are:  ansi  vt100  wyse60  none\n");
	(void) printf ("What type of terminal are you using or emulating [%s]? ", tempString);
	/* XXX should't we check terminal type? */
	if (GetStringWDefault ("", tempString, (char *) NULL, _lowerCase) == _keyAbort)
		return;
	if (tempString[0] != '\0'
	    && (putenvs (envs, "TERM", tempString)) == -1)
	  ErrorLog ("EnterTerminalType", _fatalError, "Out of memory");
}

/* ARGSUSED */
EnterTransferProtocol (dummy)

long dummy;

{
#	define _maxProtocols 22		/* About a screen-fulls worth, because I'm too lazy to make it limitless */
	FILE *protocolFile;
	char protocolFileName[_bufSize], *fields[5], *protocols[_maxProtocols], protocolNumber[_bufSize];
	char *protocolLine;
	int nf, protocol, newProtocol;

	(void) sprintf (protocolFileName, "%s/Transfers", _libDir);
	if ((protocolFile = fopen (protocolFileName, "r")) == NULL) {
		(void) sprintf (errorString, "Could not open Transfers file '%s'.", protocolFileName);
		ErrorLog ("SetupTransferProtocol", _error, errorString);
		return;
	}

	for (protocol = 0; protocol < _maxProtocols; protocol ++)
		protocols[protocol] = NULL;
	protocol = 0;
	while (protocol < _maxProtocols && (protocolLine = fgetms (protocolFile)) != NULL) {
		if (protocolLine[0] == '\0' || protocolLine[0] == '#' || isspace(protocolLine[0])) {
			(void)free ((malloc_t)protocolLine);
			continue;
		}
		(void)nstrip (protocolLine);
		nf = split (protocolLine, fields, 5, ":");
		if (nf >= 5) {
			protocols[protocol] = (char *)malloc ((size_t) strlen (fields[0]) + 1);
			(void) strcpy (protocols[protocol], fields[0]);
			(void) printf ("  %2d.  %-15s %s\n", ++protocol, fields[0], fields[1]);
		}
		(void)free ((malloc_t)protocolLine);
	}
	(void)fclose (protocolFile);

	if (protocol == 0) {
		(void) printf ("Oops, there's no protocols defined, annoy sysop.");
		return;
	}

	(void) printf ("\nSelect a transfer protocol:  \n");
	GetString (protocolNumber, _lowerCase);
	newProtocol = 0;
	if (protocolNumber[0] != '\0' && isdigit (protocolNumber[0])) {
		newProtocol = atoi (protocolNumber);
	}
	if (newProtocol < 1 || newProtocol > protocol) {
		(void) printf ("Invalid protocol selected.\n");
	} else {
		SetupTransferProtocol (protocols[newProtocol - 1]);
		if (!user[_userProtocol] || (strcmp (transferProtocol, user[_userProtocol]) != 0))
			AllocString ("EnterTransferProtocol", &user[_userProtocol], transferProtocol);
		(void) printf ("New protocol, %s, set.\n", transferProtocol);
	}
	for (newProtocol = 0; newProtocol < protocol; newProtocol ++)
		(void)free ((malloc_t)protocols[newProtocol]);
}

/* ARGSUSED */
EnterEditor (dummy)

long dummy;

{
#	define _maxEditors 22		/* About a screen-fulls worth, because I'm too lazy to make it limitless */
	FILE *editorFile;
	char editorFileName[_bufSize], *fields[4], *editors[_maxEditors], editorNumber[_bufSize];
	char *editorLine;
	int nf, editor, newEditor;

	(void) sprintf (editorFileName, "%s/Editors", _libDir);
	if ((editorFile = fopen (editorFileName, "r")) == NULL) {
		(void) sprintf (errorString, "Could not open Editors file '%s'.", editorFileName);
		ErrorLog ("EnterEditor", _error, errorString);
		return;
	}

	for (editor = 0; editor < _maxEditors; editor ++)
		editors[editor] = NULL;
	editor = 0;
	while (editor < _maxEditors && (editorLine = fgetms (editorFile)) != NULL) {
		if (editorLine[0] == '\0' || editorLine[0] == '#' || isspace(editorLine[0])) {
			(void)free ((malloc_t)editorLine);
			continue;
		}
		(void)nstrip (editorLine);
		nf = split (editorLine, fields, 4, ":");
		if (nf >= 4) {
			editors[editor] = (char *)malloc ((size_t) strlen (fields[0]) + 1);
			(void) strcpy (editors[editor], fields[0]);
			(void) printf ("  %2d.  %-15s %s\n", ++editor, fields[0], fields[1]);
		}
		(void)free ((malloc_t)editorLine);
	}
	(void)fclose (editorFile);

	if (editor == 0) {
		(void) printf ("Oops, there's no editors defined, annoy sysop.");
		return;
	}

	(void) printf ("\nSelect an editor:  \n");
	GetString (editorNumber, _lowerCase);
	newEditor = 0;
	if (editorNumber[0] != '\0' && isdigit (editorNumber[0])) {
		newEditor = atoi (editorNumber);
	}
	if (newEditor < 1 || newEditor > editor) {
		(void) printf ("Invalid editor selected.\n");
	} else {
		SetupEditor (editors[newEditor - 1]);
		if (!user[_userEditor] || (strcmp (editorName, user[_userEditor]) != 0))
			AllocString ("EnterEditor", &user[_userEditor], editorName);
		(void) printf ("New editor, %s, set.\n", editorName);
	}
	for (newEditor = 0; newEditor < editor; newEditor ++)
		(void)free ((malloc_t)editors[newEditor]);
}
