/*----------------------------------------------------------------------------
 * This program will add a user entry to the password file.
 *
 *  Usage: newUser acctName minMum groupName fullName loginDirectory defaultShell defaultAge
 *  Warning: This program is setuid!
 */

#include <stdio.h>
#include <grp.h>
#include <pwd.h>
#include <malloc.h>

/*----------------------------------------------------------------------------
 * Supply version control information.
 */

static char	NEWUSER [] = "@(#) newUser.c 1.1 -- Add a user name to passwd file -- 89/03/18 22:06:04";

int groupNumber (), userNumber (), setuid (), putpwent ();
struct group *getgrnam (), *theGroup;
struct passwd *getpwent ();
void endgrent (), endpwent (), setpwent ();

main (argc, argv)

int argc;
char *argv [];

{
	register uNum, gNum;
	char passwdDir [80];
	struct passwd *newEntry;
	FILE *passwordFile;

	if (argc < 5) {
		fprintf (stderr, "newUser: usage: user minNumber groupName fullName [logDir [shell] [aging]]\n");
		exit (1);
	}
	if ((gNum = groupNumber (argv [3])) == 0) {
		fprintf (stderr, "No group found: %s\n", argv [3]);
		exit (1);
	}
	if ((uNum = userNumber (argv [1], atoi (argv [2]))) == 0) {
		fprintf (stderr, "User name: %s is in use.\n", argv [1]);
		exit (1);
	}
	sprintf (&passwdDir [0], "/usr/acct/%s", argv [1]);
	newEntry = (struct passwd *) malloc (sizeof (struct passwd));
	newEntry -> pw_passwd = NULL;
	newEntry -> pw_comment = NULL;
	newEntry -> pw_uid = uNum;
	newEntry -> pw_gid = gNum;
	newEntry -> pw_dir = &passwdDir [0];
	newEntry -> pw_shell = "/bin/sh";
	newEntry -> pw_age = NULL;
	newEntry -> pw_name = argv [1];
	newEntry -> pw_gecos = argv [4];
	if (argc > 5) {
		newEntry -> pw_dir = argv [5];
	}
	if (argc > 6) {
		newEntry -> pw_shell = argv [6];
	}
	if (argc > 7) {
		newEntry -> pw_age = argv [7];
	}
	if (setuid (0) == 0) {
		if ((passwordFile = fopen ("/etc/passwd", "a+")) != NULL) {
			if (putpwent (newEntry, passwordFile) == 0) {
				exit (0);
			}
		}
	}
}
 
int groupNumber (theName)

char *theName;

{
	if ((theGroup = getgrnam (theName)) != NULL) {
		endgrent ();
		return (theGroup -> gr_gid);
	}
	endgrent ();
	return (0);
}

int userNumber (theName, lowest)

char *theName;
int lowest;

{
	register struct passwd *theEntry;
	register int theUID;

	theUID = lowest;
	while ((theEntry = getpwent ()) != NULL) {
		if (strcmp (theName, theEntry -> pw_name) == 0) {
			endpwent ();
			return (0);
		}
		if (theEntry -> pw_uid == theUID) {
			++ theUID;
			setpwent ();
		}
	}
	endpwent ();
	return (theUID);
}
