#
#  NewUser  --  auto registration for new users
#

UNIDIR=/home/rspdev/ken/play/unidel
LIBDIR=$UNIDIR/lib
BINDIR=$UNIDIR/bin
DOCDIR=$UNIDIR/doc
HOMEDIRS=$UNIDIR/usr
passwdFile=/home/rspdev/ken/play/unidel/lib/passwd
minPasswd=301
gid=102
adminAddress=ken

echo

if [ -f $DOCDIR/blurb.doc ]
then
	more $DOCDIR/blurb.doc
fi

echo "\n\nWould you like to register? ([y]/n) \c"
read ans
if [ "$ans" = "n" ] 
then
  echo "We're sorry to have wasted your time, we'll log you out now."
  exit 1
fi

ans=n
while [ "$ans" = "n" ]
do
  while [ "$ans" = "n" ]
  do
    echo "
Enter your login name or handle.  This is the name you will use when you log
into this system.  It is also the name the system knows you by, and your
mailing address on this system.  For best results, do not use periods,
spaces, colons or other special characters.  There is an 8 character limit.
You can not change this name, and it must be unique among all names on this
system.  You will have as many chances as required to pick a unique name.
Login name:"
    read name
    name=`echo "$name" | /usr/bin/tr -d ":"`
    tName=`echo "$name" | /usr/bin/tr -d ".@$#\'\"\\/"`
    loginName=`echo "$tName" | /usr/bin/tr " [A-Z]" "_[a-z]" | cut -c1-8`
    if /bin/grep "^$loginName:" $passwdFile >/dev/null
    then
      echo "We already have someone by that name, try a different spelling."
      ans=n
    else
      ans=y
    fi
  done
  echo "
Enter your full name.  This is the name that other users around the world
will see on messages that you write.  If you are going to be using USENET,
the world wide network, it is recomended that you use your REAL name.  This
name can be changed at any time.
Full name:"
  read name
  fullName=`echo "$name" | /usr/bin/tr -d ":"`
  echo "City, State, Zip:"
  read city
  echo "Computer type? (ex. Mac II, Compaq 386, Cray X/MP, AT Clone, etc.)"
  read computer
  echo
#  name=`echo "$name" | $BINDIR/UpLow`
#  city=`echo "$city" | $BINDIR/UpLow`
  echo "Name:      $fullName"
  echo "City:      $city"
  echo "Computer:  $computer"
  echo
  echo "Is this correct? ([y]/n) \c"
  read ans
done
echo "Creating user information files..."
passwdLine="$loginName:,..:$minPasswd:$gid:$fullName:$HOMEDIRS/$loginName:$BINDIR/unidel"
set `echo "$passwdLine" | $BINDIR/AutoVal`
userNumber=$1
shift
errorMessage="$*"

if [ "$userNumber" = "0" ]
then
  echo "Oops, we've had an error trying to create a log-in for you, we'll save"
  echo "this information for later, try logging in a few days and we should have"
  echo "everything straightened out."
  echo
  echo "When you log in a few days your login is '$loginName'"
  echo
  (
    echo "\n******   NOT REGISTERED!!  ******"
	echo "#ERROR $errorMessage"
    echo "#N $name"
    echo "#C $city"
	echo "#M $computer"
    echo "#D `date`"
    echo "#p $passwdLine"
  ) | tee -a $LIBDIR/loginErrs | /bin/mail $adminAddress
  exit 1
fi
homeDir="$HOMEDIRS/$loginName"
echo "Setting up your account..."
cp $LIBDIR/defaultDeliver $homeDir/.deliver
mkdir $homeDir/.mail
touch $homeDir/.mail/history.pag $homeDir/.mail/sys
echo "mail 0000000000 00001 y" >$homeDir/.mail/active
chmod 444 $homeDir/.deliver $homeDir/.mail/history.pag $homeDir/.mail/sys
chmod 660 $homeDir/.mail/active
chmod 775 $homeDir/.mail
#
# Uncomment this if you have chown runnable by someone other than root
#
# chown $loginName $homeDir/.deliver $homeDir/.mail $homeDir/.mail/active $homeDir/.mail/history.pag $homeDir/.mail/sys
(
  echo "\n#N $name"
  echo "#C $city"
  echo "#M $computer"
  echo "#U $userNumber"
  echo "#D `date`"
  echo "#p $passwdLine"
) | tee -a $LIBDIR/users | /bin/mail $adminAddress
echo
echo
echo "IMPORTANT:  Your login name is:"
echo
echo "      $loginName"
echo
echo "NOTE that it is all lower case and spaces are '_'"
echo "
                          *** IMPORTANT ***

Please log in now, you will be asked for your login name.  Type in your login
name from above followed by a RETURN.  The system will then tell you that
your password has expired and ask you for a new one.  You must enter the same
password (your new one) twice to convince the system that you really know
what your new password is.  Read these instructions carefully to avoid being
hung up on.
                   ***YOU WILL ONLY GET 3 CHANCES***"
SHELL=/bin/sh
export SHELL
unset PAGER EDITOR VISUAL TERM
exec unilogin
exit 0
