/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

/* cafm: each structure contains one C (character) command of the afm file */
typedef struct cafm {
  int c_used;       /* is this entry used ? (TRUE/FALSE) */
  int c_type;       /* CT_....*/
  int c_execps_type;/* ExecPs type of character: what class is it? */
  int c_map;        /* Normally FALSE. TRUE, if this code has
		       been reserved for a remap or a default encoding. */
  char * c_string;  /* Normally the name of the character, but for PS
		       procedure characters the PS procedure code. */
  int c_wx;         /* wx value */
  int c_llx;        /* Bounding box, lower left, x coordinate */
  int c_lly;        /* Bounding box, upper left, y coordinate */
  int c_urx;        /* Bounding box, lower right, x coordinate */
  int c_ury;        /* Bounding box, upper right, y coordinate */
  struct kpx * c_kern; /* pointer to kerning information. This is used
                        * to build a linked list of all kerning entries
                        * where the left character is the character
			* stored in this entry. NULL indicates end.
                        */
  struct lig * c_lig; /* pointer to ligature information. */
  int c_tfm;       /* width, read in from .tfm file */
} CAFM, *CAFM_P;

/* kpx: kerning information from afm and pfd files. */
typedef struct kpx {
  char * k_cleft;   /* character on the left (PostScript Name) */
  char * k_cright;  /* character on the right (PostScript Name) */
  int    k_dist;    /* how much is the kerning ? (unit: as in afm file,
		     * based on 1000) */
  struct kpx * k_next; /* next kerning entry with same first character */
} KPX, *KPX_P;

/* There is one of those structures for each ligature encountered
 * in an afm file or in a pfd file.
 * A linked list is hanging off the first character */
typedef struct lig {
  char * l_cleft;   /* character on the left (PostScript name) */
  char * l_cright;   /* character on the right (PostScript name) */
  char * l_lig_name;/* what is the resulting ligature's name ? */
  struct lig * l_next; /* next such structure, NULL indicates end */
} LIG, *LIG_P;

/* Element stored in hash table for mapping character names to their
 * afm codes. This is NOT the remapping table. */
typedef struct chn {
  int c_code; /* code of the character */
} CHN, *CHNP;

/* Remapping info: what character code is the name mapped to! */
typedef struct crm {
  int r_code; /* code of the character */
} CRM, *CRMP;

/* No code in afm file */
#define NO_CODE_IN_AFM -1
/* excluded character (ExcludeChar in pfd file) */
#define EXCLUDED_CHAR_CODE -2

