#ifndef __NVKM_DEVIDX_H__
#define __NVKM_DEVIDX_H__
enum nvkm_devidx {
	NVDEV_ENGINE_DEVICE,
	NVDEV_SUBDEV_VBIOS,

	/* All subdevs from DEVINIT to DEVINIT_LAST will be created before
	 * *any* of them are initialised.  This subdev category is used
	 * for any subdevs that the VBIOS init table parsing may call out
	 * to during POST.
	 */
	NVDEV_SUBDEV_DEVINIT,
	NVDEV_SUBDEV_IBUS,
	NVDEV_SUBDEV_GPIO,
	NVDEV_SUBDEV_I2C,
	NVDEV_SUBDEV_DEVINIT_LAST = NVDEV_SUBDEV_I2C,

	/* This grouping of subdevs are initialised right after they've
	 * been created, and are allowed to assume any subdevs in the
	 * list above them exist and have been initialised.
	 */
	NVDEV_SUBDEV_FUSE,
	NVDEV_SUBDEV_MXM,
	NVDEV_SUBDEV_MC,
	NVDEV_SUBDEV_BUS,
	NVDEV_SUBDEV_TIMER,
	NVDEV_SUBDEV_FB,
	NVDEV_SUBDEV_LTC,
	NVDEV_SUBDEV_INSTMEM,
	NVDEV_SUBDEV_MMU,
	NVDEV_SUBDEV_BAR,
	NVDEV_SUBDEV_PMU,
	NVDEV_SUBDEV_VOLT,
	NVDEV_SUBDEV_THERM,
	NVDEV_SUBDEV_CLK,

	NVDEV_ENGINE_FIRST,
	NVDEV_ENGINE_DMAOBJ = NVDEV_ENGINE_FIRST,
	NVDEV_ENGINE_IFB,
	NVDEV_ENGINE_FIFO,
	NVDEV_ENGINE_SW,
	NVDEV_ENGINE_GR,
	NVDEV_ENGINE_MPEG,
	NVDEV_ENGINE_ME,
	NVDEV_ENGINE_VP,
	NVDEV_ENGINE_CIPHER,
	NVDEV_ENGINE_BSP,
	NVDEV_ENGINE_MSPPP,
	NVDEV_ENGINE_CE0,
	NVDEV_ENGINE_CE1,
	NVDEV_ENGINE_CE2,
	NVDEV_ENGINE_VIC,
	NVDEV_ENGINE_MSENC,
	NVDEV_ENGINE_DISP,
	NVDEV_ENGINE_PM,
	NVDEV_ENGINE_MSVLD,
	NVDEV_ENGINE_SEC,
	NVDEV_ENGINE_MSPDEC,

	NVDEV_SUBDEV_NR,
};
#endif
