/*
 *  Top - a top users display for Berkeley Unix
 *
 *  General (global) definitions
 */

/* Number of lines of header information on the standard screen */
#define Header_lines	6

/* Number of columns needed for display */
#define Display_width	80

/* Log base 2 of 1024 is 10 (2^10 == 1024) */
#define LOG1024		10

/* Convert clicks (kernel pages) to kbytes ... */
/* If there is no PGSHIFT defined, assume it is 11 */
/* Is this needed for compatability with some old flavor of 4.2 or 4.1? */
#if defined(scs)
	/* the s/375 <machine/param.h> has this as 9, but it's really 10 */
# undef PGSHIFT
# define PGSHIFT 10
#endif scs

#ifndef PGSHIFT
# define pagetok(size)	((size) << 1)
#else
# if PGSHIFT>10
#  define pagetok(size)	((size) << (PGSHIFT - LOG1024))
# else
#  define pagetok(size)	((size) >> (LOG1024 - PGSHIFT))
# endif
#endif

#if defined(sun)
#define percent_cpu(pp) ((double)(pp)->p_pctcpu / FSCALE)
#else
#if	defined(mips)
#define percent_cpu(pp) (FIX_TO_DBL((pp)->p_pctcpu))
#else
#define percent_cpu(pp) ((pp)->p_pctcpu)
#endif	mips
#endif sun

extern double logcpu;

double log();
double exp();

extern char (* screenbuf)[Display_width];
