/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 value.c
 *	Date:	 2/25/89
 *	Version: 1.11
 *
 *	value.c - Functions to manage the "value" part of a "word=value" argument.
 */
#ifndef	lint
static	char	SccsId[] = "@(#)value.c	1.11 (monitor) 2/25/89" ;
#endif

/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 */

#include <stdio.h>

#include "include.h"

/*
 *	Functions that don't return (int).
 */
char	*calloc(),
	*bsearch() ;

void	free() ;

/*
 *	Declared so I can use it as the argument to a function.
 */
int	compare() ;

/*
 *	Module name for error functions.
 */
static	char	*module = "value" ;

/*
 *	Take the "value" part of a "word=value" argument and
 *	build a null terminated vector.  Example:
 *
 *		"ra1,ra2,hp3" 
 *	becomes:
 *		struct list.base[] = { "ra1", "ra2", "hp3", 0 };
 */
build_value(value, lp)
char	*value ;
register struct list *lp ;
{
	register char	*p ;
	register int	i, nel ;

	if( value == NULL || *value == '\0' ) {
		lp->nel = 0 ;
		return ;
	}

	for(p = value, nel = 0; *p != NULL ; p++) {
		if( *p == ',' )
			nel++ ;
	}

	lp->nel = ++nel ;

	if( lp->base )
		free((char *)lp->base) ;

	if((lp->base = (char **)calloc((unsigned)nel, sizeof(char *))) == NULL )
		fatal("Can't allocate space for value list: %s.\n", module);

	lp->base[0] = value ;

	for(p = value, i= 0; *p != NULL; p++)
		if( *p == ',' ) {
			lp->base[++i] = p+1 ;
			*p = '\0' ;
		}

	qsort((char *)lp->base, nel, sizeof(char *), compare);
}

/*
 *	Determine if we want to check the list (nel != 0) and
 *	if so, check the list for value build from name, unit.
 *
 *	For CPU's will pass an empty name string and be treated
 *	the same as everyone else.
 *
 *	A return value of 1 indicates that we want this "value"
 *	and 0 means that we don't.
 */
find_value(lp, name, unit)
struct list 	*lp ;
char		*name ;
int		unit ;
{
	char	*key, *sprintf() ;
	char	buf[BUFSIZ] ;

	if( lp->nel == 0 )
		return 1 ;

	if((key = sprintf(buf, "%s%d", name, unit)) == NULL )
		return 0 ;

	return (int)bsearch((char *)&key, (char *)lp->base, (unsigned)lp->nel,
			KEY_SIZE, compare);
}

/*
 *	The compare function for the sort routine.
 */
compare(a, b)
char	**a, **b ;
{
	return strcmp(*a, *b);
}
