/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 tables.c
 *	Date:	 2/13/89
 *	Version: 1.5
 *
 *	tables.c - Keep the many tables in one place.
 */
#ifndef	lint
static	char	SccsId[] = "@(#)tables.c	1.5 (monitor) 2/13/89" ;
#endif

/*
 * Modification History
 *
 * Jan. 15, 1989 -- arr
 *
 *	Move record dump functions from read.c.
 */

#include "include.h"

/*
 *	Function declarations for the tables.
 */
int	f_first(),
	f_last(),
	f_sample(),
	f_loadave(),
	f_user(),
	f_free(),
	f_panic(),
	open_buf(),     f_buf(),     magnify_buf(),     help_buf(),
	open_cpu(),     f_cpu(),     magnify_cpu(),     help_cpu(),
	redraw_pid(),   f_pid(),     magnify_pid(),     help_pid(),
	open_tty(),     f_tty(),     magnify_tty(),     help_tty(),
	open_disk(),    f_disk(),    magnify_disk(),    help_disk(),
	open_fork(),    f_fork(),    magnify_fork(),    help_fork(),
	open_swap(),    f_swap(),    magnify_swap(),    help_swap(),
	open_namei(),   f_namei(),   magnify_namei(),   help_namei(),
	open_netif(),   f_netif(),   magnify_netif(),   help_netif(),
	open_memory(),  f_memory(),  magnify_memory(),  help_memory(),
	open_paging(),  f_paging(),  magnify_paging(),  help_paging(),
	open_sample(),  f_sample(),  magnify_sample(),  help_sample(),
	open_process(), f_process(), magnify_process(), help_process() ;

int	help_screen(), f_ni(), f_nop() ;

/*
 *	The mag_open function is used:
 *
 *	a.  To print the headers for that data record.
 *	b.  To determine if a function is available.  Only records with
 *	    a display function will show up on the list.
 *	c.  As the redraw function.
 *
 *	The mag_display function is used as the main display function.
 *	In the interests of better performance, it should only display
 *	what it has to.
 *
 *	There are no plans to ever have a magnify function for the user
 *	or loadave data records.
 */
struct magnify_table mag_array[] = {
	0, 0, 0,					/* first */
	0, 0, 0,					/* last */
	open_sample,  magnify_sample,  help_screen,	/* sample */
	0, 0, 0,					/* record type 3 */
	open_cpu,     magnify_cpu,     help_screen,	/* cpu */
	open_tty,     magnify_tty,     help_screen,	/* tty */
	open_disk,    magnify_disk,    help_screen,	/* disk */
	open_memory,  magnify_memory,  help_screen,	/* free */
	open_fork,    magnify_fork,    help_screen,	/* fork */
	open_paging,  magnify_paging,  help_screen,	/* page */
	open_process, magnify_process, help_screen,	/* proc */
	open_swap,    magnify_swap,    help_screen,	/* swap */
	0, 0, 0,					/* tape */
	0, 0, 0,					/* user */
	open_netif,   magnify_netif,   help_screen,	/* netif */
	open_memory,  magnify_memory,  help_screen,	/* memory */
	0, 0, 0,					/* loadave */
	redraw_pid,   magnify_pid,     help_screen,	/* pid */
	open_buf,     magnify_buf,     help_screen,	/* buffer cache */
	0, 0, 0,					/* nfs */
	open_namei,   magnify_namei,   help_screen,	/* namei cache */
	0, 0, 0,					/* kmem stats */
};

/*
 *	Array of function pointers, one for each record type.
 */
int	(*dump_functions[])() = {
	f_first, 				/* FIRST */
	f_last, 				/* LAST */
	f_sample, 				/* SAMPLE */
	f_nop,					/* unused control record */
	f_cpu, 					/* CPU */
	f_tty,					/* TTY */
	f_disk, 				/* DISK */
	f_free, 				/* Free memory */
	f_fork,					/* FORK */
	f_paging, 				/* PAGE */
	f_process, 				/* PROC */
	f_swap,					/* Swap space */
	f_ni, 					/* TAPE */
	f_user,					/* USER */
	f_netif,				/* network interface */
	f_memory,				/* memory */
	f_loadave,				/* load average */
	f_pid,					/* process by id */
	f_buf, 					/* buffer cache */
	f_ni, 					/* NFS */
	f_namei,				/* namei_cache */
	f_panic,				/* The Panic! record */
};
