/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 screen.h
 *	Date:	 4/22/88
 *	Version: 1.33
 *
 *	screen.h - #defines for placement of info on the screen.
 */
#define	HOST_X		(0)
#define	HOST_Y		(0)
#define	HOST_FORMAT	"%-*.*s"
#define HOST_LEN	12

#define	LOADAVE_X	(42)		/* 13 */
#define	LOADAVE_Y	(0)
#define	LOADAVE_FORMAT	"%6.2f "

#define	DATE_X		(15)		/* 40 */
#define	DATE_Y		(0)
#define	DATE_FORMAT	"%s"
#define	DATE_LEN	23

#define	USER_X		(68)
#define	USER_Y		(0)

#define	PROC_X		(0)		/* 0 */
#define	PROC_Y		(2)		/* 2 */
#define	PROC_OFF	(6)
#define PROC_LEN	(21)
#define	PROC_HEADING	"Proc:  rq  dw  pw  sl"
#define PROC_FORMAT	"%3d %3d %3d %3d"

#define	FREE_X		(24)
#define	FREE_Y		(2)
#define	FREE_OFF	(3)
#define	FREE_LEN	(9)
#define	FREE_FORMAT	"%6d"
#define	FREE_HEADING	"Mem: free"

#define MEMORY_X	(24)
#define MEMORY_Y	(2)
#define MEMORY_OFF	(4)
#define	MEMORY_LEN	(31)
#define	MEMORY_HEADING	"Mem:  real   virt   vact   free"
#define	MEMORY_FORMAT	"%6d %6d %6d %6d"

#define	FORK_X		(58)
#define	FORK_Y		(2)
#define	FORK_OFF	(5)
#define	FORK_LEN	(18)
#define	FORK_HEADING	"Forks: fork  vfork"
#define	FORK_FORMAT	"%6.2f %6.2f"

#define	CPU_X		(0)
#define	CPU_Y		(11) 
#define CPU_OFF		(5)
#define CPU_OFF_1	(33)
#define	CPU_LEN		(45)
#define	CPU_HEADING	"CPU: user nice  sys idle  swtch   intr  scall"
#define	CPU_FORMAT	" %3.0f  %3.0f  %3.0f  %3.0f  %5.0f"
#define	CPU_FORMAT_1	"%5.0f  %5.0f"

#define	TTY_X		(58)
#define	TTY_Y		(5)
#define	TTY_OFF		(4)
#define	TTY_LEN		(18)
#define	TTY_HEADING	"Char:   in     out"
#define	TTY_FORMAT	"%6.1f %7.1f"

#define	DISK_X		(58)
#define	DISK_Y		(8)
#define	DISK_OFF	(6)
#define	DISK_LEN	(21)
#define	DISK_MORE	(57)
#define	DISK_HEADING	"Disk: kbps  tps  msps"
#define	DISK_FORMAT	"%4.0f  %3.0f %5d"

#define	TOTAL_OFF	(5)
#define	TOTAL_FORMAT	"%5.0f %4.0f"
#define	TOTAL_LINE	"---------------------"

#define	PAGE_X		(0)	/* interesting pageing info */
#define	PAGE_Y		(5)
#define	PAGE1_OFF	(6)
#define	PAGE1_LEN	(54)
#define	PAGE1_HEADING	"Paging: re   at   pin  pout   def  swi  swo  flts  prf"
#define	PAGE1_FORMAT	"%4d %4d %5d %5d %5d %4d %4d %5d %4d"

#define	PAGE2_X		(7)	/* the other pageing info */
#define	PAGE2_Y		(8)
#define	PAGE2_OFF	(-1)
#define	PAGE2_LEN	(46)
#define	PAGE2_HEADING	"oprs   sr    fr  nxf   xf   nzf   zf  nrf   rf"
#define	PAGE2_FORMAT	"%5d %4d %5d %4d %4d %5d %4d %4d %4d"

#define	NETIF_X		(0)
#define	NETIF_Y		(14)
#define	NETIF_OFF	(8)
#define	NETIF_LEN	(42)
#define	NETIF_MORE	(71)
#define	NETIF_HEADING	"Net:     ipkts  ierrs  opkts  oerrs collis"
#define	NETIF_FORMAT	"%6.1f %6.1f %6.1f %6.1f %6.1f"
