/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 read_kernel.c
 *	Date:	 1/13/89
 *	Version: 1.12
 *
 *	read_kernel.c - Function to read stuff from kernel space.
 */
#ifndef	lint
static	char	SccsId[] = "@(#)read_kernel.c	1.12 (monitor) 1/13/89" ;
#endif

/*
 * Modification history.
 *
 * 1/12/89 -- arr
 *
 *	Added get_word().  It will be used a lot by the
 *	swap code and anything else that only needs a 
 *	longword.
 */

#include <sys/types.h>
#include <sys/file.h>

#include <stdio.h>

/*
 *	Functions that don't return (int).
 */
long	lseek() ;

/*
 *	Module name for error functions.
 */
static	char	*module = "read_kernel" ;
extern	char	*program_name ;

extern	int	kmem, mem, swap ;

/*
 *	Seek to "where" in /dev/kmem and read a longword
 *	into "longword" and then return it.  This may take
 *	an file descriptior later to make it more general.
 */
get_word(where)
long	where ;
{
	long	longword ;

	if( lseek(kmem, where, L_SET) == -1 )
		fatal("Can't lseek in /dev/kmem: %s.\n", module);

	if( read(kmem, (char *)&longword, sizeof(long)) == -1 )
		fatal("Can't read from /dev/kmem: %s.\n", module);

	return longword ;
}

/*
 *	Seek to "where" in the kernel and read "size" bytes
 *	into the space at "addr".
 */
readk(where, addr, size)
long	where ;
char	*addr ;
int	size ;
{
	long	lseek() ;

	if( lseek(kmem, where, L_SET) == -1 )
		fatal("Can't lseek in /dev/kmem: %s.\n", module);

	if( read(kmem, addr, size) == -1 )
		fatal("Can't read from /dev/kmem: %s.\n", module);
}

/*
 *	Seek to "where" in physical memory and read "size" bytes in
 *	the space at "addr".
 */
readm(where, addr, size)
long	where ;
char	*addr ;
int	size ;
{
	long	lseek() ;

	if( lseek(mem, where, L_SET) == -1 )
		fatal("Can't lseek in /dev/mem: %s.\n", module);

	if( read(mem, addr, size) == -1 )
		fatal("Can't read from /dev/mem: %s.\n", module);
}

/*
 *	Read stuff from the swap device.
 */
reads(where, addr, size)
long	where ;
char	*addr ;
int	size ;
{
	long	lseek() ;

	if( lseek(swap, where, L_SET) == -1 )
		fatal("Can't lseek in /dev/drum: %s.\n", module);

	if( read(swap, addr, size) == -1 )
		fatal("Can't read from /dev/drum: %s.\n", module);
}
