/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 get_records.c
 *	Date:	 8/21/90
 *	Version: 1.15
 *
 *	get_records.c - Functions to get data records.
 */
#ifndef	lint
static	char	SccsId[] = "@(#)get_records.c	1.15 (monitor) 8/21/90" ;
#endif

/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
 *
 * Feb. 15, 1989 -- arr
 *
 *	Set the mon_flag field from the header after it has been
 *	read. 
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
 */

#include <nlist.h>
#include <stdio.h>
#include <signal.h>
#include <curses.h>

#include <sys/types.h>
#include <sys/buf.h>
#include <sys/uio.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/dk.h>
#include <sys/param.h>
#include <sys/dir.h>

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

#include <sys/user.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <net/if.h>
#include <netinet/in.h>

#include "include.h"
#include "monitor.h"
#include "extern.h"

/*
 *	Module name for error functions.
 */
static	char	*module = "get_records" ;

/*
 *	Read the next record of the file.  It will probably be a FIRST,
 *	LAST or SAMPLE record.  The record type will be returned.  If
 *	an error occurs, the function will exit with a fatal error or
 *	return a -1.  The only non-fatal error condition is EOF.
 */
get_record(fd)
int	fd ;
{
	struct 	mon_header header ;
	register rc, type, size ;

/*
 *	Read the header of the next record in the file.
 *
 *	If an error occurs (rc == -1) exit with a fatal error.
 *
 *	Otherwise if EOF is reached (rc == 0) and return -1.
 */
	if((rc = read(fd, (char *)&header, MON$S_HEADER)) == -1 )
		fatal("Can't read record header: %s.\n", module);
	else if( rc == 0 )
		return -1 ;

/*
 *	Save the record type and the (remainder of the) record size.
 *	Then read in the rest of that record.
 */
	type = header.mon_type ;
	size = header.mon_length - MON$S_HEADER ;

	((struct mon_header *)records[type].addr)->mon_flag = header.mon_flag ;

	if( read(fd, records[type].addr + MON$S_HEADER, size) <= 0 )
		fatal("Can't read rest of record: %s.\n", module);

	return type ;
}

/*
 *	Read a sample.  Return only if successful.  This
 *	requires that an I/O vector usable with readv(2)
 *	already be setup.
 */
void	get_sample(fd, mon_iov, n)
int	fd, n ;
struct iovec *mon_iov ;
{
	register rc ;

	if((rc = readv(fd, mon_iov, n)) < 0 )
		fatal("Can't read data sample: %s.\n", module) ;
	else if( rc == 0 )
		fatal("Unexpected EOF.\n", module);
	else
		return ;
}
