/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 fork.c
 *	Date:	 3/29/90
 *	Version: 1.7
 *
 *	fork.c - Functions to handle the fork data.
 */
#ifndef	lint
static	char	SccsId[] = "@(#)fork.c	1.7 (monitor) 3/29/90" ;
#endif

/*
 * Modification history.
 *
 * Mar. 6, 1989 -- arr
 *
 *	Redesign magnification screen.
 *
 * March 11, 1989 -- arr
 *
 *	Changes needed for change to mon_fork structure in monitor.h.
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
 */

#include <nlist.h>
#include <stdio.h>
#include <signal.h>
#include <curses.h>

#include <sys/types.h>
#include <sys/dk.h>
#include <sys/param.h>
#include <sys/dir.h>

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

#include <sys/user.h>
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <net/if.h>
#include <netinet/in.h>

#include "include.h"
#include "options.h"
#include "monitor.h"
#include "extern.h"

/*
 *	Each magnify function has to remember when it was last run
 *	so that it can maintain the correct elapsed time.
 *
 *	These will need to be external and have to be reset for
 *	session being replayed.
 */
int	fork_ticks = 0 ;
struct  mon_fork old_fork ;

/*
 *	Default display.
 */
extern	int	lines ;		/* length of the screen being used. */
extern	WINDOW	*wp ;

/*
 *	Calculate the change in the interesting fork stats.
 */
double	delta_fork(ticks)
int	ticks ;
{
	register t ;
	double	 etime ;

	etime = (double)(ticks - fork_ticks)/first.mon_hz ;

	t = mon_fork.mon_fork ;
	    mon_fork.mon_fork -= old_fork.mon_fork ;
	    old_fork.mon_fork = t ;

	t = mon_fork.mon_vfork ; 
	    mon_fork.mon_vfork -= old_fork.mon_vfork ;
	    old_fork.mon_vfork = t ;

	t = mon_fork.mon_fork_size ;
	    mon_fork.mon_fork_size -= old_fork.mon_fork_size ;
	    old_fork.mon_fork_size = t ;

	t = mon_fork.mon_vfork_size ;
	    mon_fork.mon_vfork_size -= old_fork.mon_vfork_size ;
	    old_fork.mon_vfork_size = t ;

	fork_ticks = ticks ;

	return etime ;
}
/*
 *	Constants for the placement of the FORK data.
 */
#define	FORK_OFFSET	 (20)
#define	FORK_OFFSET_RATE (36)
#define	FORK_BOOT	 (5)
#define	FORK_SAMPLE	 (13)

#define	FORK_LINES	(19)

/*
 *	Functions for doing fork stats.
 *
 *	ARGSUSED
 */
open_fork(op)
OPTION	*op ;
{
	sample_header() ;

	lines = FORK_LINES ;

	wprintw(wp, "Fork statistics since the system booted.\n\n") ;

	wprintw(wp, "Number of fork's:   %10d      %10.3f / second\n", 0, 0);
	wprintw(wp, "Size of fork's:     %10d Kb.  %10.3f Kb. / fork\n\n", 0, 0);

	wprintw(wp, "Number of vfork's:  %10d      %10.3f / second\n", 0, 0);
	wprintw(wp, "Size of vfork's:    %10d Kb.  %10.3f Kb. / vfork\n\n", 0, 0);

	wprintw(wp, "Fork statistics for this sample.\n\n") ;

	wprintw(wp, "Number of fork's:   %10d      %10.3f / second\n", 0, 0);
	wprintw(wp, "Size of fork's:     %10d Kb.  %10.3f Kb. / fork\n\n", 0, 0);

	wprintw(wp, "Number of vfork's:  %10d      %10.3f / second\n", 0, 0);
	wprintw(wp, "Size of vfork's:    %10d Kb.  %10.3f Kb. / vfork\n\n", 0, 0);

}

/*
 *	ARGSUSED
 */
magnify_fork(op)
OPTION	*op ;
{
	double	etime = sample.mon_ticks / first.mon_hz ;
	double	fork_size, vfork_size ;

	/*
	 *	Guard against division by zero.
	 */
	if( mon_fork.mon_fork == 0 )
		fork_size = 0.0 ;
	else
		fork_size = pgtok(mon_fork.mon_fork_size) / mon_fork.mon_fork ;

	if( mon_fork.mon_vfork == 0 )
		vfork_size = 0.0 ;
	else
		vfork_size = pgtok(mon_fork.mon_vfork_size) / mon_fork.mon_vfork ;

	if( etime == 0.0 )
		etime = 1.0 ;

	/*
	 *	The fork totals.
	 */
	wmove(wp, FORK_BOOT, FORK_OFFSET) ;
	wprintw(wp, "%10d      %10.3f / second\n",
		mon_fork.mon_fork, (double)mon_fork.mon_fork / etime);

	wmove(wp, FORK_BOOT + 1, FORK_OFFSET) ;
	wprintw(wp, "%10d Kb.  %10.3f Kb. / fork\n\n",
		pgtok(mon_fork.mon_fork_size), fork_size);

	wmove(wp, FORK_BOOT + 3, FORK_OFFSET) ;
	wprintw(wp, "%10d      %10.3f / second\n",
		mon_fork.mon_vfork, (double)mon_fork.mon_vfork / etime);

	wmove(wp, FORK_BOOT + 4, FORK_OFFSET) ;
	wprintw(wp, "%10d Kb.  %10.3f Kb. / vfork\n\n",
		pgtok(mon_fork.mon_vfork_size), vfork_size);

	/*
	 *	The amount of change since the last sample.
	 */
	etime = delta_fork(sample.mon_ticks) ;

	/*
	 *	Guard against division by zero.
	 */
	if( mon_fork.mon_fork == 0 )
		fork_size = 0.0 ;
	else
		fork_size = pgtok(mon_fork.mon_fork_size) / mon_fork.mon_fork ;

	if( mon_fork.mon_vfork == 0 )
		vfork_size = 0.0 ;
	else
		vfork_size = pgtok(mon_fork.mon_vfork_size) / mon_fork.mon_vfork ;

	if( etime == 0.0 )
		etime = 1.0 ;

	/*
	 *	The fork totals.
	 */
	wmove(wp, FORK_SAMPLE, FORK_OFFSET) ;
	wprintw(wp, "%10d      %10.3f / second\n",
		mon_fork.mon_fork, (double)mon_fork.mon_fork / etime);

	wmove(wp, FORK_SAMPLE + 1, FORK_OFFSET) ;
	wprintw(wp, "%10d Kb.  %10.3f Kb. / fork\n\n",
		pgtok(mon_fork.mon_fork_size), fork_size);

	wmove(wp, FORK_SAMPLE + 3, FORK_OFFSET) ;
	wprintw(wp, "%10d      %10.3f / second\n",
		mon_fork.mon_vfork, (double)mon_fork.mon_vfork / etime);

	wmove(wp, FORK_SAMPLE + 4, FORK_OFFSET) ;
	wprintw(wp, "%10d Kb.  %10.3f Kb. / vfork\n\n",
		pgtok(mon_fork.mon_vfork_size), vfork_size);

	sample_body(etime) ;
}


/*
 *	Initialize whatever static counters need to be initialized.
 */
setup_fork()
{
	old_fork.mon_fork = 0 ;
	old_fork.mon_vfork = 0 ;
	old_fork.mon_fork_size = 0 ;
	old_fork.mon_vfork_size = 0 ;

	fork_ticks = 0 ;
}

/*
 *	Function to dump the contents of the FORK record.
 */
f_fork(p)
struct mon_fork *p ;
{
	if((p->mon_flag & MON$M_VALID) == 0 )
		return ;

	printf("%s.\n", records[MON$C_FORK].string) ;

	printf("\tmon_fork:       %d\n", p->mon_fork);
	printf("\tmon_vfork:      %d\n", p->mon_vfork);
	printf("\tmon_fork_size:  %d Kb.\n", pgtok(p->mon_fork_size));
	printf("\tmon_vfork_size: %d Kb.\n", pgtok(p->mon_vfork_size));
}
