/*
 *	Author:  Alan Rollow, EIS/CXO, Digital Equipment Corp.
 *	File:	 float.c
 *	Date:	 3/29/90
 *	Version: 1.6
 *
 *	float.c - Handle floating point conversions.
 */
#ifndef	lint
static	char	SccsId[] = "@(#)float.c	1.6 (monitor) 3/29/90" ;
#endif

/*
 * Modification history.
 *
 * May 9, 1989 -- arr
 *
 *	Added code to use VAX/IEEE floating point conversion functions.
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
 */

#include <nlist.h>
#include <stdio.h>
#include <signal.h>

#include <sys/types.h>
#include <sys/dk.h>
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <sys/dir.h>

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

#include <sys/param.h>
#include <sys/user.h>

#include <net/if.h>
#include <netinet/in.h>

#include "monitor.h"
#include "options.h"
#include "include.h"
#include "extern.h"

/*
 *	Local data used by the panic function.
 */
static	char	*module = "float" ;

/*
 *	Depending on the architecture of the data a pair of floating
 *	point conversion functions are chosen, one for D float/IEEE
 *	double (LOADAVE) and one for F float/IEEE single (DISK).
 */
convert_fp(op)
OPTION	*op ;
{
	register i ;
	double	 dtoi(), itod(), ftoi(), itof() ;
	double	 (*disk_filter)(), (*load_filter)() ;

	/*
	 *	Choose the right function to do the data conversion.
	 */
	if( first.mon_arch == MON$C_VAX ) {	/* convert D/F Float to IEEE */
		load_filter = dtoi ;
		disk_filter = ftoi ;
	}
	else if( first.mon_arch == MON$C_MIPS ) { /* convert IEEE to D/F float */
		load_filter = itod ;
		disk_filter = itof ;
	}
	else
		panic("Unknown architecture!\n", module) ;
		
	/*
	 *	Convert the load averages.  If the number can't be
	 *	converted for some reason, use -1.
	 */
	if( op->opt_loadave )
		for(i = 0; i < MON$N_LOADAVE; i++)
			if((*load_filter)(&loadave.mon_loadave[i]) == -1 )
				loadave.mon_loadave[i] = -1.0 ;

	/*
	 *	Convert the disk data.  If the value can't be converted
	 *	use 0.0.
	 */
	if( op->opt_disk )
		for(i = 0; i < first.mon_disk; i++)
			if((*disk_filter)(&disk[i].mon_mspw) == -1 )
				disk[i].mon_mspw = 0.0 ;
}
