/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 error.c
 *	Date:	 4/18/89
 *	Version: 1.18
 *
 *	error.c - Print error messages.
 *
 *	All error messages will have the form:
 *
 *		program_name: module: text.
 *
 *	"Program_name" will be set at the beginning of the options
 *	processing.  "Module" will be the 2nd argument passed.
 */
#ifndef	lint
static	char	SccsId[] = "@(#)error.c	1.18 (monitor) 4/18/89" ;
#endif

#include <stdio.h>
#include <curses.h>

#include "options.h"

/*
 *	Functions that don't return an (int).
 */
void	 exit(),
	 abort() ;

unsigned sleep() ;

/*
 *	Value of argv[0] to be printed with error messages.
 */
char	*program_name ;

/*
 *	Magick to keep lk(1) happy.
 */
#ifdef	vaxc
globalref readonly char *sys_errlist[] ;
#else
extern	char	*sys_errlist[] ;
#endif

extern	int	errno ;
extern	OPTION	option ;
extern	WINDOW	*wp ;			/* display options */

/*
 *	Fatal error messages are expected to have a system 
 *	error message associated with them and cause monitor 
 *	to exit.
 *
 * 	VARARGS
 */
fatal(format, module, arg)
char	*format, *module, *arg ;
{
	register save_errno = errno ;

	fprintf(stderr, "%s: %s: ", program_name, module) ;
	fprintf(stderr, format, sys_errlist[save_errno], arg);

	if( option.opt_curses )
		cleanup_screen() ;

	exit(save_errno);
}

/*
 *	Warning error messages are expected to have a system
 *	error message associated with them.  They do not cause
 *	monitor to exit.
 *
 * 	VARARGS
 */
warning(format, module, arg)
char	*format, *module, *arg ;
{
	register save_errno = errno ;

	if( option.opt_curses ) {
		wmove(wp, LINES - 1, 0) ;
		wprintw(wp, "%s: %s: ", program_name, module) ;
		wprintw(wp, format, sys_errlist[save_errno], arg);
		wrefresh(wp) ;
		(void)sleep(1);
	}
	else {
		fprintf(stderr, "%s: %s: ", program_name, module) ;
		fprintf(stderr, format, sys_errlist[save_errno], arg);
	}
}

/*
 *	Info is like warning except it doesn't print system
 *	error messages.
 *
 *	VARARGS
 */
info(format, module, arg1, arg2, arg3)
char	*format, *module, *arg1 ;
{
	if( option.opt_curses ) {
		wmove(wp, LINES - 1, 0) ;
		wprintw(wp, "%s: %s: ", program_name, module) ;
		wprintw(wp, format, arg1, arg2, arg3);
		wrefresh(wp) ;
		(void)sleep(1);
	}
	else {
		fprintf(stderr, "%s: %s: ", program_name, module) ;
		fprintf(stderr, format, arg1, arg2, arg3);
	}
}

/*
 *	A panic occurs when some impossible condition occurs.
 */
panic(message, module)
char	*message, *module ;
{
	fprintf(stderr, "%s: %s: ", program_name, module) ;
	fprintf(stderr, message);

	if( option.opt_curses )
		cleanup_screen() ;

	abort();
}
