h59848
s 00000/00000/00150
d D 1.3 86/05/19 19:58:27 alan 3 2
c 1.  Most of the code has been replaced by the iovec initialization in
c     save.c.  The write_first() code was moved to save.c.
c 
c 				This module is retired
c 
e
s 00004/00011/00146
d D 1.2 86/05/09 11:12:11 alan 2 1
c Extracted from save V1.5 or V1.6
e
s 00157/00000/00000
d D 1.1 86/05/09 10:26:53 alan 1 0
c date and time created 86/05/09 10:26:53 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - A collection of functions to do the actual writting of
 *		data to a file.
 */
#ifndef	lint
static	char	SccsId[] = "%W% %G%" ;
#endif

#include <nlist.h>
#include <stdio.h>
#include <signal.h>

#include <sys/types.h>
#include <sys/buf.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/dk.h>
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>

#include <net/if.h>
#include <netinet/in.h>

#include "extern.h"
#include "monitor.h"
#include "record.h"

static	int	first_time = 1 ;

/*
 *	This structure needs to be moved to an include file somewhere.
 */
struct table {
	char	*addr ;
	int	size ;
	char	*string ;
};

/*
 *	Finish initializing the "first" record and write it out.
 */
write_first(fd)
int	fd ;
{
	time_t	time() ;

	first.mon_pid = getpid();
	first.mon_sdate = time(0);

	if( write(fd, (char *)&first, MON$S_FIRST) == -1 )
		fatal("monitor: can't write first record: %s.\n");
}

/*
 *	Write out the record according to the opt_data field.  Some
 *	records are given special treatment.
 */
write_records(p, type, fd)
struct table *p ;
int	type, fd ;
{
	switch( type ) {
	case MON$K_DISK:
		write_disk(fd);
D 2
		printf("Write %d %s's.\n", n_disk, p->string);
E 2
		break ;
	case MON$K_TAPE:
		write_tape(fd);
D 2
		printf("Write %d %s's.\n", n_tape, p->string);
E 2
		break ;
	case MON$K_NETIF:
		write_netif(fd);
D 2
		printf("Write %d %s's.\n", n_netif, p->string);
E 2
		break ;
	case MON$K_STATE:
		write_state(fd);
D 2
		printf("Write %d %s's.\n", n_cpu, p->string);
E 2
		break ;
	default:
D 2
		printf("Write %s(%d).\n", p->string, 
			((struct mon_header *)(p->addr))->mon_type);

E 2
		if( write(fd, p->addr, p->size) == -1 )
			warning("monitor: write failed: %s\n");

		break ;
	}
}

/*
 *	Special case write function.
 */
write_disk(fd)
int	fd ;
{
D 2
	struct mon_disk *p ;
E 2
I 2
	struct mon_disk *p = disk ;
E 2

	while( p ) {
		if( write(fd, (char *)p, MON$S_DISK) == -1 )
			warning("monitor: can't write disk record: %s.\n");

		p = p->mon_next ;
	}
}

/*
 *	Special case write function.
 */
write_tape(fd)
int	fd ;
{
D 2
	struct mon_tape *p ;
E 2
I 2
	struct mon_tape *p = tape ;
E 2

	while( p ) {
		if( write(fd, (char *)p, MON$S_TAPE) == -1 )
			warning("monitor: can't write tape record: %s.\n");

		p = p->mon_next ;
	}
}

/*
 *	Special case write function.
 */
write_netif(fd)
int	fd ;
{
D 2
	struct mon_netif *p ;
E 2
I 2
	struct mon_netif *p = netif ;
E 2

	while( p ) {
		if( write(fd, (char *)p, MON$S_NETIF) == -1 )
			warning("monitor: can't write netif record: %s.\n");

		p = p->mon_next ;
	}
}

/*
 *	Special case write function.
 */
write_state(fd)
int	fd ;
{
D 2
	struct mon_state *p ;
E 2
I 2
	struct mon_state *p = state ;
E 2

	while( p ) {
		if( write(fd, (char *)p, MON$S_STATE) == -1 )
			warning("monitor: can't write state record: %s.\n");

		p = p->mon_next ;
	}
}
E 1
