h07185
s 00010/00002/00128
d D 1.19 89/01/04 10:45:54 alan 19 18
c V1.1 changes for MIPS support.  This is a check-point of the current
c support.
c 
e
s 00011/00001/00119
d D 1.18 88/06/27 18:17:35 alan 18 17
c changed include of monitor.h and record.h
e
s 00001/00001/00119
d D 1.17 87/11/18 16:41:15 alan 17 16
c V0.99 -> T1.0-1
e
s 00002/00011/00118
d D 1.16 87/08/12 15:27:06 alan 16 15
c error message clean up - V0.95
e
s 00001/00007/00128
d D 1.15 87/04/05 13:26:15 alan 15 14
c 1.  Modified uba.c and names.c to take advantage of V2 uba_device
c     structure and use the correct controller number for reporting
c     controller on bus.
c 2.  Fixed bug in iovec setup code that caused bad disk data to be
c     written out on a save.
c 
e
s 00001/00001/00134
d D 1.14 87/04/03 14:31:13 alan 14 13
c 1.  Mostly rearranged include files so that the sources would compile
c     using VAXC.
c 2.  Changed an error monitor that pcc let get by.
c 
e
s 00013/00059/00122
d D 1.13 87/02/05 16:30:16 alan 13 12
c See comment on V0.81 in version.c.
c 
e
s 00025/00023/00156
d D 1.12 87/01/21 16:38:01 alan 12 11
c This is the first pass at makeing changes to record.h.  The intent of
c this delta is to change record.h and update the files that broke so
c that they will compile and a runnable version is produced.  This
c version may not run correctly.  A few other changes were added at
c same time, which were related to the changes to record.h.  See the
c commentary on V0.68 in version.c.  The next couple of deltas will
c be clean up this one.
c 
e
s 00064/00004/00115
d D 1.11 86/11/17 17:03:34 alan 11 10
c See V0.53 in version.c.
c 
e
s 00001/00001/00118
d D 1.10 86/08/26 18:04:03 alan 10 9
c modify all SccsId strings
e
s 00002/00000/00117
d D 1.9 86/08/01 14:17:57 alan 9 8
c 1.  Remove some lint caused by the addition of extra arguments on 
c     error function.  It has been reduced to a  mininium but is still
c     there.
c 2.  Make totals for disk and tapes static instead of dynamic.
c 3.  Merged stack.c code into uba.c and mba.c.  There were some pointers
c     that needed to be changed.
c 
c TODO: There is still a bug in multiple session replay that causes the
c first disk I/O data to be negitive numbers.  Wierd...
c 
e
s 00045/00009/00072
d D 1.8 86/07/31 16:06:59 alan 8 7
c merge add_disk and add_tape from stack.c
e
s 00005/00005/00076
d D 1.7 86/07/11 19:27:30 alan 7 6
c Dust off LOTS of lint...
c 
e
s 00004/00023/00077
d D 1.6 86/06/29 15:48:04 alan 6 5
c Changed the handleing of "word=value" lists.
c 
e
s 00044/00014/00056
d D 1.5 86/05/28 15:57:36 alan 5 4
c First pass of changes in order to get data selection to work.  Data
c selection during the replay function still needs to be written.
c 
c 1.  Due to the heavy use of the code like:
c 
c 	if( nel ) {
c 		p = sprintf(buf, "%s%d", name, unit);
c 
c 		if( !bsearch(&p, base, nel, sizeof(key *), compare))
c 			;
c 	}
c I sould impliment it as a function somewhere.  Probably in the 2nd or
c third pass.
c 
e
s 00003/00006/00067
d D 1.4 86/05/07 10:07:17 alan 4 3
c changed lseek/read pairs to readk
e
s 00027/00053/00046
d D 1.3 86/05/06 17:56:28 alan 3 2
c cleaned up for real use.  Added code to netif.c for link listing interfaces
e
s 00000/00000/00099
d D 1.2 86/05/05 12:45:10 alan 2 1
c taken from ../names V1.1
e
s 00099/00000/00000
d D 1.1 86/05/05 12:44:05 alan 1 0
c date and time created 86/05/05 12:44:05 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
D 11
 *	%M% - Read device names from kernal.
E 11
I 11
 *	%M% - Read UNIBUS device names from kernel.
 *
 *	To simplify the view of the world Ultrix seems thinks that
 *	there are two kinds of busses.  The MASSBUS and the UNIBUS.
 *	All Q-BUS devices and most VAXBI nodes are made to look like
 *	UNIBUS devices.  For example:
 *
 *		The KDA50 looks like a UDA50.
 *		The KDB50 looks like a UDA50 on its own UNIBUS.
E 11
 */
#ifndef	lint
D 10
static	char	SccsId[] = "%W% %G%" ;
E 10
I 10
D 11
static	char	SccsId[] = "%W%	(monitor)	%G%" ;
E 11
I 11
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 11
E 10
#endif

I 18
/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of monitor.h to include.h.
 *
 *	Change include of record.h to monitor.h.
I 19
 *
 * 29-November-1988 -- arr
 *
 *	#ifdef out the world for the MIPS port.
E 19
 */

E 18
#include <nlist.h>
#include <stdio.h>
I 3
#include <signal.h>
E 3

#include <sys/types.h>
#include <sys/buf.h>
#include <sys/file.h>
I 12
D 13
#include <sys/devio.h>
E 13
E 12
I 3
#include <sys/socket.h>
#include <sys/dk.h>
I 12
#include <sys/param.h>
#include <sys/dir.h>
#include <sys/user.h>
E 12
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>
E 3

D 19
#include <vaxuba/ubavar.h>

E 19
I 3
#include <net/if.h>
#include <netinet/in.h>

I 19
#ifdef	vax
#	include <vaxuba/ubavar.h>
#endif

E 19
I 18
#include "include.h"
E 18
E 3
D 14
#include "extern.h"
E 14
D 3
#include "names.h"
E 3
I 3
#include "monitor.h"
D 18
#include "record.h"
E 18
I 5
#include "options.h"
I 14
#include "extern.h"
E 14
E 5
E 3

I 11
D 16
/*
 *	Module name for error messages.
 */
static	char	*module = "uba" ;

E 16
E 11
I 9
char	*strcpy() ;

I 11
/*
 *	Walk through the UNIBUS device list.
 */
E 11
E 9
D 5
uba_devices()
E 5
I 5
uba_devices(op)
OPTION	*op ;
E 5
{
I 19
#ifdef	vax
E 19
D 5
	struct uba_device uba_device, *up ;
	struct uba_driver driver ;
	struct uba_ctlr   *prevc = 0 ;
E 5
I 5
	struct	uba_device uba_device, *up ;
D 15
	struct	uba_driver driver ;
E 15
D 7
	struct	uba_ctlr   *prevc = 0 ;
E 7
I 6
D 13
	struct	list	   *list ;
E 13
E 6
D 12
	char	device[32] ;
E 12
I 12
	char	device[DEV_SIZE+1] ;
E 12
D 13
	int	type, unit ;
E 13
I 13
	int	unit ;
E 13
E 5

I 12
	device[DEV_SIZE] = '\0' ;

E 12
I 11
	/*
	 *	Make sure the beginning of the list is a reasonable
	 *	place.
	 */
E 11
D 3
	char	*controller, *drive ;
	char	device[32], *print_controller() ;
E 3
I 3
D 5
	char	*drive ;
	char	device[32];
E 3

E 5
D 3
	if( up = (struct uba_device *)namelist[NM_UBDINIT].n_value )
		printf("#\n#	{UNI,Q}BUS devices and controllers\n#\n");
E 3
I 3
	if((up = (struct uba_device *)namelist[NM_UBDINIT].n_value) == 0 )
		return ;
E 3

D 5
	if( up ) for ( ; ; ) {
E 5
I 5
	for ( ; ; ) {
I 11
		/*
		 * Read the next uba_device structure from the kernel.
		 */
E 11
E 5
D 3
		lseek(kmem, (long)up++, 0);
E 3
I 3
D 4
		lseek(kmem, (long)up++, L_SET);
E 3
		read(kmem, &uba_device, sizeof(uba_device));
E 4
I 4
D 7
		readk((long)up++, &uba_device, sizeof(uba_device));
E 7
I 7
		readk((long)up++, (char *)&uba_device, sizeof(uba_device));
E 7
E 4

I 11
		/*
		 * If the driver entry is 0, then we're at end of the list.
		 */
E 11
		if( uba_device.ui_driver == 0 )
			break ;

I 11
		/*
		 *	If the dk and slave number is -1 then
		 *	the device is probably a communication
		 *	device that we're not interested in.
		 */
E 11
D 3
		if( uba_device.ui_mi && uba_device.ui_mi != prevc ) {
			controller = print_controller(uba_device.ui_mi);
			prevc = uba_device.ui_mi ;
		}
E 3
I 3
D 13
		if( uba_device.ui_dk == -1 && uba_device.ui_slave == -1 )
E 13
I 13
		if( uba_device.ui_dk == -1 || op->opt_disk == 0 )
E 13
			continue ;
E 3

I 11
		/*
D 13
		 *	If the dk number is -1 then it is a tape,
		 *	otherwise it's a disk.
		 */
E 11
I 8
		type = ( uba_device.ui_dk == -1 ) ? TAPE : DISK ;

I 11
		/*
		 *	See if want information on this type of
		 *	of device.
		 */
E 11
		if( type == TAPE && op->opt_tape == 0 )
			continue ;

		if( type == DISK && op->opt_disk == 0 )
			continue ;

I 11
		/*
E 13
D 15
		 *	Get the contents of the driver structure.
		 */
E 11
E 8
D 3
		lseek(kmem, (long)uba_device.ui_driver, 0);
E 3
I 3
D 4
		lseek(kmem, (long)uba_device.ui_driver, L_SET);
E 3
		read(kmem, &driver, sizeof(driver));
E 4
I 4
D 7
		readk((long)uba_device.ui_driver, &driver, sizeof(driver));
E 7
I 7
		readk((long)uba_device.ui_driver, (char *)&driver, sizeof(driver));
E 7
E 4

I 11
		/*
E 15
		 *	Read the device name and save the unit number.
		 */
E 11
D 3
		lseek(kmem, (long)driver.ud_dname, 0);
E 3
I 3
D 4
		lseek(kmem, (long)driver.ud_dname, L_SET);
E 3
		read(kmem, device, sizeof(device));
E 4
I 4
D 12
		readk((long)driver.ud_dname, device, sizeof(device));
E 12
I 12
D 15
		readk((long)driver.ud_dname, device, DEV_SIZE);
E 15
I 15
		readk((long)uba_device.ui_devname, device, DEV_SIZE);
E 15
E 12
E 4

I 5
		unit = uba_device.ui_unit ;

I 11
		/*
D 16
		 *	If the device is not "alive" print a warning
		 *	message and goto the next device.
E 16
I 16
		 *	If the device is not "alive" goto the next device.
E 16
		 */
E 11
E 5
I 3
D 16
		if( !uba_device.ui_alive ) {
D 5
			fprintf(stderr, "monitor: %s%d is not alive.\n",
				device, uba_device.ui_unit);
E 5
I 5
D 7
			printf("monitor: %s%d is not alive.\n", device, unit);
E 7
I 7
D 8
			fprintf(stderr, "monitor: uba: %s%d is not alive.\n",
				device, unit);
E 8
I 8
D 11
			info("monitor: uba: %s%d is not alive.\n", device, unit);
E 11
I 11
			info("%s%d is not alive.\n", module, device, unit);
E 16
I 16
		if( !uba_device.ui_alive )
E 16
E 11
E 8
E 7
E 5
			continue ;
D 16
		}
E 16

I 11
		/*
D 13
		 *	Based on the device type, see if it is
		 *	in the list of interesting devices.
E 13
I 13
		 *	See if this is an "interesting" device.
E 13
		 */
E 11
E 3
D 5
		if( uba_device.ui_dk == -1 )
D 3
			drive = "slave" ;
E 3
I 3
			push_device(device, &uba_device, UBA, TAPE);
E 3
		else
D 3
			drive = "drive" ;

		if( uba_device.ui_mi )
			printf("%s%d at %s%d %s %d %s alive.\n", 
				device, uba_device.ui_unit, 
				uba_device.ui_mi ? controller : "uba",
				uba_device.ui_ubanum, drive,
				uba_device.ui_slave,
				uba_device.ui_alive ? "is" : "is not");
		else
			printf("%s%d at uba%d %s alive.\n", 
				device, uba_device.ui_unit,
				uba_device.ui_ubanum,
				uba_device.ui_alive ? "is" : "is not");
E 3
I 3
			push_device(device, &uba_device, UBA, DISK);
E 5
I 5
D 8
		type = uba_device.ui_dk == -1 ? TAPE : DISK ;
E 8
I 8
D 13
		list = ( type == TAPE ) ? &tape_list : &disk_list ;
E 13
E 8
D 16

E 16
D 8
		if( type == TAPE && op->opt_tape == 0 )
E 8
I 8
D 13
		if( find_value(list, device, unit) == 0 )
E 13
I 13
		if( find_value(&disk_list, device, unit) == 0 )
E 13
E 8
			continue ;

I 11
D 13
		/*
		 *	Based on the device type, save the static
		 *	information about the device.  The final
		 *	"else" might be a panic, because a device
		 *	which isn't a TAPE or DISK would have been
		 *	skipped, but monitor tries to optimistic.
		 */
E 11
D 8
		if( type == DISK && op->opt_disk == 0 )
			continue ;
E 8
I 8
		if( type == TAPE ) {
D 12
			register struct mon_tape *tp ;
E 12
I 12
			tape[n_tape].mon_length = MON$S_TAPE ;
			tape[n_tape].mon_index = tape[n_tape].mon_tp = n_tape ;
			tape[n_tape].mon_type = MON$K_TAPE ;
			tape[n_tape].mon_flag = 1 ;
E 13
I 13
		disk[n_disk].mon_length = MON$S_DISK ;
		disk[n_disk].mon_index = n_disk ;
D 17
		disk[n_disk].mon_type = MON$K_DISK ;
E 17
I 17
		disk[n_disk].mon_type = MON$C_DISK ;
E 17
		disk[n_disk].mon_flag = 1 ;
E 13
E 12
E 8

D 6
		if( we_want_it(device, unit, type))
E 6
I 6
D 8
		list = type == TAPE ? &tape_list : &disk_list ;
E 8
I 8
D 12
			tp = tape + n_tape ;
E 12
I 12
D 13
			tape[n_tape].mon_name[DEV_SIZE] = '\0' ;
E 13
I 13
		disk[n_disk].mon_name[DEV_SIZE] = '\0' ;
E 13
E 12
E 8

D 8
		if( find_value(list, device, unit))
E 6
D 7
			push_device(device, &uba_device, UBA, type);
E 7
I 7
			push_device(device, (char *)&uba_device, UBA, type);
E 8
I 8
D 12
			tp->mon_length = MON$S_TAPE ;
			tp->mon_index = tp->mon_tp = n_tape++ ;
			tp->mon_type = MON$K_TAPE ;
			tp->mon_flag = 1 ;
E 12
I 12
D 13
			(void)strcpy(tape[n_tape].mon_name, device);
E 13
I 13
		(void)strcpy(disk[n_disk].mon_name, device);
E 13
E 12

D 12
			(void)strcpy(tp->mon_name, device);
E 12
I 12
D 13
			tape[n_tape].mon_unit = uba_device.ui_slave ;
E 13
I 13
		disk[n_disk].mon_dk = uba_device.ui_dk ;
		disk[n_disk].mon_unit = unit ;
E 13
E 12

D 12
			tp->mon_bus = uba_device.ui_ubanum ;
			tp->mon_unit = uba_device.ui_slave ;
			tp->mon_controller = uba_device.ui_ctlr ;
E 12
I 12
D 13
			n_tape++ ;
E 12
		}
		else if( type == DISK ) {
D 12
			register struct mon_disk *dp ;
E 12
I 12
			disk[n_disk].mon_length = MON$S_DISK ;
			disk[n_disk].mon_index = n_disk ;
			disk[n_disk].mon_type = MON$K_DISK ;
			disk[n_disk].mon_flag = 1 ;
E 12

D 12
			dp = disk + n_disk ;
E 12
I 12
			disk[n_disk].mon_name[DEV_SIZE] = '\0' ;
E 12

D 12
			dp->mon_length = MON$S_DISK ;
			dp->mon_index = n_disk++ ;
			dp->mon_type = MON$K_DISK ;
			dp->mon_flag = 1 ;
E 12
I 12
			(void)strcpy(disk[n_disk].mon_name, device);
E 12

D 12
			(void)strcpy(dp->mon_name, device);
E 12
I 12
			disk[n_disk].mon_dk = uba_device.ui_dk ;
			disk[n_disk].mon_unit = unit ;
E 12

D 12
			dp->mon_dk = uba_device.ui_dk ;
			dp->mon_bus = uba_device.ui_ubanum ;
			dp->mon_unit = unit ;
			dp->mon_controller = uba_device.ui_ctlr ;
E 12
I 12
			n_disk++ ;
E 12
		}
		else
D 11
			info("monitor: uba: unsupported device: %s%d.\n",
E 11
I 11
			info("unsupported device: %s%d.\n", module,
E 11
				device, uba_device.ui_unit);
E 13
I 13
		n_disk++ ;
E 13
E 8
E 7
E 5
E 3
	}
I 19
#endif
E 19
I 5
D 6
}

/*
 *	From the name, unit number and type, determine if we want to include
 *	this device in whatever list that it will get put in.
 */
we_want_it(name, unit, type)
char	*name ;
int	unit, type ;
{
	char	buf[BUFSIZ], *p, *sprintf() ;
	char	**base ;
	int	cmp(), nel ;

	if((nel = (type == TAPE) ? tape_nel : disk_nel) == 0 )
		return 1 ;

	base = type == TAPE ? tape_base : disk_base ;

	p = sprintf(buf, "%s%d", name, unit);

	return bsearch(&p, base, nel, KEY_SIZE, cmp) ;
E 6
E 5
D 3
}

char	*print_controller(p)
struct uba_ctlr *p ;
{
	struct	uba_ctlr uba_ctlr ;
	struct	uba_driver driver ;
	static	char	controller[32] ;

	lseek(kmem, (long)p, 0);
	read(kmem, &uba_ctlr, sizeof(uba_ctlr));

	if( uba_ctlr.um_driver == 0 )
		return NULL ;

	lseek(kmem, (long)uba_ctlr.um_driver, 0);
	read(kmem, &driver, sizeof(driver));

	lseek(kmem, (long)driver.ud_mname, 0);
	read(kmem, controller, sizeof(controller));

	printf("%s%d at uba%d %s alive.\n", controller, uba_ctlr.um_ctlr,
		uba_ctlr.um_ubanum,
		uba_ctlr.um_alive ? "is" : "is not");

	return controller ;
E 3
}
E 1
