h64724
s 00010/00000/00096
d D 1.22 90/03/29 16:17:28 alan 22 21
c The hack to fix the DECmumble include file problem.
e
s 00003/00000/00093
d D 1.21 89/05/07 22:44:08 alan 21 20
c added rusage structure to LAST record
e
s 00005/00000/00088
d D 1.20 89/02/15 20:13:21 alan 20 19
c correctly set mon_flag
e
s 00009/00002/00079
d D 1.19 89/01/04 11:01:05 alan 19 18
c Dust off lint acquired in V3.0
e
s 00009/00001/00072
d D 1.18 88/06/27 18:17:22 alan 18 17
c changed include of monitor.h and record.h
e
s 00001/00001/00072
d D 1.17 87/08/12 15:26:53 alan 17 16
c error message clean up - V0.95
e
s 00002/00001/00071
d D 1.16 87/04/03 15:51:17 alan 16 15
c Fix more includes to get rid of VAXC warning.  These were replaceing
c 
c 	#include <sys/vm.h>
c 
c with
c 
c 	#include <sys/vmsystm.h>
c 	#include <sys/vmmeter.h>
c 
c 
e
s 00005/00001/00067
d D 1.15 87/04/03 14:31:03 alan 15 14
c 1.  Mostly rearranged include files so that the sources would compile
c     using VAXC.
c 2.  Changed an error monitor that pcc let get by.
c 
e
s 00000/00001/00068
d D 1.14 87/02/05 16:30:11 alan 14 13
c See comment on V0.81 in version.c.
c 
e
s 00004/00000/00065
d D 1.13 87/01/21 16:37:50 alan 13 12
c This is the first pass at makeing changes to record.h.  The intent of
c this delta is to change record.h and update the files that broke so
c that they will compile and a runnable version is produced.  This
c version may not run correctly.  A few other changes were added at
c same time, which were related to the changes to record.h.  See the
c commentary on V0.68 in version.c.  The next couple of deltas will
c be clean up this one.
c 
e
s 00002/00002/00063
d D 1.12 86/12/07 22:22:09 alan 12 11
c See V0.57 in version.c
e
s 00001/00001/00064
d D 1.11 86/11/17 18:42:08 alan 11 10
c See commentary on V0.54 in version.c
c 
e
s 00006/00001/00059
d D 1.10 86/11/17 17:03:24 alan 10 9
c See V0.53 in version.c.
c 
e
s 00012/00005/00048
d D 1.9 86/11/16 16:56:23 alan 9 8
c See comments on V0.52 in version.c
c 
e
s 00001/00001/00052
d D 1.8 86/08/26 18:03:44 alan 8 7
c modify all SccsId strings
e
s 00001/00001/00052
d D 1.7 86/07/31 14:07:27 alan 7 6
c Change many fprintf's to info's and add arguments to assorted warning and
c fatal error messages.
c 
e
s 00002/00002/00051
d D 1.6 86/07/13 14:46:17 alan 6 5
c clean up error message
e
s 00007/00002/00046
d D 1.5 86/07/13 14:40:05 alan 5 4
c dust off even more lint
e
s 00004/00001/00044
d D 1.4 86/05/05 17:53:05 alan 4 3
c added more info about death
e
s 00016/00003/00029
d D 1.3 86/05/05 11:16:32 alan 3 2
c merge in code from ../record
e
s 00009/00001/00023
d D 1.2 86/04/24 17:37:02 alan 2 1
c added signals
e
s 00024/00000/00000
d D 1.1 86/04/24 17:07:10 alan 1 0
c date and time created 86/04/24 17:07:10 by alan
e
u
U
t
T
I 1
/*
 *	Author:  Alan Rollow, CSC/CS, Digital Equipment Corp.
 *	File:	 %M%
 *	Date:	 %G%
 *	Version: %I%
 *
 *	%M% - Various functions to handle signals which might be recieved.
 */
#ifndef	lint
D 8
static	char	SccsId[] = "%W% %G%" ;
E 8
I 8
D 9
static	char	SccsId[] = "%W%	(monitor)	%G%" ;
E 9
I 9
static	char	SccsId[] = "%W% (monitor) %G%" ;
E 9
E 8
#endif

I 18
/*
 * Modification History
 * 
 * 27-June-1988 -- arr
 *
 *	Change include of record.h to monitor.h.
I 19
 *
 * 28-December-1988 -- arr
 *
 *	Dust off V3.0 lint.
I 20
 *
 * Feb. 15, 1989 -- arr
 *
 *	Correctly set mon_flag with MON$M_VALID.
I 22
 *
 * Mar. 26, 1990 -- arr
 *
 *	Added hack to work-around DECmumble include file problem.
 *
E 22
E 20
E 19
 */

E 18
#include <signal.h>
I 2
D 3
#include <nlist.h>
E 3
I 3
#include <stdio.h>
E 3
E 2

I 2
#include <sys/types.h>
I 3
#include <sys/buf.h>
I 13
D 14
#include <sys/devio.h>
E 14
E 13
E 3
D 16
#include <sys/vm.h>
E 16
#include <sys/dk.h>
I 13
#include <sys/param.h>
#include <sys/dir.h>
I 22

#if defined(V4_ULTRIX) && defined(mips)
#	include <mips/cpu.h>
#endif

E 22
#include <sys/user.h>
E 13
I 3
#include <sys/socket.h>
I 16
#include <sys/vmsystm.h>
#include <sys/vmmeter.h>
E 16
E 3

D 3
#include "monitor.h"
E 3
I 3
#include <net/if.h>
#include <netinet/in.h>

I 9
#include "options.h"
E 9
E 3
D 15
#include "extern.h"
E 15
I 3
D 18
#include "record.h"
E 18
I 18
#include "monitor.h"
E 18
E 3

I 15
/*
 *	Data objects define somewhere else.
 */
E 15
I 5
extern	char	*sys_siglist[] ;
I 9
extern	OPTION	option ;
I 15
extern	int	killed ;
extern	struct mon_last last ;
E 15
E 9

E 5
E 2
/*
I 10
 *	Module name for error messages.
 */
static	char	*module = "signals" ;

/*
E 10
 *	Catch() - Attempt to die gracefully.
 *
 *	Do whatever is necessary to clean up, then send ourselves a
 *	wakeup, so we don't have to wait for sleep to expire.
I 9
 *
 *	Since most exit paths will go through here, we'll also save
 *	the time stamp, just before returning.
I 19
 *
 *	Tell lint that scp is being used even though it isn't.
 *
 *	ARGSUSED
E 19
E 9
 */
D 3
catch()
E 3
I 3
D 19
catch(sig, code, scp)
E 19
I 19
void	catch(sig, code, scp)
E 19
int	sig, code ;
struct sigcontext *scp ;
E 3
{
I 9
D 12
	time_t	time() ;
E 12
I 12
	long	time() ;
E 12

E 9
D 2
	kill(getpid, SIGALRM);
E 2
I 2
	killed = 1 ;
I 3

	last.mon_signal = sig ;
	last.mon_code = code ;
D 19
	last.mon_scp = *scp ;
E 19

D 4
	kill(getpid(), SIGALRM) ;
E 4
I 4
D 9
	if( !using_curses ) {
E 9
I 9
	if( option.opt_sleep && !option.opt_inter )
E 9
D 5
		kill(getpid(), SIGALRM) ;
		printf("Killed by signal #%d.\n", sig);
E 5
I 5
		if( kill(getpid(), SIGALRM) == -1 )
D 11
			warning("monitor: signals: can't cancel sleep: %s.\n");
E 11
I 11
D 17
			warning("can't cancel sleep: %s.\n", module);
E 17
I 17
			warning("Can't cancel sleep: %s.\n", module);
E 17
E 11

D 6
		fprintf(stderr, "monitor: signals: Killed by signal: %s(%d).\n",
			sys_siglist[sig], code);
E 6
I 6
D 7
		fprintf(stderr, "monitor: signals: Killed by signal: %s.\n",
E 7
I 7
D 9
		info("monitor: signals: Killed by signal: %s.\n",
E 7
			sys_siglist[sig]);
E 6
E 5
	}
E 9
I 9
D 10
	info("monitor: signals: Killed by signal: %s.\n", sys_siglist[sig]);
E 10
I 10
	info("Killed by signal: %s.\n", module, sys_siglist[sig]);
E 10

D 12
	last.mon_edate = time((time_t *)0) ;
E 12
I 12
	last.mon_edate = time((long *)0) ;
I 20
	last.mon_flag  = MON$M_VALID ;
I 21

	if( getrusage(RUSAGE_SELF, &last.mon_usage) == -1 )
		warning("Can't get resource information: %s.\n", module) ;
E 21
E 20
E 12
E 9
E 4
E 3
E 2
}
E 1
